/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.postgres;

import com.intellij.lang.LighterASTNode;
import com.intellij.lang.PsiBuilder;
import com.intellij.lang.parser.GeneratedParserUtilBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.resolve.FileContextUtil;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.tree.IElementType;
import com.intellij.sql.dialects.SqlLanguageDialectEx;
import com.intellij.sql.dialects.base.SqlGeneratedParserUtil;
import com.intellij.sql.dialects.base.SqlParser;
import com.intellij.sql.dialects.base.SqlParserUtil;
import com.intellij.sql.dialects.common.SqlGeneratedParser;
import com.intellij.sql.dialects.functions.SqlFunctionDefinition;
import com.intellij.sql.dialects.postgres.PgTypes;
import com.intellij.sql.dialects.postgres.PostgresElementTypes;
import com.intellij.sql.psi.SqlCommonTokens;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.SqlTokens;
import com.intellij.util.ObjectUtils;

public abstract class PostgresParserBase
extends SqlParser {
    int codeBlockMode;
    private boolean myPsqlSameLine;

    public PostgresParserBase(SqlLanguageDialectEx dialect) {
        super(dialect);
    }

    @Override
    protected boolean allowNoopStringConcatenation(PsiBuilder builder, boolean first) {
        boolean result2;
        IElementType type = builder.getTokenType();
        boolean bl = result2 = type == SQL_STRING_TOKEN || SqlGeneratedParserUtil.isExternalParameterFirst(type) || this.getVariableType(builder) == SQL_PARAMETER_REFERENCE;
        if (result2 && !first) {
            result2 = false;
            int i2 = -1;
            while (true) {
                IElementType token;
                if ((token = builder.rawLookup(i2)) == null || SqlTokens.COMMENT_TOKENS.contains(token)) {
                    return false;
                }
                if (!SqlTokens.WS_TOKENS.contains(token)) break;
                if (StringUtil.contains((CharSequence)builder.getOriginalText(), (int)builder.rawTokenTypeStart(i2), (int)builder.rawTokenTypeStart(i2 + 1), (char)'\n')) {
                    result2 = true;
                }
                --i2;
            }
        }
        return result2;
    }

    @Override
    public boolean parseSqlStatement(PsiBuilder builder, int level) {
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)PG_PSQL_BACKSLASH) && (this.myPsqlSameLine || SqlParserUtil.endsWithNewLine(builder))) {
            return this.parsePsqlMetaCommand(builder, level);
        }
        if (SqlParserUtil.nextTokenIs(builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return this.parseCopyCommandInput(builder, level);
        }
        return false;
    }

    private boolean parseCopyCommandInput(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)SqlTokens.SQL_RAW_INPUT)) {
            return false;
        }
        PsiBuilder.Marker mark2 = builder.mark();
        PsiBuilder.Marker mark22 = builder.mark();
        builder.advanceLexer();
        mark22.done((IElementType)SqlCompositeElementTypes.SQL_INJECTABLE_RAW_INPUT);
        mark2.done((IElementType)PostgresElementTypes.Misc.PG_PSQL_META_COMMAND);
        SqlParserUtil.consumeToken(builder, (IElementType)SqlCommonTokens.PG_COPY_TERMINATOR);
        this.statementSeparatorParsed(builder);
        return true;
    }

    private boolean parsePsqlMetaCommand(PsiBuilder builder, int level) {
        if (!SqlParserUtil.nextTokenIs(builder, (IElementType)PG_PSQL_BACKSLASH)) {
            return false;
        }
        this.myPsqlSameLine = false;
        PsiBuilder.Marker mark2 = builder.mark();
        builder.advanceLexer();
        if (builder.rawLookup(0) == PG_PSQL_BACKSLASH) {
            builder.advanceLexer();
        } else {
            SqlGeneratedParserUtil.parseAsTree(builder, level, (IElementType)SqlCompositeElementTypes.SQL_GENERIC_ELEMENT, true, GeneratedParserUtilBase.TOKEN_ADVANCER, new GeneratedParserUtilBase.Parser(){

                public boolean parse(PsiBuilder builder, int level) {
                    return !(PostgresParserBase.this.myPsqlSameLine = SqlParserUtil.nextTokenIs(builder, (IElementType)SqlCommonTokens.PG_PSQL_BACKSLASH)) && !SqlParserUtil.endsWithNewLine(builder);
                }
            });
        }
        mark2.done((IElementType)PostgresElementTypes.Misc.PG_PSQL_META_COMMAND);
        this.statementSeparatorParsed(builder);
        return true;
    }

    @Override
    public boolean consumeUnderscoreAndCharSpec(PsiBuilder builder) {
        return false;
    }

    @Override
    public boolean mergeOperatorWithQuestionMark(PsiBuilder builder) {
        PsiLanguageInjectionHost host = InjectedLanguageUtil.findInjectionHost((PsiElement)((PsiElement)builder.getUserData(FileContextUtil.CONTAINING_FILE_KEY)));
        return host == null;
    }

    @Override
    protected boolean parsingOperatorsAsIdentifier() {
        return false;
    }

    @Override
    protected boolean parseExternalParameterImpl(PsiBuilder builder, boolean checkStart, boolean checkEnd) {
        if (this.getVariableType(builder) == SQL_PARAMETER_REFERENCE) {
            return this.parseParameterReferenceInner(builder, (IElementType)SQL_PARAMETER_REFERENCE);
        }
        return super.parseExternalParameterImpl(builder, checkStart, checkEnd);
    }

    @Override
    public IElementType consumeCustomParameterReference(PsiBuilder builder) {
        IElementType result2 = SqlParserUtil.nextTokenIs(builder, (IElementType)SQL_CUSTOM_LQUOTE) ? this.parseStringLiteralInner(builder) : super.consumeCustomParameterReference(builder);
        return result2;
    }

    @Override
    public boolean parseFunctionParametersStart(PsiBuilder builder, int level, SqlFunctionDefinition definition) {
        boolean ignored = SqlParserUtil.consumeOptionalToken(builder, PgTypes.PG_ALL) || SqlParserUtil.consumeOptionalToken(builder, PgTypes.PG_DISTINCT);
        return true;
    }

    @Override
    public boolean parseNamedFunctionArgumentPrefix(PsiBuilder builder, int level) {
        PsiBuilder.Marker mark2 = builder.mark();
        boolean result2 = this.parseReferenceExpression(builder, true, SQL_ARGUMENT_REFERENCE);
        if (result2 && !(result2 = SqlParserUtil.consumeToken(builder, true, (IElementType)SqlCommonTokens.SQL_OP_ASSIGN))) {
            result2 = GeneratedParserUtilBase.consumeToken((PsiBuilder)builder, (String)"=>");
        }
        if (result2) {
            mark2.drop();
        } else {
            mark2.rollbackTo();
        }
        return result2;
    }

    @Override
    public boolean argumentListRecover(PsiBuilder builder, int level) {
        return GeneratedParserUtilBase.nextTokenIsSmart((PsiBuilder)builder, (IElementType)PgTypes.PG_ORDER);
    }

    public boolean parseSchemaPath(PsiBuilder builder, int level, boolean strict) {
        if (strict) {
            IElementType type = builder.getTokenType();
            if (type == SQL_STRING_TOKEN) {
                return SqlParserUtil.advanceAsRefExpression(builder, SQL_SCHEMA_REFERENCE);
            }
            if (type == SQL_DEFAULT) {
                return true;
            }
        } else if ("search_path".equalsIgnoreCase(((LighterASTNode)ObjectUtils.assertNotNull((Object)builder.getLatestDoneMarker())).toString().trim())) {
            if (SqlParserUtil.consumeToken(builder, true, (IElementType)SQL_DEFAULT)) {
                return true;
            }
            SqlGeneratedParser.simple_list(builder, level, (b2, l) -> {
                GeneratedParserUtilBase.addVariant((PsiBuilder)builder, (String)"schema reference");
                PsiBuilder.Marker m = b2.mark();
                if (b2.getTokenType() != SQL_DEFAULT && this.consumeIdentifier(b2, true, true)) {
                    m.done((IElementType)SQL_IDENTIFIER);
                    m.precede().done((IElementType)SQL_SCHEMA_REFERENCE);
                    return true;
                }
                m.drop();
                return false;
            });
            return true;
        }
        return false;
    }
}

