/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.run.profile.settings;

import com.intellij.execution.ui.AdjustingTabSettingsEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ContextHelpLabel;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import com.jetbrains.nodejs.run.NodeJsRunConfiguration;
import com.jetbrains.nodejs.run.profile.settings.NodeProfilingSettings;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class NodeProfilingPanel<T extends NodeJsRunConfiguration>
extends SettingsEditor<T>
implements AdjustingTabSettingsEditor {
    private JBCheckBox myProfile;
    private TextFieldWithBrowseButton myLogFileField;
    private JPanel myMainPanel;
    private JPanel myViewerParameters;
    private JBCheckBox myAllowHeapProfiling;
    private JBLabel myNoteLabel;
    @NotNull
    private final Project myProject;
    private JBCheckBox myOneLogFile;

    public NodeProfilingPanel(@NotNull Project project) {
        if (project == null) {
            NodeProfilingPanel.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.$$$setupUI$$$();
    }

    @NotNull
    protected JComponent createEditor() {
        JPanel jPanel = this.myMainPanel;
        if (jPanel == null) {
            NodeProfilingPanel.$$$reportNull$$$0(1);
        }
        return jPanel;
    }

    protected void resetEditorFrom(@NotNull T rc) {
        boolean haveLogFile;
        if (rc == null) {
            NodeProfilingPanel.$$$reportNull$$$0(2);
        }
        NodeProfilingSettings settings = ((NodeJsRunConfiguration)((Object)rc)).getNodeProfilingSettings();
        ((GridLayoutManager)this.myMainPanel.getLayout()).setHGap(2);
        this.myProfile.setSelected(settings.isProfile());
        String text = StringUtil.notNullize((String)settings.getLogFolder());
        boolean bl = haveLogFile = settings.getLogFolder() != null;
        if (haveLogFile) {
            String basePath;
            File file = new File(text);
            if (!file.isAbsolute() && (basePath = this.myProject.getBasePath()) != null) {
                file = ".".equals(text) ? new File(basePath) : new File(basePath, text);
            }
            text = FileUtil.toSystemDependentName((String)file.getAbsolutePath());
        } else {
            text = this.myProject.getBasePath();
        }
        this.myLogFileField.setText(text);
        this.myOneLogFile.setSelected(settings.isOneLogFile());
        this.cpuEnabled(settings.isProfile());
        this.myAllowHeapProfiling.setSelected(settings.isAllowRuntimeHeapSnapshot());
    }

    protected void applyEditorTo(@NotNull T rc) {
        if (rc == null) {
            NodeProfilingPanel.$$$reportNull$$$0(3);
        }
        NodeProfilingSettings settings = ((NodeJsRunConfiguration)((Object)rc)).getNodeProfilingSettings();
        settings.setProfile(this.myProfile.isSelected());
        String text = this.getLogFileText();
        settings.setLogFolder(StringUtil.isEmptyOrSpaces((String)text) ? null : text);
        settings.setOneLogFile(this.myOneLogFile.isSelected());
        settings.setOpenViewer(true);
        settings.setAllowRuntimeHeapSnapshot(this.myAllowHeapProfiling.isSelected());
    }

    private String getLogFileText() {
        String relativePath;
        String text = this.myLogFileField.getText();
        String basePath = this.myProject.getBasePath();
        if (basePath != null && (relativePath = FileUtil.getRelativePath((String)FileUtil.toSystemIndependentName((String)basePath), (String)FileUtil.toSystemIndependentName((String)text), (char)'/')) != null) {
            text = relativePath;
        }
        return text;
    }

    private void cpuEnabled(boolean value) {
        UIUtil.setEnabled((Component)this.myViewerParameters, (boolean)value, (boolean)true);
    }

    private void createUIComponents() {
        this.myProfile = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.record.checkbox", new Object[0]));
        this.myProfile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NodeProfilingPanel.this.cpuEnabled(NodeProfilingPanel.this.myProfile.isSelected());
            }
        });
        final FileChooserDescriptor folderDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        this.myLogFileField = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FileChooserDialog chooser = FileChooserFactory.getInstance().createFileChooser(folderDescriptor, NodeProfilingPanel.this.myProject, (Component)NodeProfilingPanel.this.myLogFileField);
                VirtualFile[] fileWrapper = chooser.choose(NodeProfilingPanel.this.myProject, new VirtualFile[]{NodeProfilingPanel.this.myProject.getBaseDir()});
                if (fileWrapper.length == 1) {
                    NodeProfilingPanel.this.myLogFileField.setText(fileWrapper[0].getPath());
                }
            }
        });
        FileChooserFactory.getInstance().installFileCompletion(this.myLogFileField.getTextField(), folderDescriptor, false, null);
        FormBuilder formBuilder = FormBuilder.createFormBuilder().setVerticalGap(2);
        formBuilder.addLabeledComponent(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.log.folder.label", new Object[0]), (JComponent)this.myLogFileField);
        this.myOneLogFile = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.cpu.one.log.file.checkbox", new Object[0]));
        formBuilder.addComponent((JComponent)this.myOneLogFile).addVerticalGap(4);
        this.myViewerParameters = formBuilder.getPanel();
        this.myAllowHeapProfiling = new JBCheckBox(NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.take.snapshots.checkbox", new Object[0]));
        this.myNoteLabel = ContextHelpLabel.create((String)NodeJSBundle.message("runConfiguration.nodejs.profiling.heap.inspect.explanation", new Object[0]));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/run/profile/settings/NodeProfilingPanel";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createEditor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetEditorFrom";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyEditorTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(4, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBCheckBox jBCheckBox = this.myProfile;
        jBCheckBox.setText("Record CPU profiling info");
        jPanel.add((Component)jBCheckBox, new GridConstraints(0, 0, 1, 4, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(3, 0, 1, 4, 0, 2, 1, 6, null, null, null));
        JBCheckBox jBCheckBox2 = this.myAllowHeapProfiling;
        jBCheckBox2.setText("Allow taking heap snapshots ");
        jPanel.add((Component)jBCheckBox2, new GridConstraints(2, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel = this.myNoteLabel;
        jPanel.add((Component)jBLabel, new GridConstraints(2, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(2, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JPanel jPanel2 = this.myViewerParameters;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 4, 0, 3, 3, 3, null, null, null, 5));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }
}

