/*
 * Decompiled with CFR 0.152.
 */
package br.arca.morcego;

import br.arca.morcego.Morcego;
import java.awt.Color;
import java.lang.reflect.Field;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;

public class Config {
    private static Hashtable config = new Hashtable();
    public static final String backgroundColor = "morcego.backgroundColor";
    public static final String linkDefaultColor = "morcego.linkColor";
    public static final String nodeDefaultType = "morcego.nodeDefaultType";
    public static final String nodeDefaultColor = "morcego.nodeDefaultColor";
    public static final String nodeDefaultImage = "morcego.nodeDefaultImage";
    public static final String nodeBorderColor = "morcego.nodeBorderColor";
    public static final String linkDefaultType = "morcego.linkDefaultType";
    public static final String descriptionColor = "morcego.descriptionColor";
    public static final String descriptionBackground = "morcego.descriptionBackground";
    public static final String descriptionBorder = "morcego.descriptionBorder";
    public static final String descriptionMargin = "morcego.descriptionMargin";
    public static final String nodeSize = "morcego.nodeSize";
    public static final String textSize = "morcego.textSize";
    public static final String cameraDistance = "morcego.cameraDistance";
    public static final String minCameraDistance = "morcego.minCameraDistance";
    public static final String fieldOfView = "morcego.fieldOfView";
    public static final String width = "morcego.width";
    public static final String height = "morcego.height";
    public static final String maxTheta = "morcego.maxTheta";
    public static final String minTheta = "morcego.minTheta";
    public static final String minNodeSize = "morcego.minNodeSize";
    public static final String navigationDepth = "morcego.navigationDepth";
    public static final String feedAnimationInterval = "morcego.feedAnimationInterval";
    public static final String balancingStepInterval = "morcego.balancingStepInterval";
    public static final String fontSizeInterval = "morcego.fontSizeInterval";
    public static final String controlWindowName = "morcego.controlWindowName";
    public static final String renderingFrameInterval = "morcego.renderingFrameInterval";
    public static final String serverUrl = "morcego.serverUrl";
    public static final String transport = "morcego.transportClass";
    public static final String startNode = "morcego.startNode";
    public static String _imageLocation = "morcego._imageLocation";
    public static String showMorcegoLogo = "morcego.showMorcegoLogo";
    public static String logoX = "morcego.logoX";
    public static String logoY = "morcego.logoY";
    public static String showArcaLogo = "morcego.showArcaLogo";
    public static String arcaX = "morcego.arcaX";
    public static String arcaY = "morcego.arcaY";
    public static String frictionConstant = "morcego.frictionConstant";
    public static String elasticConstant = "morcego.elasticConstant";
    public static String eletrostaticConstant = "morcego.eletrostaticConstant";
    public static String nodeMass = "morcego.nodeMass";
    public static String nodeCharge = "morcego.nodeCharge";
    public static String springSize = "morcego.springSize";
    public static String punctualElasticConstant = "morcego.punctualElasticConstant";
    public static String loadPageOnCenter = "morcego.loadPageOnCenter";
    public static String centerNodeScale = "morcego.centerNodeScale";
    public static String graphIsTree = "morcego.graphIsTree";
    public static String windIntensity = "morcego.windIntensity";
    public static String originX = "morcego.originX";
    public static String originY = "morcego.originY";
    public static String cameraDepth = "morcego.cameraDepth";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;

    public static void init() {
        Config.setValue(serverUrl, "http://morcego.arca.ime.usp.br/tiki-wiki3d_xmlrpc.php");
        Config.setValue(startNode, "HomePage");
        if (Morcego.getApplication() != null) {
            Config.setValue(width, new Integer(Morcego.getApplication().getBounds().width));
            Config.setValue(height, new Integer(Morcego.getApplication().getBounds().height));
            Config.setValue(originX, new Integer(Config.getInteger(width) / 2));
            Config.setValue(originY, new Integer(Config.getInteger(height) / 2));
        } else {
            Config.setValue(width, new Integer(100));
            Config.setValue(height, new Integer(100));
            Config.setValue(originX, new Integer(50));
            Config.setValue(originY, new Integer(50));
        }
        Config.setValue(showMorcegoLogo, new Boolean("true"));
        Config.setValue(logoX, new Integer(10));
        Config.setValue(logoY, new Integer(10));
        Config.setValue(showArcaLogo, new Boolean("true"));
        Config.setValue(arcaX, new Integer(Config.getInteger(width) - 127));
        Config.setValue(arcaY, new Integer(Config.getInteger(height) - 40));
        Config.setValue(backgroundColor, new Color(255, 255, 255));
        Config.setValue(linkDefaultType, new String("Solid"));
        Config.setValue(linkDefaultColor, new Color(120, 120, 120));
        Config.setValue(nodeDefaultType, new String("Round"));
        Config.setValue(nodeDefaultColor, new Color(255, 0, 0));
        Config.setValue(nodeDefaultImage, new String("default.gif"));
        Config.setValue(textSize, new Integer(25));
        Config.setValue(nodeSize, new Integer(15));
        Config.setValue(minNodeSize, new Integer(0));
        Config.setValue(centerNodeScale, new Float(1.0f));
        Config.setValue(nodeBorderColor, new Color(0, 0, 0));
        Config.setValue(descriptionColor, new Color(40, 40, 40));
        Config.setValue(descriptionBackground, new Color(200, 200, 200));
        Config.setValue(descriptionBorder, new Color(0, 0, 0));
        Config.setValue(descriptionMargin, new Integer(4));
        Config.setValue(cameraDistance, new Integer(500));
        Config.setValue(cameraDepth, new Integer(250));
        Config.setValue(minCameraDistance, new Integer(150));
        Config.setValue(fieldOfView, new Integer(250));
        Config.setValue(frictionConstant, new Float(0.4f));
        Config.setValue(elasticConstant, new Float(0.3f));
        Config.setValue(punctualElasticConstant, new Float(0.8f));
        Config.setValue(eletrostaticConstant, new Float(1000.0f));
        Config.setValue(springSize, new Float(100.0f));
        Config.setValue(nodeMass, new Float(5.0f));
        Config.setValue(nodeCharge, new Float(1.0f));
        Config.setValue(windIntensity, new Float(10.0f));
        Config.setValue(maxTheta, new Float(20.0f));
        Config.setValue(minTheta, new Float(1.0f));
        Config.setValue(renderingFrameInterval, new Integer(50));
        Config.setValue(balancingStepInterval, new Integer(50));
        Config.setValue(fontSizeInterval, new Integer(5));
        Config.setValue(transport, "Xmlrpc");
        Config.setValue(feedAnimationInterval, new Integer(100));
        Config.setValue(loadPageOnCenter, new Boolean(false));
        Config.setValue(navigationDepth, new Integer(3));
        Config.setValue(controlWindowName, "morcegoController");
        Config.setValue(graphIsTree, new Boolean(false));
        Config.setValue(_imageLocation, new String("br/arca/morcego/image/"));
    }

    public static void setValue(String var, Object value) {
        config.put(var, value);
    }

    public static Object getValue(String var) {
        return config.get(var);
    }

    public static int getInteger(String var) {
        return (Integer)Config.getValue(var);
    }

    public static Color getColor(String var) {
        return (Color)Config.getValue(var);
    }

    public static String getString(String var) {
        return (String)Config.getValue(var);
    }

    public static boolean getBoolean(String var) {
        return (Boolean)Config.getValue(var);
    }

    public static Class getTransportClass() {
        return Config.getClass("br.arca.morcego.transport.", Config.getString(transport).concat("Transport"));
    }

    public static Class getNodeClass(String nodeType) {
        return Config.getClass("br.arca.morcego.structure.node.", nodeType.concat("Node"));
    }

    public static Class getLinkClass(String linkType) {
        return Config.getClass("br.arca.morcego.structure.link.", linkType.concat("Link"));
    }

    public static Class getClass(String domain, String className) {
        Class<?> localClass = null;
        try {
            className = domain.concat(className);
            localClass = Class.forName(className);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return localClass;
    }

    public static float getFloat(String var) {
        return ((Float)Config.getValue(var)).floatValue();
    }

    public static Enumeration listConfigVars() {
        return config.keys();
    }

    public static Object decode(String value, Class type) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz)) {
            return Integer.valueOf(value);
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz2)) {
            return Float.valueOf(value);
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz3)) {
            return value;
        }
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("java.lang.Boolean");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz4)) {
            return new Boolean(value);
        }
        Class<?> clazz5 = class$4;
        if (clazz5 == null) {
            try {
                clazz5 = class$4 = Class.forName("java.awt.Color");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz5)) {
            return Color.decode(value);
        }
        Class<?> clazz6 = class$5;
        if (clazz6 == null) {
            try {
                clazz6 = class$5 = Class.forName("java.net.URL");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type.equals(clazz6)) {
            try {
                return new URL(value);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return value;
    }

    public static boolean exists(String varName) {
        Field field;
        Class<?> configClass;
        try {
            configClass = Class.forName("br.arca.morcego.Config");
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        try {
            field = configClass.getDeclaredField(varName);
        }
        catch (Exception e) {
            return false;
        }
        try {
            return config.contains(field.get(null));
        }
        catch (Exception e) {
            return false;
        }
    }
}

