<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\MapsPlaces;

class GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction extends \Google\Collection
{
  protected $collection_key = 'types';
  /**
   * @var int
   */
  public $distanceMeters;
  /**
   * @var string
   */
  public $place;
  /**
   * @var string
   */
  public $placeId;
  protected $structuredFormatType = GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat::class;
  protected $structuredFormatDataType = '';
  protected $textType = GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText::class;
  protected $textDataType = '';
  /**
   * @var string[]
   */
  public $types;

  /**
   * @param int
   */
  public function setDistanceMeters($distanceMeters)
  {
    $this->distanceMeters = $distanceMeters;
  }
  /**
   * @return int
   */
  public function getDistanceMeters()
  {
    return $this->distanceMeters;
  }
  /**
   * @param string
   */
  public function setPlace($place)
  {
    $this->place = $place;
  }
  /**
   * @return string
   */
  public function getPlace()
  {
    return $this->place;
  }
  /**
   * @param string
   */
  public function setPlaceId($placeId)
  {
    $this->placeId = $placeId;
  }
  /**
   * @return string
   */
  public function getPlaceId()
  {
    return $this->placeId;
  }
  /**
   * @param GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat
   */
  public function setStructuredFormat(GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat $structuredFormat)
  {
    $this->structuredFormat = $structuredFormat;
  }
  /**
   * @return GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionStructuredFormat
   */
  public function getStructuredFormat()
  {
    return $this->structuredFormat;
  }
  /**
   * @param GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText
   */
  public function setText(GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText $text)
  {
    $this->text = $text;
  }
  /**
   * @return GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionFormattableText
   */
  public function getText()
  {
    return $this->text;
  }
  /**
   * @param string[]
   */
  public function setTypes($types)
  {
    $this->types = $types;
  }
  /**
   * @return string[]
   */
  public function getTypes()
  {
    return $this->types;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction::class, 'Google_Service_MapsPlaces_GoogleMapsPlacesV1AutocompletePlacesResponseSuggestionPlacePrediction');
