/*
 * Decompiled with CFR 0.152.
 */
package com.xerox.VTM.glyphs;

import com.xerox.VTM.engine.Camera;
import com.xerox.VTM.glyphs.VRectangle;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;

public class VRectangleOr
extends VRectangle {
    int[] xcoords = new int[4];
    int[] ycoords = new int[4];

    public VRectangleOr() {
    }

    public VRectangleOr(long x, long y, int z, long w, long h, Color c, float or) {
        super(x, y, z, w, h, c);
        this.orient = or;
    }

    public VRectangleOr(long x, long y, int z, long w, long h, Color c, Color bc, float or) {
        super(x, y, z, w, h, c);
        this.orient = or;
    }

    public float getOrient() {
        return this.orient;
    }

    public void orientTo(float angle) {
        this.orient = angle;
        try {
            this.vsm.repaintNow();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public boolean fillsView(long w, long h, int camIndex) {
        if (this.orient == 0.0f) {
            return w <= (long)(this.pc[camIndex].cx + this.pc[camIndex].cw) && 0 >= this.pc[camIndex].cx - this.pc[camIndex].cw && h <= (long)(this.pc[camIndex].cy + this.pc[camIndex].ch) && 0 >= this.pc[camIndex].cy - this.pc[camIndex].ch;
        }
        return this.pc[camIndex].p.contains(0, 0) && this.pc[camIndex].p.contains(w, 0.0) && this.pc[camIndex].p.contains(0.0, h) && this.pc[camIndex].p.contains(w, h);
    }

    public boolean visibleInDisc(long dvx, long dvy, long dvr, Shape dvs, int camIndex, int jpx, int jpy, int dpr) {
        if (this.orient == 0.0f) {
            return dvs.intersects(this.vx - this.vw, this.vy - this.vh, 2L * this.vw, 2L * this.vh);
        }
        return this.pc[camIndex].p.intersects(jpx - dpr, jpy - dpr, 2 * dpr, 2 * dpr);
    }

    public boolean coordInside(int jpx, int jpy, int camIndex, long cvx, long cvy) {
        if (this.orient == 0.0f) {
            return jpx >= this.pc[camIndex].cx - this.pc[camIndex].cw && jpx <= this.pc[camIndex].cx + this.pc[camIndex].cw && jpy >= this.pc[camIndex].cy - this.pc[camIndex].ch && jpy <= this.pc[camIndex].cy + this.pc[camIndex].ch;
        }
        return this.pc[camIndex].p.contains(jpx, jpy);
    }

    public void project(Camera c, Dimension d) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude);
        this.pc[i].cx = d.width / 2 + Math.round((float)(this.vx - c.posx) * this.coef);
        this.pc[i].cy = d.height / 2 - Math.round((float)(this.vy - c.posy) * this.coef);
        this.pc[i].cw = Math.round((float)this.vw * this.coef);
        this.pc[i].ch = Math.round((float)this.vh * this.coef);
        if (this.orient != 0.0f) {
            float x1 = -this.pc[i].cw;
            float y1 = -this.pc[i].ch;
            float x2 = this.pc[i].cw;
            float y2 = this.pc[i].ch;
            this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].cy);
            this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].cx);
            this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].cy);
            if (this.pc[i].p == null) {
                this.pc[i].p = new Polygon(this.xcoords, this.ycoords, 4);
            } else {
                for (int j = 0; j < this.xcoords.length; ++j) {
                    this.pc[i].p.xpoints[j] = this.xcoords[j];
                    this.pc[i].p.ypoints[j] = this.ycoords[j];
                }
                this.pc[i].p.invalidate();
            }
        }
    }

    public void projectForLens(Camera c, int lensWidth, int lensHeight, float lensMag, long lensx, long lensy) {
        int i = c.getIndex();
        this.coef = c.focal / (c.focal + c.altitude) * lensMag;
        this.pc[i].lcx = lensWidth / 2 + Math.round((float)(this.vx - lensx) * this.coef);
        this.pc[i].lcy = lensHeight / 2 - Math.round((float)(this.vy - lensy) * this.coef);
        this.pc[i].lcw = Math.round((float)this.vw * this.coef);
        this.pc[i].lch = Math.round((float)this.vh * this.coef);
        if (this.orient != 0.0f) {
            float x1 = -this.pc[i].lcw;
            float y1 = -this.pc[i].lch;
            float x2 = this.pc[i].lcw;
            float y2 = this.pc[i].lch;
            this.xcoords[0] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[0] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[1] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y1 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[1] = (int)Math.round((double)y1 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[2] = (int)Math.round((double)x1 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[2] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x1 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            this.xcoords[3] = (int)Math.round((double)x2 * Math.cos(this.orient) + (double)y2 * Math.sin(this.orient) + (double)this.pc[i].lcx);
            this.ycoords[3] = (int)Math.round((double)y2 * Math.cos(this.orient) - (double)x2 * Math.sin(this.orient) + (double)this.pc[i].lcy);
            if (this.pc[i].lp == null) {
                this.pc[i].lp = new Polygon(this.xcoords, this.ycoords, 4);
            } else {
                for (int j = 0; j < this.xcoords.length; ++j) {
                    this.pc[i].lp.xpoints[j] = this.xcoords[j];
                    this.pc[i].lp.ypoints[j] = this.ycoords[j];
                }
                this.pc[i].lp.invalidate();
            }
        }
    }

    public void draw(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].cw > 1 && this.pc[i].ch > 1) {
            if (this.orient == 0.0f) {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw, 2 * this.pc[i].ch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].cx - this.pc[i].cw > 0 || dy + this.pc[i].cy - this.pc[i].ch > 0 || dx + this.pc[i].cx - this.pc[i].cw + 2 * this.pc[i].cw - 1 < vW || dy + this.pc[i].cy - this.pc[i].ch + 2 * this.pc[i].ch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].cx - this.pc[i].cw, dy + this.pc[i].cy - this.pc[i].ch, 2 * this.pc[i].cw - 1, 2 * this.pc[i].ch - 1);
                    }
                }
            } else {
                g.translate(dx, dy);
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillPolygon(this.pc[i].p);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].p);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].p);
                    }
                }
                g.translate(-dx, -dy);
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].cx, dy + this.pc[i].cy, 1, 1);
        }
    }

    public void drawForLens(Graphics2D g, int vW, int vH, int i, Stroke stdS, AffineTransform stdT, int dx, int dy) {
        if (this.pc[i].lcw > 1 && this.pc[i].lch > 1) {
            if (this.orient == 0.0f) {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw, 2 * this.pc[i].lch);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        if (dx + this.pc[i].lcx - this.pc[i].lcw > 0 || dy + this.pc[i].lcy - this.pc[i].lch > 0 || dx + this.pc[i].lcx - this.pc[i].lcw + 2 * this.pc[i].lcw - 1 < vW || dy + this.pc[i].lcy - this.pc[i].lch + 2 * this.pc[i].lch - 1 < vH) {
                            g.setStroke(this.stroke);
                            g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                            g.setStroke(stdS);
                        }
                    } else {
                        g.drawRect(dx + this.pc[i].lcx - this.pc[i].lcw, dy + this.pc[i].lcy - this.pc[i].lch, 2 * this.pc[i].lcw - 1, 2 * this.pc[i].lch - 1);
                    }
                }
            } else {
                if (this.filled) {
                    g.setColor(this.color);
                    g.fillPolygon(this.pc[i].lp);
                }
                if (this.paintBorder) {
                    g.setColor(this.borderColor);
                    if (this.stroke != null) {
                        g.setStroke(this.stroke);
                        g.drawPolygon(this.pc[i].lp);
                        g.setStroke(stdS);
                    } else {
                        g.drawPolygon(this.pc[i].lp);
                    }
                }
            }
        } else {
            g.setColor(this.color);
            g.fillRect(dx + this.pc[i].lcx, dy + this.pc[i].lcy, 1, 1);
        }
    }

    public Object clone() {
        VRectangleOr res = new VRectangleOr(this.vx, this.vy, 0, this.vw, this.vh, this.color, this.borderColor, this.orient);
        res.mouseInsideColor = this.mouseInsideColor;
        return res;
    }
}

