
package org.llvm.adt.aliases;

import org.clank.java.*;
import org.clank.support.*;
import org.clank.support.aliases.*;
import static org.clank.support.Casts.*;
import static org.clank.java.io.*;
import static org.clank.java.std.*;
import static org.llvm.adt.ADTAliases.*;
import static org.llvm.support.llvm.*;
import static org.clank.support.NativePointer.*;
import static org.clank.support.NativeType.*;
import static org.clank.support.Native.*;
import org.llvm.support.*;
import org.llvm.adt.*;
import org.llvm.adt.aliases.*;
import org.clank.support.JavaDifferentiators.*;

/*template <typename ValueTy> TEMPLATE*/
//<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}">
@Converted(kind = Converted.Kind.MANUAL, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 413,
 cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}")
//</editor-fold>
public abstract class ${FILE_NAME}${CLASS_SUFFIX} implements type$iterator<${DUAL_CLASS}, ${ENTRY}>, Native.NativeComparable, Native.assignable<${DUAL_CLASS}> {
/*protected:*/
  protected StringMapEntryBase[] /*P*/ /*P*/ Ptr;
  protected int /*P*/ /*P*/ PtrIdx;
/*public:*/
  /*typedef ${ENTRY} value_type*/
//  public final class value_type extends ${ENTRY}{ };
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<ValueT>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 420,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<ValueT>")
  //</editor-fold>
  protected ${FILE_NAME}() {
    /* : Ptr(0)*/ 
    //START JInit
    this.Ptr = null;
    //END JInit
  }
  protected ${FILE_NAME}(JD$Move _dparam, ${FILE_NAME}${CLASS_SUFFIX} other) {
    /* : Ptr(0)*/ 
    //START JInit
    this.Ptr = other.Ptr;
    this.PtrIdx = other.PtrIdx;
    //END JInit
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::${FILE_NAME}<ValueT>">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 422,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::${FILE_NAME}<ValueT>")
  //</editor-fold>
  protected /*explicit*/ ${FILE_NAME}(StringMapEntryBase[] /*P*/ /*P*/ Bucket, int BucketIdx, boolean NoAdvance/*= false*/) {
    /* : Ptr(Bucket)*/ 
    //START JInit
    this.Ptr = Bucket;
    this.PtrIdx = BucketIdx;
    //END JInit
    if (!NoAdvance) {
      AdvancePastEmptyBuckets();
    }
  }

  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator*">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 428,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator*")
  //</editor-fold>
  public /*const*/${ENTRY} /*&*/ $star() /*const*/ {
    return /*Deref*/(/*static_cast*/${ENTRY} /*P*/ )(/*Deref*/Ptr[PtrIdx]);
  }

  @Override
  public type$ref<${ENTRY}> star$ref() {
    return new type$ref<${ENTRY}>() {
      
      private int localPtrIdx = PtrIdx;
      
      @Override
      public ${ENTRY} $deref() {
        return (/*static_cast*/${ENTRY} /*P*/ )(/*Deref*/Ptr[localPtrIdx]);
      }

      @Override
      public ${ENTRY} $set(${ENTRY} value) {
        return (${ENTRY})(Ptr[localPtrIdx]=value);
      }      

    };
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator->">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 431,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator->")
  //</editor-fold>
  public /*const*/${ENTRY} /*P*/ $arrow() /*const*/ {
    return (/*static_cast*/${ENTRY} /*P*/ )(/*Deref*/Ptr[PtrIdx]);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator==">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 435,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator==")
  //</editor-fold>
  public boolean $eq(/*const*/${FILE_NAME} /*&*/ RHS) /*const*/ {
    return (PtrIdx == RHS.PtrIdx) && (Ptr == RHS.Ptr);
  }

  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator!=">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 438,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator!=")
  //</editor-fold>
  public boolean $noteq(/*const*/${FILE_NAME} /*&*/ RHS) /*const*/ {
    return (PtrIdx != RHS.PtrIdx) || (Ptr != RHS.Ptr);
  }

  @Override
  public boolean $eq(Object other) {
    if (other instanceof ${FILE_NAME}) {
      return $eq((${FILE_NAME}) other);
    }
    return false;
  }

  @Override
  public boolean $noteq(Object other) {
    if (other instanceof ${FILE_NAME}) {
      return $noteq((${FILE_NAME}) other);
    }
    return true;
  }

  // Preincrement
  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator++">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 442,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator++")
  //</editor-fold>
  public /*inline*/ ${DUAL_CLASS} /*&*/ $preInc() {
    ++PtrIdx;
    AdvancePastEmptyBuckets();
    return /*Deref*/(${DUAL_CLASS}) this;
  }

  // Postincrement
  @Override
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::operator++">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 447,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::operator++")
  //</editor-fold>
  public ${DUAL_CLASS} $postInc() {
    ${DUAL_CLASS} tmp = /*Deref*/(${DUAL_CLASS}) this.clone();
    ++PtrIdx;
    return tmp;
  }

  public ${DUAL_CLASS} $assign(${DUAL_CLASS} other) {
    this.Ptr = other.Ptr;
    this.PtrIdx = other.PtrIdx;
    return (${DUAL_CLASS}) this;    
  }

/*private:*/
  //<editor-fold defaultstate="collapsed" desc="llvm::${FILE_NAME}::AdvancePastEmptyBuckets">
  @Converted(kind = Converted.Kind.AUTO, source = "${LLVM_SRC}/llvm/include/llvm/ADT/StringMap.h", line = 452,
   cmd = "jclank.sh -java-options=${SPUTNIK}/modules/org.llvm.adtsupport/llvmToClangType ${LLVM_SRC}/llvm/lib/Support/StringMap.cpp -filter=llvm::${FILE_NAME}::AdvancePastEmptyBuckets")
  //</editor-fold>
  private void AdvancePastEmptyBuckets() {
    while (/*Deref*/Ptr[PtrIdx] == null || /*Deref*/Ptr[PtrIdx] == StringMapImpl.getTombstoneVal()) {
      ++PtrIdx;
    }
  }

  @Override
  public ${DUAL_CLASS} clone() {
    return new ${DUAL_CLASS}(Ptr, PtrIdx, true);
  }

  @Override
  public ${DUAL_CLASS} const_clone() {
    return new ${DUAL_CLASS}(Ptr, PtrIdx, true);
  }

}
