/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.support;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.structure.APT;
import org.netbeans.modules.cnd.apt.structure.APTInclude;
import org.netbeans.modules.cnd.apt.support.PostIncludeData;

public final class APTFileCacheEntry {
    private final Map<Integer, PostIncludeData> cache;
    private final Map<Integer, Boolean> evalData;
    private final CharSequence filePath;
    private final boolean serial;
    private final boolean readOnly;
    private static volatile int includeHits = 0;
    private static volatile int evalHits = 0;

    private APTFileCacheEntry(CharSequence filePath, boolean concurrent, boolean readOnly, Map<Integer, PostIncludeData> storage, Map<Integer, Boolean> eval) {
        assert (filePath != null);
        this.filePath = filePath;
        this.serial = concurrent;
        this.readOnly = readOnly;
        this.cache = storage;
        this.evalData = eval;
    }

    static APTFileCacheEntry toCachable(APTFileCacheEntry entry) {
        if (entry.serial && entry.readOnly) {
            return entry;
        }
        assert (!entry.readOnly || entry.serial);
        return new APTFileCacheEntry(entry.filePath, true, true, new HashMap<Integer, PostIncludeData>(entry.cache), new HashMap<Integer, Boolean>(entry.evalData));
    }

    static APTFileCacheEntry toReadOnly(APTFileCacheEntry entry) {
        if (entry.readOnly) {
            return entry;
        }
        assert (!entry.isSerial()) : "only concurrent is exected here (or readonly above)";
        return new APTFileCacheEntry(entry.filePath, !entry.isSerial(), true, entry.cache, entry.evalData);
    }

    static APTFileCacheEntry createConcurrentEntry(CharSequence filePath) {
        return APTFileCacheEntry.create(filePath, false);
    }

    static APTFileCacheEntry createSerialEntry(CharSequence filePath) {
        return APTFileCacheEntry.create(filePath, true);
    }

    private static APTFileCacheEntry create(CharSequence filePath, boolean serial) {
        return new APTFileCacheEntry(filePath, serial, false, serial ? new HashMap() : new ConcurrentHashMap(), serial ? new HashMap() : new ConcurrentHashMap());
    }

    public boolean isSerial() {
        return this.serial;
    }

    PostIncludeData getPostIncludeState(APTInclude node) {
        PostIncludeData data = this.getIncludeData(node);
        assert (data != null);
        if (data.getPostIncludeMacroState() != null && APTTraceFlags.TRACE_APT_CACHE && this.needTraceValue(++includeHits)) {
            System.err.println("INCLUDE HIT " + includeHits + " cache for line:" + node.getToken().getLine() + " in " + this.filePath);
        }
        return data;
    }

    Object getIncludeLock(APTInclude node) {
        if (this.readOnly) {
            return new Object();
        }
        return this.getIncludeData(node);
    }

    Boolean getEvalResult(APT node) {
        Boolean out = this.evalData.get(node.getOffset());
        if (APTTraceFlags.TRACE_APT_CACHE && out != null && this.needTraceValue(evalHits++)) {
            System.err.println("EVAL HIT " + evalHits + " cache for line:" + node.getToken().getLine() + " as " + out + " in " + this.filePath);
        }
        return out;
    }

    void setEvalResult(APT node, boolean result) {
        if (this.readOnly) {
            return;
        }
        this.evalData.put(node.getOffset(), result);
    }

    private PostIncludeData getIncludeData(APTInclude node) {
        Integer key = node.getOffset();
        PostIncludeData data = this.cache.get(key);
        if (data == null) {
            data = new PostIncludeData();
            if (!this.readOnly) {
                PostIncludeData prev;
                PostIncludeData postIncludeData = prev = this.serial ? this.cache.put(key, data) : ((ConcurrentMap)this.cache).putIfAbsent(key, data);
                if (prev != null) {
                    data = prev;
                }
            }
        }
        return data;
    }

    void setIncludeData(APTInclude node, PostIncludeData newData) {
        if (this.readOnly) {
            return;
        }
        Integer key = node.getOffset();
        PostIncludeData old = this.cache.get(key);
        assert (old != null);
        assert (!old.hasPostIncludeMacroState()) : this.filePath + " serial=" + this.serial + " for node " + node + " already has post macro state";
        if (this.serial) {
            this.cache.put(key, newData);
        } else {
            boolean replaced = ((ConcurrentMap)this.cache).replace(key, old, newData);
            assert (replaced) : "old empty entry must be replaced by new one";
        }
    }

    public CharSequence getFilePath() {
        return this.filePath;
    }

    public String toString() {
        return "APT cache " + (this.isSerial() ? "Serial" : "Shared") + (this.readOnly ? " ReadOnly" : "") + " with " + this.cache.size() + " entries for " + this.filePath;
    }

    private boolean needTraceValue(int val) {
        return val % 10 == 0;
    }
}

