/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.apt.impl.support;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.zip.Adler32;
import java.util.zip.Checksum;
import org.netbeans.modules.cnd.apt.debug.APTTraceFlags;
import org.netbeans.modules.cnd.apt.impl.support.APTHandlersSupportImpl;
import org.netbeans.modules.cnd.apt.impl.support.APTIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.impl.support.SupportAPIAccessor;
import org.netbeans.modules.cnd.apt.impl.support.clank.ClankIncludeHandlerImpl;
import org.netbeans.modules.cnd.apt.support.APTPreprocHandler;
import org.netbeans.modules.cnd.apt.support.IncludeDirEntry;
import org.netbeans.modules.cnd.apt.support.api.PPIncludeHandler;
import org.netbeans.modules.cnd.apt.support.api.PPMacroMap;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.utils.APTSerializeUtils;
import org.netbeans.modules.cnd.apt.utils.APTUtils;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataOutput;

public class APTPreprocHandlerImpl
implements APTPreprocHandler {
    private boolean compileContext;
    private boolean isValid = true;
    private CharSequence lang;
    private CharSequence flavor;
    private long cuCRC;
    private PPMacroMap macroMap;
    private PPIncludeHandler inclHandler;

    public APTPreprocHandlerImpl(PPMacroMap macroMap, PPIncludeHandler inclHandler, boolean compileContext, CharSequence lang, CharSequence flavor) {
        this.macroMap = macroMap;
        this.inclHandler = inclHandler;
        this.compileContext = compileContext;
        assert (lang != null);
        this.lang = lang;
        assert (flavor != null);
        this.flavor = flavor;
        this.cuCRC = this.countCompilationUnitCRC(inclHandler.getStartEntry().getStartFileProject().getUnitId());
    }

    @Override
    public PPMacroMap getMacroMap() {
        return this.macroMap;
    }

    @Override
    public PPIncludeHandler getIncludeHandler() {
        return this.inclHandler;
    }

    @Override
    public PreprocHandler.State getState() {
        return this.createStateImpl();
    }

    @Override
    public void setState(PreprocHandler.State state) {
        if (state instanceof StateImpl) {
            ((StateImpl)state).restoreTo(this);
        }
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    @Override
    public boolean isValid() {
        return this.isValid;
    }

    @Override
    public boolean isCompileContext() {
        return this.compileContext;
    }

    protected StateImpl createStateImpl() {
        return new StateImpl(this);
    }

    private void setCompileContext(boolean state) {
        this.compileContext = state;
    }

    @Override
    public CharSequence getLanguage() {
        return this.lang;
    }

    @Override
    public CharSequence getLanguageFlavor() {
        return this.flavor;
    }

    long getCompilationUnitCRC() {
        return this.cuCRC;
    }

    private long countCompilationUnitCRC(int unitId) {
        Adler32 checksum = new Adler32();
        this.updateCrc(checksum, this.lang.toString());
        this.updateCrc(checksum, this.flavor.toString());
        if (this.inclHandler instanceof ClankIncludeHandlerImpl) {
            assert (APTTraceFlags.USE_CLANK);
            this.updateCrcByFSPaths(checksum, ((ClankIncludeHandlerImpl)this.inclHandler).getSystemIncludePaths(), unitId);
            this.updateCrcByFSPaths(checksum, ((ClankIncludeHandlerImpl)this.inclHandler).getUserIncludePaths(), unitId);
            this.updateCrcByFSPaths(checksum, ((ClankIncludeHandlerImpl)this.inclHandler).getUserIncludeFilePaths(), unitId);
        } else {
            assert (this.inclHandler instanceof APTIncludeHandlerImpl) : "unexpected class " + this.inclHandler.getClass();
            this.updateCrcByFSPaths(checksum, ((APTIncludeHandlerImpl)this.inclHandler).getSystemIncludePaths(), unitId);
            this.updateCrcByFSPaths(checksum, ((APTIncludeHandlerImpl)this.inclHandler).getUserIncludePaths(), unitId);
            this.updateCrcByFSPaths(checksum, ((APTIncludeHandlerImpl)this.inclHandler).getUserIncludeFilePaths(), unitId);
        }
        long value = checksum.getValue();
        return value += APTHandlersSupportImpl.getCompilationUnitCRC(this.macroMap);
    }

    private void updateCrc(Checksum checksum, String s) {
        checksum.update(s.getBytes(SupportAPIAccessor.INTERNAL_CHARSET), 0, s.length());
    }

    private void updateCrcByFSPaths(Checksum checksum, List<IncludeDirEntry> paths, int unitId) {
        for (IncludeDirEntry path : paths) {
            int id = Repository.getFileIdByName((int)unitId, (CharSequence)path.getAsSharedCharSequence());
            checksum.update(id);
        }
    }

    public String toString() {
        StringBuilder retValue = new StringBuilder();
        retValue.append(this.isCompileContext() ? "\nCompile Context" : "\nDefault/Null State");
        retValue.append("\nInclude Info:\n");
        retValue.append(this.inclHandler);
        retValue.append("\nMACROS info:\n");
        retValue.append(this.macroMap);
        return retValue.toString();
    }

    public static final class StateImpl
    implements PreprocHandler.State {
        final CharSequence lang;
        final CharSequence flavor;
        final PPMacroMap.State macroState;
        final PPIncludeHandler.State inclState;
        private final byte attributes;
        private final long cuCRC;
        private static final byte COMPILE_CONTEXT_FLAG = 1;
        private static final byte CLEANED_FLAG = 2;
        private static final byte VALID_FLAG = 4;
        private static final byte ALREADY_TRIED_CACHE_PREPARATION_FLAG = 8;

        private static byte createAttributes(boolean compileContext, boolean cleaned, boolean valid, boolean alreadyTriedCachePreparation) {
            byte out = 0;
            out = compileContext ? (byte)((byte)(out | 1)) : (byte)((byte)(out & 0xFFFFFFFE));
            out = cleaned ? (byte)((byte)(out | 2)) : (byte)((byte)(out & 0xFFFFFFFD));
            out = valid ? (byte)((byte)(out | 4)) : (byte)((byte)(out & 0xFFFFFFFB));
            out = alreadyTriedCachePreparation ? (byte)((byte)(out | 8)) : (byte)((byte)(out & 0xFFFFFFF7));
            return out;
        }

        protected StateImpl(APTPreprocHandlerImpl handler) {
            this.macroState = handler.getMacroMap() != null ? handler.getMacroMap().getState() : null;
            this.inclState = handler.getIncludeHandler() != null ? handler.getIncludeHandler().getState() : null;
            this.attributes = StateImpl.createAttributes(handler.isCompileContext(), false, handler.isValid(), false);
            this.lang = handler.lang;
            this.flavor = handler.flavor;
            this.cuCRC = handler.cuCRC;
        }

        private StateImpl(StateImpl other, boolean cleanState, boolean compileContext, boolean valid, boolean prepareCacheIfPossible) {
            boolean cleaned;
            PPMacroMap.State newMacroState;
            PPIncludeHandler.State newIncludeState;
            boolean alreadyTriedCachePreparation = false;
            if (cleanState && !other.isCleaned()) {
                newIncludeState = APTHandlersSupportImpl.copyCleanIncludeState(other.inclState);
                newMacroState = APTHandlersSupportImpl.createCleanMacroState(other.macroState);
                cleaned = true;
            } else {
                newMacroState = other.macroState;
                cleaned = other.isCleaned();
                newIncludeState = other.inclState;
            }
            if (cleaned) {
                alreadyTriedCachePreparation = true;
            } else if (prepareCacheIfPossible) {
                alreadyTriedCachePreparation = true;
                newIncludeState = APTHandlersSupportImpl.prepareIncludeStateCachesIfPossible(newIncludeState);
            }
            this.inclState = newIncludeState;
            this.macroState = newMacroState;
            this.attributes = StateImpl.createAttributes(compileContext, cleaned, valid, alreadyTriedCachePreparation);
            this.lang = other.lang;
            this.flavor = other.flavor;
            this.cuCRC = other.cuCRC;
        }

        private void restoreTo(APTPreprocHandlerImpl handler) {
            if (handler.getMacroMap() != null) {
                handler.getMacroMap().setState(this.macroState);
            }
            if (handler.getIncludeHandler() != null) {
                handler.getIncludeHandler().setState(this.inclState);
            }
            handler.setCompileContext(this.isCompileContext());
            handler.lang = this.lang;
            handler.flavor = this.flavor;
            handler.cuCRC = this.cuCRC;
            handler.setValid(this.isValid());
            if (!this.isValid()) {
                APTUtils.LOG.log(Level.SEVERE, "setting invalid state {0}", new Object[]{this});
            }
        }

        public String toString() {
            StringBuilder retValue = new StringBuilder();
            retValue.append(this.isCleaned() ? "\nCleaned State;" : "\nNot Cleaned State;");
            retValue.append(this.isCompileContext() ? "Compile Context;" : "Default/Null State;");
            retValue.append(this.isValid() ? "Valid State;" : "Invalid State;");
            retValue.append("\nInclude state Info:\n");
            retValue.append(this.inclState);
            retValue.append("\nMACROS state info:\n");
            retValue.append(this.macroState);
            return retValue.toString();
        }

        boolean equalsIgnoreInvalidFlag(PreprocHandler.State obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            if (this.isCompileContext() != other.isCompileContext()) {
                return false;
            }
            return this.inclState == other.inclState || this.inclState != null && this.inclState.equals(other.inclState);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            StateImpl other = (StateImpl)obj;
            if (this.isCompileContext() != other.isCompileContext()) {
                return false;
            }
            if (this.isValid() != other.isValid()) {
                return false;
            }
            return this.inclState == other.inclState || this.inclState != null && this.inclState.equals(other.inclState);
        }

        public int hashCode() {
            int hash = 5;
            hash = 83 * hash + (this.isCompileContext() ? 1 : 0);
            hash = 83 * hash + (this.isValid() ? 1 : 0);
            hash = 83 * hash + (this.inclState != null ? this.inclState.hashCode() : 0);
            return hash;
        }

        @Override
        public boolean isCompileContext() {
            return (this.attributes & 1) == 1;
        }

        private boolean isAlreadyTriedCachePreparation() {
            return (this.attributes & 8) == 8;
        }

        @Override
        public boolean isCleaned() {
            return (this.attributes & 2) == 2;
        }

        @Override
        public boolean isValid() {
            return (this.attributes & 4) == 4;
        }

        PreprocHandler.State copy() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), this.isValid(), false);
        }

        PreprocHandler.State prepareCachesIfPossible() {
            if (this.isCleaned()) {
                return this;
            }
            if (this.isAlreadyTriedCachePreparation()) {
                return this;
            }
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), this.isValid(), true);
        }

        PreprocHandler.State copyCleaned() {
            return new StateImpl(this, true, this.isCompileContext(), this.isValid(), false);
        }

        PreprocHandler.State copyInvalid() {
            return new StateImpl(this, this.isCleaned(), this.isCompileContext(), false, false);
        }

        public void write(RepositoryDataOutput output) throws IOException {
            output.writeByte((int)this.attributes);
            APTSerializeUtils.writeIncludeState(this.inclState, output);
            APTSerializeUtils.writeMacroMapState(this.macroState, output);
            output.writeCharSequenceUTF(this.lang);
            output.writeCharSequenceUTF(this.flavor);
            output.writeLong(this.cuCRC);
        }

        public StateImpl(RepositoryDataInput input) throws IOException {
            this.attributes = input.readByte();
            this.inclState = APTSerializeUtils.readIncludeState(input);
            this.macroState = APTSerializeUtils.readMacroMapState(input);
            this.lang = input.readCharSequenceUTF();
            this.flavor = input.readCharSequenceUTF();
            this.cuCRC = input.readLong();
        }

        @Override
        public CharSequence getLanguage() {
            return this.lang;
        }

        @Override
        public CharSequence getLanguageFlavor() {
            return this.flavor;
        }

        public long getCRC() {
            return this.cuCRC;
        }
    }
}

