/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.service.profiles;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LayoutStyle;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityProfile;
import org.netbeans.modules.websvc.wsitconf.spi.features.SecureConversationFeature;
import org.netbeans.modules.websvc.wsitconf.ui.service.profiles.ProfileBaseForm;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.AlgoSuiteModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.PolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityPolicyModelHelper;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.SecurityTokensModelHelper;
import org.netbeans.modules.websvc.wsitmodelext.policy.Policy;
import org.netbeans.modules.websvc.wsitmodelext.security.BootstrapPolicy;
import org.netbeans.modules.websvc.wsitmodelext.security.WssElement;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.ProtectionToken;
import org.netbeans.modules.websvc.wsitmodelext.security.tokens.SecureConversationToken;
import org.netbeans.modules.websvc.wsitmodelext.versioning.ConfigVersion;
import org.netbeans.modules.xml.wsdl.model.ExtensibilityElement;
import org.netbeans.modules.xml.wsdl.model.WSDLComponent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class EndorsingCertificate
extends ProfileBaseForm {
    private JComboBox algoSuiteCombo;
    private JLabel algoSuiteLabel;
    private JCheckBox derivedKeysChBox;
    private JCheckBox encryptOrderChBox;
    private JCheckBox encryptSignatureChBox;
    private JComboBox layoutCombo;
    private JLabel layoutLabel;
    private JCheckBox reqDerivedKeys;
    private JCheckBox reqSigConfChBox;
    private JCheckBox secConvChBox;

    public EndorsingCertificate(WSDLComponent comp, SecurityProfile secProfile) {
        super(comp, secProfile);
        this.initComponents();
        this.inSync = true;
        this.fillLayoutCombo(this.layoutCombo);
        this.fillAlgoSuiteCombo(this.algoSuiteCombo);
        this.inSync = false;
        this.sync();
    }

    @Override
    protected void sync() {
        this.inSync = true;
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        this.setChBox(this.secConvChBox, secConv);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            this.setChBox(this.derivedKeysChBox, SecurityPolicyModelHelper.isRequireDerivedKeys(protToken));
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation((WSDLComponent)p));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(bootPolicy));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(bootPolicy));
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            this.setChBox(this.derivedKeysChBox, false);
            this.setChBox(this.reqSigConfChBox, SecurityPolicyModelHelper.isRequireSignatureConfirmation(this.comp));
            this.setChBox(this.encryptSignatureChBox, SecurityPolicyModelHelper.isEncryptSignature(this.comp));
            this.setChBox(this.encryptOrderChBox, SecurityPolicyModelHelper.isEncryptBeforeSigning(this.comp));
        }
        WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
        WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
        this.setChBox(this.reqDerivedKeys, SecurityPolicyModelHelper.isRequireDerivedKeys(token));
        this.setCombo(this.algoSuiteCombo, AlgoSuiteModelHelper.getAlgorithmSuite((WSDLComponent)secBinding));
        this.setCombo(this.layoutCombo, SecurityPolicyModelHelper.getMessageLayout((WSDLComponent)secBinding));
        this.enableDisable();
        this.inSync = false;
    }

    @Override
    protected void setValue(JComponent source) {
        if (this.inSync) {
            return;
        }
        ExtensibilityElement secBinding = null;
        ExtensibilityElement topSecBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
        WSDLComponent protTokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)topSecBinding, ProtectionToken.class);
        WSDLComponent protToken = SecurityTokensModelHelper.getTokenTypeElement(protTokenKind);
        boolean secConv = protToken instanceof SecureConversationToken;
        if (source.equals(this.secConvChBox)) {
            ((SecureConversationFeature)((Object)this.secProfile)).enableSecureConversation(this.comp, this.secConvChBox.isSelected());
            this.sync();
        }
        ConfigVersion configVersion = PolicyModelHelper.getConfigVersion(this.comp);
        SecurityPolicyModelHelper spmh = SecurityPolicyModelHelper.getInstance(configVersion);
        AlgoSuiteModelHelper asmh = AlgoSuiteModelHelper.getInstance(configVersion);
        if (secConv) {
            WSDLComponent bootPolicy = SecurityTokensModelHelper.getTokenElement(protToken, BootstrapPolicy.class);
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(bootPolicy);
            Policy p = (Policy)secBinding.getParent();
            if (source.equals(this.reqSigConfChBox)) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11((WSDLComponent)p), this.reqSigConfChBox.isSelected());
            }
            if (source.equals(this.derivedKeysChBox)) {
                spmh.enableRequireDerivedKeys(protToken, this.derivedKeysChBox.isSelected());
            }
        } else {
            secBinding = SecurityPolicyModelHelper.getSecurityBindingTypeElement(this.comp);
            if (source.equals(this.reqSigConfChBox)) {
                spmh.enableRequireSignatureConfirmation((WssElement)SecurityPolicyModelHelper.getWss11(this.comp), this.reqSigConfChBox.isSelected());
            }
        }
        if (source.equals(this.encryptSignatureChBox)) {
            spmh.enableEncryptSignature((WSDLComponent)secBinding, this.encryptSignatureChBox.isSelected());
            if (secConv) {
                spmh.enableEncryptSignature((WSDLComponent)topSecBinding, this.encryptSignatureChBox.isSelected());
            }
        }
        if (source.equals(this.encryptOrderChBox)) {
            spmh.enableEncryptBeforeSigning((WSDLComponent)secBinding, this.encryptOrderChBox.isSelected());
            if (secConv) {
                spmh.enableEncryptBeforeSigning((WSDLComponent)topSecBinding, this.encryptOrderChBox.isSelected());
            }
        }
        if (source.equals(this.layoutCombo)) {
            spmh.setLayout((WSDLComponent)secBinding, (String)this.layoutCombo.getSelectedItem());
            if (secConv) {
                spmh.setLayout((WSDLComponent)topSecBinding, (String)this.layoutCombo.getSelectedItem());
            }
        }
        if (source.equals(this.algoSuiteCombo)) {
            asmh.setAlgorithmSuite((WSDLComponent)secBinding, (String)this.algoSuiteCombo.getSelectedItem());
            if (secConv) {
                asmh.setAlgorithmSuite((WSDLComponent)topSecBinding, (String)this.algoSuiteCombo.getSelectedItem());
            }
        }
        if (source.equals(this.reqDerivedKeys)) {
            WSDLComponent tokenKind = SecurityTokensModelHelper.getTokenElement((WSDLComponent)secBinding, ProtectionToken.class);
            WSDLComponent token = SecurityTokensModelHelper.getTokenTypeElement(tokenKind);
            spmh.enableRequireDerivedKeys(token, this.reqDerivedKeys.isSelected());
            return;
        }
        this.enableDisable();
    }

    @Override
    protected void enableDisable() {
        boolean secConvEnabled = this.secConvChBox.isSelected();
        this.derivedKeysChBox.setEnabled(secConvEnabled);
    }

    private void initComponents() {
        this.secConvChBox = new JCheckBox();
        this.reqSigConfChBox = new JCheckBox();
        this.derivedKeysChBox = new JCheckBox();
        this.algoSuiteLabel = new JLabel();
        this.algoSuiteCombo = new JComboBox();
        this.layoutLabel = new JLabel();
        this.layoutCombo = new JComboBox();
        this.encryptSignatureChBox = new JCheckBox();
        this.encryptOrderChBox = new JCheckBox();
        this.reqDerivedKeys = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)this.secConvChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_SecConvLabel"));
        this.secConvChBox.setMargin(new Insets(0, 0, 0, 0));
        this.secConvChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.secConvChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqSigConfChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_RequireSigConfirmation"));
        this.reqSigConfChBox.setMargin(new Insets(0, 0, 0, 0));
        this.reqSigConfChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.reqSigConfChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.derivedKeysChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_RequireDerivedKeysForSecConv"));
        this.derivedKeysChBox.setMargin(new Insets(0, 0, 0, 0));
        this.derivedKeysChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.derivedKeysChBoxActionPerformed(evt);
            }
        });
        this.algoSuiteLabel.setLabelFor(this.algoSuiteCombo);
        Mnemonics.setLocalizedText((JLabel)this.algoSuiteLabel, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_AlgoSuiteLabel"));
        this.algoSuiteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.algoSuiteComboActionPerformed(evt);
            }
        });
        this.layoutLabel.setLabelFor(this.layoutCombo);
        Mnemonics.setLocalizedText((JLabel)this.layoutLabel, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_LayoutLabel"));
        this.layoutCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.layoutComboActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptSignatureChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_EncryptSignatureLabel"));
        this.encryptSignatureChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptSignatureChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.encryptSignatureChBox(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.encryptOrderChBox, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_EncryptOrderLabel"));
        this.encryptOrderChBox.setMargin(new Insets(0, 0, 0, 0));
        this.encryptOrderChBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.encryptOrderChBoxActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.reqDerivedKeys, (String)NbBundle.getMessage(EndorsingCertificate.class, (String)"LBL_RequireDerivedKeys"));
        this.reqDerivedKeys.setMargin(new Insets(0, 0, 0, 0));
        this.reqDerivedKeys.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                EndorsingCertificate.this.reqDerivedKeysActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.layoutLabel).addComponent(this.algoSuiteLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.layoutCombo, -2, -1, -2).addComponent(this.algoSuiteCombo, -2, -1, -2)).addContainerGap(166, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(45, Short.MAX_VALUE).addComponent(this.reqDerivedKeys).addGap(178, 178, 178)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.reqSigConfChBox).addComponent(this.secConvChBox).addComponent(this.derivedKeysChBox).addComponent(this.encryptSignatureChBox).addComponent(this.encryptOrderChBox)).addContainerGap()));
        layout.linkSize(0, this.algoSuiteCombo, this.layoutCombo);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.algoSuiteLabel).addComponent(this.algoSuiteCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.layoutLabel).addComponent(this.layoutCombo, -2, -1, -2)).addGap(6, 6, 6).addComponent(this.reqDerivedKeys).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.secConvChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.derivedKeysChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.reqSigConfChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptSignatureChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.encryptOrderChBox).addContainerGap(-1, Short.MAX_VALUE)));
        layout.linkSize(1, this.algoSuiteCombo, this.layoutCombo);
    }

    private void encryptOrderChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.encryptOrderChBox);
    }

    private void reqSigConfChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.reqSigConfChBox);
    }

    private void derivedKeysChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.derivedKeysChBox);
    }

    private void secConvChBoxActionPerformed(ActionEvent evt) {
        this.setValue(this.secConvChBox);
    }

    private void encryptSignatureChBox(ActionEvent evt) {
        this.setValue(this.encryptSignatureChBox);
    }

    private void layoutComboActionPerformed(ActionEvent evt) {
        this.setValue(this.layoutCombo);
    }

    private void algoSuiteComboActionPerformed(ActionEvent evt) {
        this.setValue(this.algoSuiteCombo);
    }

    private void reqDerivedKeysActionPerformed(ActionEvent evt) {
        this.setValue(this.reqDerivedKeys);
    }
}

