/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.Container;
import java.awt.Insets;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.LayoutStyle;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.wsitconf.spi.SecurityCheckerRegistry;
import org.netbeans.modules.websvc.wsitconf.util.Util;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.TransportModelHelper;
import org.netbeans.modules.xml.multiview.ui.SectionInnerPanel;
import org.netbeans.modules.xml.multiview.ui.SectionView;
import org.netbeans.modules.xml.wsdl.model.Binding;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class TransportPanelClient
extends SectionInnerPanel {
    private Node node;
    private Binding binding;
    private boolean inSync = false;
    private JaxWsModel jaxwsmodel;
    private Project project;
    private JCheckBox optimalEncChBox;
    private JCheckBox optimalTransportChBox;

    public TransportPanelClient(SectionView view, Node node, Binding binding, JaxWsModel jaxWsModel) {
        super(view);
        this.node = node;
        this.binding = binding;
        this.jaxwsmodel = jaxWsModel;
        FileObject fo = (FileObject)node.getLookup().lookup(FileObject.class);
        if (fo != null) {
            this.project = FileOwnerQuery.getOwner((FileObject)fo);
        } else {
            JAXWSLightSupport supp = (JAXWSLightSupport)node.getLookup().lookup(JAXWSLightSupport.class);
            this.project = FileOwnerQuery.getOwner((FileObject)supp.getWsdlFolder(true));
        }
        this.initComponents();
        this.addImmediateModifier(this.optimalEncChBox);
        this.addImmediateModifier(this.optimalTransportChBox);
        this.sync();
    }

    public void sync() {
        this.inSync = true;
        this.setChBox(this.optimalEncChBox, TransportModelHelper.isAutoEncodingEnabled(this.binding));
        this.setChBox(this.optimalTransportChBox, TransportModelHelper.isAutoTransportEnabled(this.binding));
        this.enableDisable();
        this.inSync = false;
    }

    public void setValue(JComponent source, Object value) {
        if (!this.inSync) {
            Util.checkMetroLibrary(this.project);
            if (source.equals(this.optimalEncChBox)) {
                TransportModelHelper.setAutoEncoding(this.binding, this.optimalEncChBox.isSelected());
            }
            if (source.equals(this.optimalTransportChBox)) {
                TransportModelHelper.enableAutoTransport(this.binding, this.optimalTransportChBox.isSelected());
            }
            this.enableDisable();
        }
    }

    private void enableDisable() {
        boolean amSec = SecurityCheckerRegistry.getDefault().isNonWsitSecurityEnabled(this.node, this.jaxwsmodel);
        this.optimalEncChBox.setEnabled(!amSec);
        this.optimalTransportChBox.setEnabled(!amSec);
    }

    private void setChBox(JCheckBox chBox, Boolean enable) {
        if (enable == null) {
            chBox.setSelected(false);
        } else {
            chBox.setSelected(enable);
        }
    }

    public void documentChanged(JTextComponent comp, String value) {
    }

    public void rollbackValue(JTextComponent source) {
    }

    protected void endUIChange() {
    }

    public void linkButtonPressed(Object ddBean, String ddProperty) {
    }

    public JComponent getErrorComponent(String errorId) {
        return null;
    }

    private void initComponents() {
        this.optimalEncChBox = new JCheckBox();
        this.optimalTransportChBox = new JCheckBox();
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent evt) {
                TransportPanelClient.this.formFocusGained(evt);
            }
        });
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorMoved(AncestorEvent evt) {
            }

            @Override
            public void ancestorAdded(AncestorEvent evt) {
                TransportPanelClient.this.formAncestorAdded(evt);
            }

            @Override
            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.optimalEncChBox, (String)NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding"));
        this.optimalEncChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optimalEncChBox.setMargin(new Insets(0, 0, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.optimalTransportChBox, (String)NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport"));
        this.optimalTransportChBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.optimalTransportChBox.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.optimalTransportChBox).addComponent(this.optimalEncChBox)).addContainerGap(-1, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.optimalEncChBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.optimalTransportChBox).addContainerGap(-1, Short.MAX_VALUE)));
        this.optimalEncChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding_ACSN"));
        this.optimalEncChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalEncoding_ACSD"));
        this.optimalTransportChBox.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport_ACSN"));
        this.optimalTransportChBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TransportPanelClient.class, (String)"LBL_Transport_OptimalTransport_ACSD"));
    }

    private void formFocusGained(FocusEvent evt) {
        this.enableDisable();
    }

    private void formAncestorAdded(AncestorEvent evt) {
        this.enableDisable();
    }
}

