/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.ui.client;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.Iterator;
import org.netbeans.modules.websvc.api.jaxws.project.config.Client;
import org.netbeans.modules.websvc.api.jaxws.project.config.JaxWsModel;
import org.netbeans.modules.websvc.jaxws.light.api.JAXWSLightSupport;
import org.netbeans.modules.websvc.jaxws.light.api.JaxWsService;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientPanelFactory;
import org.netbeans.modules.websvc.wsitconf.ui.client.ClientView;
import org.netbeans.modules.xml.multiview.ui.InnerPanelFactory;
import org.netbeans.modules.xml.multiview.ui.PanelView;
import org.netbeans.modules.xml.multiview.ui.ToolBarDesignEditor;
import org.netbeans.modules.xml.wsdl.model.Service;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class ClientTopComponent
extends TopComponent {
    static final long serialVersionUID = 6021472310161712674L;
    private boolean initialized = false;
    private InnerPanelFactory panelFactory = null;
    private JaxWsModel jaxWsModel;
    private WSDLModel clientWsdlModel;
    private WSDLModel serviceModel;
    private Client client;
    private Node node;
    private JAXWSLightSupport jaxWsSupport;
    private JaxWsService jaxWsService;
    private Service service;

    public ClientTopComponent(Client client, JaxWsModel jaxWsModel, WSDLModel clientWsdlModel, WSDLModel serviceWsdlModel, Node node) {
        this.setLayout(new BorderLayout());
        this.jaxWsModel = jaxWsModel;
        this.clientWsdlModel = clientWsdlModel;
        this.serviceModel = serviceWsdlModel;
        this.initialized = false;
        this.client = client;
        this.node = node;
    }

    public ClientTopComponent(JAXWSLightSupport jaxWsSupport, JaxWsService jaxService, WSDLModel clientWsdlModel, WSDLModel serviceWsdlModel, Node node) {
        this.setLayout(new BorderLayout());
        this.clientWsdlModel = clientWsdlModel;
        this.serviceModel = serviceWsdlModel;
        this.initialized = false;
        this.jaxWsSupport = jaxWsSupport;
        this.jaxWsService = jaxService;
        this.client = null;
        this.jaxWsModel = null;
        this.node = node;
    }

    protected String preferredID() {
        return "WSITClientTopComponent";
    }

    public ClientTopComponent(Service service, WSDLModel clientWsdlModel, WSDLModel serviceWsdlModel, Node node) {
        this.setLayout(new BorderLayout());
        this.service = service;
        this.clientWsdlModel = clientWsdlModel;
        this.serviceModel = serviceWsdlModel;
        this.initialized = false;
        this.node = node;
    }

    private Service getService(String name, WSDLModel m) {
        Collection services;
        if (name != null && m != null && m.getDefinitions() != null && (services = m.getDefinitions().getServices()) != null) {
            Iterator i = services.iterator();
            Service s = null;
            while (i.hasNext()) {
                s = (Service)i.next();
                if (s == null || !name.equals(s.getName()) && services.size() != 1) continue;
                return s;
            }
        }
        return null;
    }

    private void doInitialize() {
        this.initAccessibility();
        ToolBarDesignEditor tb = new ToolBarDesignEditor();
        this.panelFactory = new ClientPanelFactory(tb, this.clientWsdlModel, this.node, this.serviceModel, this.jaxWsModel);
        ClientView mview = null;
        if (this.jaxWsService == null) {
            Service s = this.service;
            if (this.client != null) {
                s = this.getService(this.client.getName(), this.clientWsdlModel);
            }
            mview = new ClientView(this.panelFactory, this.clientWsdlModel, this.serviceModel, s == null ? null : s.getPorts());
        } else {
            mview = new ClientView(this.panelFactory, this.clientWsdlModel, this.serviceModel, null);
        }
        if (mview != null) {
            tb.setContentView((PanelView)mview);
            this.add((Component)tb);
        }
        this.setFocusable(true);
    }

    public int getPersistenceType() {
        return 0;
    }

    private void initAccessibility() {
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ClientTopComponent.class, (String)"ACS_Tab_DESC"));
    }

    public void addNotify() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.addNotify();
    }

    protected void componentShowing() {
        if (!this.initialized) {
            this.initialized = true;
            this.doInitialize();
        }
        super.componentShowing();
    }
}

