/*
 * Decompiled with CFR 0.152.
 */
package org.clank.support.aliases;

import java.io.PrintWriter;
import org.clank.support.AbstractArrayPointerType;
import org.clank.support.NativeTrace;
import org.clank.support.aliases.uint$ptr;
import org.clank.support.aliases.uint$ref;
import org.clank.support.void$ptr;

public final class uint$ptr$array
extends AbstractArrayPointerType<uint$ptr>
implements uint$ptr {
    protected int[] array;
    private static long nonConstInstances = 0L;
    private static long constPtrInstances = 0L;
    private static long constContentInstances = 0L;
    private static long fullyConstInstances = 0L;

    protected uint$ptr$array(uint$ptr$array other, boolean makeConstPtr, boolean makeConstContent) {
        super(other, makeConstPtr, makeConstContent);
        this.array = other.array;
        uint$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    public uint$ptr$array() {
        this(null, 0, false, false);
    }

    public uint$ptr$array(int[] arr) {
        this(arr, 0, false, false);
    }

    public uint$ptr$array(int[] arr, int idx) {
        this(arr, idx, false, false);
    }

    public uint$ptr$array(int[] arr, boolean makeConstPtr) {
        this(arr, 0, makeConstPtr, false);
    }

    public uint$ptr$array(int[] arr, int idx, boolean makeConstPtr) {
        this(arr, idx, makeConstPtr, false);
    }

    public uint$ptr$array(int[] arr, int idx, boolean makeConstPtr, boolean makeConstContent) {
        super(makeConstPtr, makeConstContent);
        this.array = arr;
        assert (idx >= 0) : "can not be negative " + idx;
        this.index = idx;
        uint$ptr$array.trackInstance(makeConstPtr, makeConstContent);
    }

    @Override
    public boolean $isNull() {
        return this.array == null;
    }

    @Override
    public int $star() {
        return this.array[this.index];
    }

    @Override
    public int $set(int value) {
        return this.$set(0, value);
    }

    @Override
    public int $at(int index) {
        return this.array[this.index + index];
    }

    @Override
    public int $sub(uint$ptr other) {
        assert (other instanceof uint$ptr$array) : "unexpected object " + other;
        return this.index - ((uint$ptr$array)other).index;
    }

    @Override
    public uint$ptr$array $add(int amount) {
        uint$ptr$array cloned = new uint$ptr$array(this, false, this._isConstContent());
        cloned.index += amount;
        return cloned;
    }

    @Override
    public uint$ptr$array $sub(int amount) {
        uint$ptr$array cloned = new uint$ptr$array(this, false, this._isConstContent());
        cloned.index -= amount;
        return cloned;
    }

    @Override
    public int $set(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = value;
        this.array[this.index + index] = n;
        return n;
    }

    @Override
    public int $set$andassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] & value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$xorassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] ^ value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$orassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] | value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$addassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] + value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$minusassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] - value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$starassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] * value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$slashassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] / value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$modassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] % value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$lshiftassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] << value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$rshiftassign(int index, int value) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] >> value;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$postInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n];
        this.array[n] = n2 + 1;
        return n2;
    }

    @Override
    public int $set$postDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n];
        this.array[n] = n2 - 1;
        return n2;
    }

    @Override
    public int $set$preInc(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] + 1;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public int $set$preDec(int index) {
        assert (!this._isConstContent()) : "Cannot modify content because it is constant!";
        int n = this.index + index;
        int n2 = this.array[n] - 1;
        this.array[n] = n2;
        return n2;
    }

    @Override
    public uint$ptr $assign(uint$ptr value) {
        assert (!this._isConstPtr()) : "Cannot modify const object!";
        if (value instanceof uint$ptr$array) {
            uint$ptr$array val = (uint$ptr$array)value;
            this.array = val.array;
            this.index = val.index;
            return this;
        }
        throw new IllegalArgumentException("Different pointer types: expected '" + this.getClass().getName() + "', but found '" + (value != null ? value.getClass() : "null") + "'");
    }

    @Override
    public boolean isComparableTo(void$ptr other) {
        return other instanceof uint$ptr$array && ((uint$ptr$array)other).array == this.array;
    }

    @Override
    public boolean $less(Object obj) {
        if (obj instanceof uint$ptr$array) {
            uint$ptr$array other = (uint$ptr$array)obj;
            return other.array == this.array && this.index - other.index < 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $lesseq(Object obj) {
        if (obj instanceof uint$ptr$array) {
            uint$ptr$array other = (uint$ptr$array)obj;
            return other.array == this.array && this.index - other.index <= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greater(Object obj) {
        if (obj instanceof uint$ptr$array) {
            uint$ptr$array other = (uint$ptr$array)obj;
            return other.array == this.array && this.index - other.index > 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $greatereq(Object obj) {
        if (obj instanceof uint$ptr$array) {
            uint$ptr$array other = (uint$ptr$array)obj;
            return other.array == this.array && this.index - other.index >= 0;
        }
        throw new IllegalArgumentException("Not comparable pointer types: " + this.getClass() + " and " + obj.getClass());
    }

    @Override
    public boolean $eq(Object p) {
        if (p instanceof uint$ptr$array) {
            uint$ptr$array other = (uint$ptr$array)p;
            return other.array == this.array && this.index == other.index;
        }
        return false;
    }

    @Override
    public boolean $noteq(Object p) {
        return !this.$eq(p);
    }

    @Override
    public uint$ref star$ref() {
        return new uint$ref(){
            uint$ptr$array localPtr;
            {
                this.localPtr = uint$ptr$array.this;
            }

            @Override
            public int $deref() {
                return this.localPtr.$star();
            }

            @Override
            public int $set(int value) {
                return this.localPtr.$set(value);
            }

            @Override
            public uint$ptr deref$ptr() {
                if (this.localPtr == uint$ptr$array.this) {
                    this.localPtr = this.localPtr.clone();
                }
                return this.localPtr;
            }
        };
    }

    @Override
    public int $hashcode() {
        return System.identityHashCode(this.array) ^ this.index;
    }

    @Override
    public uint$ptr$array clone() {
        return new uint$ptr$array(this, false, this._isConstContent());
    }

    @Override
    public uint$ptr$array const_clone() {
        return super._isConstPtr() ? this : new uint$ptr$array(this, true, this._isConstContent());
    }

    public String toString() {
        if (this.array == null || this.array.length == 0) {
            return "<EMPTY>";
        }
        StringBuilder sb = new StringBuilder("\n" + uint$ptr$array.class.getSimpleName() + "{range=[" + this.index + "-" + this.array.length + "]\n");
        String fmt = "%" + (int)Math.ceil(Math.log10(this.array.length + 1)) + "d";
        for (int i = this.index; i < this.array.length; ++i) {
            int b = this.array[i];
            sb.append(i == this.index ? "*[" : " [").append(String.format(fmt, i)).append("]");
            sb.append(b).append("\n");
            if (i - this.index <= 256) continue;
            sb.append("....");
            break;
        }
        sb.append("}").append(uint$ptr$array.class.getSimpleName()).append("\n");
        return sb.toString();
    }

    public static void trackInstance(boolean constPtr, boolean constContent) {
        if (NativeTrace.STATISTICS) {
            if (constPtr && constContent) {
                ++fullyConstInstances;
            } else if (constPtr) {
                ++constPtrInstances;
            } else if (constContent) {
                ++constContentInstances;
            } else {
                ++nonConstInstances;
            }
        }
    }

    public static void clearStatistics() {
        fullyConstInstances = 0L;
        constPtrInstances = 0L;
        constContentInstances = 0L;
        nonConstInstances = 0L;
    }

    public static long printStatistics(PrintWriter out) {
        long totalInstances = nonConstInstances + fullyConstInstances + constPtrInstances + constContentInstances;
        out.printf("%30s created all:\t%s%n", uint$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(totalInstances));
        out.printf("%32s non const:\t%s%n", uint$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(nonConstInstances));
        out.printf("%32s const ptr:\t%s%n", uint$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constPtrInstances));
        out.printf("%28s const content:\t%s%n", uint$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(constContentInstances));
        out.printf("%20s const ptr and content:\t%s%n", uint$ptr$array.class.getSimpleName(), NativeTrace.formatNumber(fullyConstInstances));
        return totalInstances;
    }

    @Override
    public final int[] $array() {
        return this.array;
    }
}

