/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.groovy.grailsproject.actions;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.editor.BaseAction;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.spi.GsfUtilities;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.groovy.grailsproject.GrailsProject;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;

public abstract class GotoBaseAction
extends BaseAction {
    protected static final String GSP_MIME_TYPE = "text/x-gsp";

    protected abstract FileObject getTargetFO(String var1, FileObject var2);

    protected abstract String getTargetFilePath(String var1, FileObject var2);

    public GotoBaseAction(String name) {
        super(name);
    }

    public boolean isEnabled() {
        if (!this.isValid(Utilities.getFocusedComponent())) {
            return false;
        }
        FileObject fileObject = this.findTargetFO();
        return fileObject != null && fileObject.canRead();
    }

    public void actionPerformed(ActionEvent caller, JTextComponent sourceComponent) {
        FileObject targetFO = this.findTargetFO();
        if (targetFO != null && targetFO.isValid()) {
            GsfUtilities.open((FileObject)targetFO, (int)0, (String)"");
        }
    }

    private FileObject findTargetFO() {
        DataObject dataObject = this.getDataObjectFromComponent(Utilities.getFocusedComponent());
        FileObject sourceFO = dataObject.getPrimaryFile();
        return this.getTargetFO(dataObject.getName(), sourceFO);
    }

    protected final boolean isGspFO(FileObject fo) {
        return GSP_MIME_TYPE.equals(fo.getMIMEType());
    }

    protected String findPackagePath(FileObject fo) {
        FileObject pkgFO = fo.getParent();
        if (pkgFO == null) {
            return "";
        }
        String pkgName = pkgFO.getName();
        if (!("controllers".equals(pkgName) || "domain".equals(pkgName) || "views".equals(pkgName))) {
            String parentPath = this.findPackagePath(pkgFO);
            if ("".equals(parentPath)) {
                return pkgName;
            }
            return parentPath + File.separator + pkgName;
        }
        return "";
    }

    protected String getExtendedBaseDir(FileObject fo, String extension) {
        return this.getBaseDir(fo) + extension + File.separator;
    }

    private boolean isValid(JTextComponent sourceComponent) {
        DataObject dob = this.getDataObjectFromComponent(sourceComponent);
        if (dob == null) {
            return false;
        }
        FileObject fo = dob.getPrimaryFile();
        if (fo == null) {
            return false;
        }
        GrailsProject project = this.getOwningProject(fo);
        if (project == null) {
            return false;
        }
        String mimetype = fo.getMIMEType();
        return mimetype.equals("text/x-groovy") || mimetype.equals(GSP_MIME_TYPE);
    }

    private DataObject getDataObjectFromComponent(JTextComponent sourceComponent) {
        if (sourceComponent == null) {
            return null;
        }
        Document doc = sourceComponent.getDocument();
        if (doc == null) {
            return null;
        }
        return NbEditorUtilities.getDataObject((Document)doc);
    }

    private GrailsProject getOwningProject(FileObject fo) {
        Project project = FileOwnerQuery.getOwner((FileObject)fo);
        if (project instanceof GrailsProject) {
            return (GrailsProject)project;
        }
        return null;
    }

    private String getBaseDir(FileObject fo) {
        return FileUtil.getFileDisplayName((FileObject)this.getOwningProject(fo).getProjectDirectory()) + File.separator + "grails-app" + File.separator;
    }
}

