/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.model.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.modules.parsing.spi.indexing.support.QuerySupport;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.NamespaceIndexFilter;
import org.netbeans.modules.php.editor.api.PhpElementKind;
import org.netbeans.modules.php.editor.api.PhpModifiers;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.model.ClassConstantElement;
import org.netbeans.modules.php.editor.model.ClassScope;
import org.netbeans.modules.php.editor.model.IndexScope;
import org.netbeans.modules.php.editor.model.InterfaceScope;
import org.netbeans.modules.php.editor.model.MethodScope;
import org.netbeans.modules.php.editor.model.ModelElement;
import org.netbeans.modules.php.editor.model.ModelUtils;
import org.netbeans.modules.php.editor.model.NamespaceScope;
import org.netbeans.modules.php.editor.model.Scope;
import org.netbeans.modules.php.editor.model.TraitScope;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.impl.IndexScopeImpl;
import org.netbeans.modules.php.editor.model.impl.InterfaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ModelElementImpl;
import org.netbeans.modules.php.editor.model.impl.NamespaceScopeImpl;
import org.netbeans.modules.php.editor.model.impl.ScopeImpl;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ClassDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.ClassInstanceCreationInfo;
import org.netbeans.modules.php.editor.model.nodes.InterfaceDeclarationInfo;
import org.netbeans.modules.php.editor.model.nodes.TraitDeclarationInfo;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;

abstract class TypeScopeImpl
extends ScopeImpl
implements TypeScope {
    private Map<String, List<? extends InterfaceScope>> ifaces = new HashMap<String, List<? extends InterfaceScope>>();
    private Collection<QualifiedName> fqIfaces = new HashSet<QualifiedName>();
    private Set<? super TypeScope> superRecursionDetection = new HashSet<TypeScope>();
    private Set<? super TypeScope> subRecursionDetection = new HashSet<TypeScope>();

    TypeScopeImpl(Scope inScope, ClassDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, nodeInfo.getAccessModifiers(), ((ClassDeclaration)nodeInfo.getOriginalNode()).getBody(), isDeprecated);
        List<? extends Expression> interfaces = nodeInfo.getInterfaces();
        for (Expression expression : interfaces) {
            String ifaceName = CodeUtils.extractQualifiedName(expression);
            this.ifaces.put(ifaceName, null);
            this.fqIfaces.add(VariousUtils.getFullyQualifiedName(QualifiedName.create(ifaceName), ((ClassDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), inScope));
        }
    }

    TypeScopeImpl(Scope inScope, ClassInstanceCreationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, nodeInfo.getAccessModifiers(), ((ClassInstanceCreation)nodeInfo.getOriginalNode()).getBody(), isDeprecated);
        List<? extends Expression> interfaces = nodeInfo.getInterfaces();
        for (Expression expression : interfaces) {
            String ifaceName = CodeUtils.extractQualifiedName(expression);
            this.ifaces.put(ifaceName, null);
            this.fqIfaces.add(VariousUtils.getFullyQualifiedName(QualifiedName.create(ifaceName), ((ClassInstanceCreation)nodeInfo.getOriginalNode()).getStartOffset(), inScope));
        }
    }

    TypeScopeImpl(Scope inScope, InterfaceDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, PhpModifiers.fromBitMask(1), ((InterfaceDeclaration)nodeInfo.getOriginalNode()).getBody(), isDeprecated);
        List<? extends Expression> interfaces = nodeInfo.getInterfaces();
        for (Expression expression : interfaces) {
            String ifaceName = CodeUtils.extractQualifiedName(expression);
            this.ifaces.put(ifaceName, null);
            this.fqIfaces.add(VariousUtils.getFullyQualifiedName(QualifiedName.create(ifaceName), ((InterfaceDeclaration)nodeInfo.getOriginalNode()).getStartOffset(), inScope));
        }
    }

    TypeScopeImpl(Scope inScope, TraitDeclarationInfo nodeInfo, boolean isDeprecated) {
        super(inScope, nodeInfo, PhpModifiers.fromBitMask(1), ((TraitDeclaration)nodeInfo.getOriginalNode()).getBody(), isDeprecated);
    }

    protected TypeScopeImpl(Scope inScope, ClassElement element) {
        super(inScope, element, PhpElementKind.CLASS);
        this.fqIfaces = element.getFQSuperInterfaceNames();
        for (QualifiedName qualifiedName : element.getSuperInterfaces()) {
            this.ifaces.put(qualifiedName.toString(), null);
        }
    }

    protected TypeScopeImpl(Scope inScope, InterfaceElement element) {
        super(inScope, element, PhpElementKind.IFACE);
        this.fqIfaces = element.getFQSuperInterfaceNames();
        for (QualifiedName qualifiedName : element.getSuperInterfaces()) {
            this.ifaces.put(qualifiedName.toString(), null);
        }
    }

    protected TypeScopeImpl(Scope inScope, TraitElement element) {
        super(inScope, element, PhpElementKind.TRAIT);
    }

    @Override
    public Collection<QualifiedName> getFQSuperInterfaceNames() {
        return this.fqIfaces;
    }

    public List<? extends String> getSuperInterfaceNames() {
        if (this.indexedElement instanceof TypeElement) {
            ArrayList<String> retval = new ArrayList<String>();
            Set<QualifiedName> superInterfaces = ((TypeElement)this.indexedElement).getSuperInterfaces();
            for (QualifiedName qualifiedName : superInterfaces) {
                retval.add(qualifiedName.toString());
            }
            return retval;
        }
        return new ArrayList<String>(this.ifaces.keySet());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @SuppressWarnings(value={"WMI_WRONG_MAP_ITERATOR"}, justification="Way too complicated code")
    public List<? extends InterfaceScope> getSuperInterfaceScopes() {
        Set<Object> keySet;
        LinkedHashSet<? extends InterfaceScope> retval = new LinkedHashSet<InterfaceScope>();
        Set<Object> set = keySet = this.indexedElement instanceof TypeElement ? new HashSet(this.getSuperInterfaceNames()) : this.ifaces.keySet();
        if (!this.fqIfaces.isEmpty()) {
            for (QualifiedName qualifiedName : this.fqIfaces) {
                retval.addAll(IndexScopeImpl.getInterfaces(qualifiedName, this));
            }
        }
        if (!retval.isEmpty() || keySet.isEmpty()) return new ArrayList(retval);
        for (String string : keySet) {
            List<InterfaceScope> iface = this.ifaces.get(string);
            if (iface == null) {
                if (this.indexedElement == null) {
                    Scope inScope = this.getInScope();
                    if (inScope instanceof ClassScope || inScope instanceof TraitScope) {
                        while (!(inScope instanceof NamespaceScope) && (inScope = inScope.getInScope()) != null) {
                        }
                    }
                    if (inScope instanceof NamespaceScope) {
                        NamespaceScope top = (NamespaceScope)inScope;
                        NamespaceScopeImpl ps = (NamespaceScopeImpl)top;
                        iface = ModelUtils.filter(ps.getDeclaredInterfaces(), string);
                        retval.addAll(iface);
                        this.ifaces.put(string, iface);
                        if (retval.isEmpty() && top instanceof NamespaceScopeImpl) {
                            IndexScope indexScope = ModelUtils.getIndexScope(ps);
                            if (indexScope == null) throw new UnsupportedOperationException();
                            List<? extends InterfaceScope> cIfaces = IndexScopeImpl.getInterfaces(QualifiedName.create(string), this);
                            this.ifaces.put(string, cIfaces);
                            for (InterfaceScope interfaceScope : cIfaces) {
                                retval.add((InterfaceScopeImpl)interfaceScope);
                            }
                        }
                    }
                } else {
                    iface = Collections.emptyList();
                }
            } else {
                retval.addAll(iface);
            }
            assert (iface != null);
        }
        return new ArrayList(retval);
    }

    @Override
    public Collection<? extends MethodScope> getDeclaredMethods() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScope indexScopeImpl = ModelUtils.getIndexScope(this);
            return indexScopeImpl.findMethods(this);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.METHOD);
            }
        });
    }

    public Collection<? extends MethodScope> findDeclaredMethods(final String queryName, final int ... modifiers) {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            QualifiedName qn = this.getNamespaceName().append(this.getName());
            NamespaceIndexFilter filter = new NamespaceIndexFilter(qn.toString());
            List<? extends MethodScope> methods = indexScopeImpl.findMethods(this, queryName, modifiers);
            return filter.filterModelElements(methods, true);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.METHOD) && ModelElementImpl.nameKindMatch(element.getName(), QuerySupport.Kind.EXACT, queryName) && (modifiers.length == 0 || (element.getPhpModifiers().toFlags() & PhpModifiers.fromBitMask(modifiers).toFlags()) != 0);
            }
        });
    }

    @Override
    public final Collection<? extends ClassConstantElement> getDeclaredConstants() {
        if (ModelUtils.getFileScope(this) == null) {
            IndexScopeImpl indexScopeImpl = (IndexScopeImpl)ModelUtils.getIndexScope(this);
            return indexScopeImpl.findClassConstants(this);
        }
        return TypeScopeImpl.filter(this.getElements(), new ScopeImpl.ElementFilter(){

            @Override
            public boolean isAccepted(ModelElement element) {
                return element.getPhpElementKind().equals((Object)PhpElementKind.TYPE_CONSTANT);
            }
        });
    }

    @Override
    public String getNormalizedName() {
        StringBuilder sb = new StringBuilder();
        Collection<QualifiedName> fQSuperInterfaceNames = this.getFQSuperInterfaceNames();
        if (fQSuperInterfaceNames.isEmpty()) {
            Collection ifaceNames = this.getSuperInterfaceNames();
            for (String ifName : ifaceNames) {
                sb.append(ifName);
            }
        } else {
            for (QualifiedName qualifiedName : fQSuperInterfaceNames) {
                sb.append(qualifiedName.toString());
            }
        }
        return sb.toString() + super.getNormalizedName();
    }

    @Override
    public Set<QualifiedName> getSuperInterfaces() {
        HashSet<QualifiedName> retval = new HashSet<QualifiedName>();
        Collection superInterfaceNames = this.getSuperInterfaceNames();
        for (String name : superInterfaceNames) {
            retval.add(QualifiedName.create(name));
        }
        return retval;
    }

    @Override
    public final boolean isClass() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.CLASS);
    }

    @Override
    public final boolean isInterface() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.IFACE);
    }

    @Override
    public final boolean isTrait() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.TRAIT);
    }

    @Override
    public final boolean isTraited() {
        return this.getPhpElementKind().equals((Object)PhpElementKind.TRAIT) || this.getPhpElementKind().equals((Object)PhpElementKind.CLASS);
    }

    @Override
    public boolean isSuperTypeOf(TypeScope subType) {
        boolean result = false;
        if (this.superRecursionDetection.add(subType)) {
            InterfaceScope interfaceScope;
            Iterator<? extends InterfaceScope> iterator = subType.getSuperInterfaceScopes().iterator();
            while (iterator.hasNext() && !(result = (interfaceScope = iterator.next()).equals(this) ? true : this.isSuperTypeOf(interfaceScope))) {
            }
            if (!result && !subType.isInterface()) {
                result = subType.isSubTypeOf(this);
            }
        }
        return result;
    }

    @Override
    public boolean isSubTypeOf(TypeScope superType) {
        boolean result;
        block1: {
            InterfaceScope interfaceScope;
            result = false;
            if (!this.subRecursionDetection.add(superType) || !superType.isInterface()) break block1;
            Iterator iterator = this.getSuperInterfaceScopes().iterator();
            while (iterator.hasNext() && !(result = (interfaceScope = (InterfaceScope)iterator.next()).equals(superType) ? true : interfaceScope.isSubTypeOf(superType))) {
            }
        }
        return result;
    }
}

