/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.tag;

import java.awt.Dialog;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitTag;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.ui.repository.RevisionDialogController;
import org.netbeans.modules.git.remote.ui.tag.CreateTagPanel;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class CreateTag
implements DocumentListener,
ActionListener {
    private final CreateTagPanel panel;
    private final RevisionDialogController revisionPicker;
    private JButton okButton;
    private DialogDescriptor dd;
    private boolean revisionValid = true;
    private Boolean nameValid = false;
    private final RequestProcessor.Task branchCheckTask;
    private String tagName;
    private final VCSFileProxy repository;
    private final Icon ICON_INFO = new ImageIcon(this.getClass().getResource("/org/netbeans/modules/git/remote/resources/icons/info.png"));

    CreateTag(VCSFileProxy repository, String initialRevision, String initialTagName) {
        this.repository = repository;
        this.branchCheckTask = Git.getInstance().getRequestProcessor(repository).create((Runnable)new TagNameCheckWorker());
        this.revisionPicker = new RevisionDialogController(repository, new VCSFileProxy[]{repository}, initialRevision);
        this.panel = new CreateTagPanel(this.revisionPicker.getPanel());
        this.panel.tagNameField.setText(initialTagName);
    }

    String getRevision() {
        return this.revisionPicker.getRevision().getRevision();
    }

    String getTagName() {
        return this.panel.tagNameField.getText().trim();
    }

    String getTagMessage() {
        return this.panel.tagMessageField.getText().trim();
    }

    boolean show() {
        this.okButton = new JButton(NbBundle.getMessage(CreateTag.class, (String)"LBL_CreateTag.OKButton.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.okButton, (String)this.okButton.getText());
        this.dd = new DialogDescriptor((Object)this.panel, NbBundle.getMessage(CreateTag.class, (String)"LBL_CreateTag.title"), true, new Object[]{this.okButton, DialogDescriptor.CANCEL_OPTION}, (Object)this.okButton, 0, new HelpCtx(CreateTag.class), null);
        this.validate();
        this.revisionPicker.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName() == "RevisionDialogController.valid") {
                    CreateTag.this.setRevisionValid(Boolean.TRUE.equals(evt.getNewValue()));
                }
            }
        });
        this.panel.tagNameField.getDocument().addDocumentListener(this);
        this.panel.tagMessageField.getDocument().addDocumentListener(this);
        this.panel.cbForceUpdate.addActionListener(this);
        Dialog d = DialogDisplayer.getDefault().createDialog(this.dd);
        d.setVisible(true);
        return this.okButton == this.dd.getValue();
    }

    private void setRevisionValid(boolean flag) {
        this.revisionValid = flag;
        if (!flag) {
            this.setInfoMessage(NbBundle.getMessage(CreateTag.class, (String)"MSG_CreateTag.errorRevision"));
        }
        this.validate();
    }

    private void validate() {
        boolean flag;
        boolean bl = flag = this.revisionValid && (Boolean.TRUE.equals(this.nameValid) || this.panel.cbForceUpdate.isEnabled() && this.panel.cbForceUpdate.isSelected());
        if (!flag && this.revisionValid) {
            String tName = this.getTagName();
            if (tName.isEmpty() || !GitUtils.isValidTagName(tName)) {
                this.setInfoMessage(NbBundle.getMessage(CreateTag.class, (String)"MSG_CreateTag.errorTagNameInvalid"));
            } else {
                this.setInfoMessage(NbBundle.getMessage(CreateTag.class, (String)"MSG_CreateTag.errorTagExists"));
            }
        }
        if (flag) {
            if (this.getTagMessage().isEmpty()) {
                this.setInfoMessage(NbBundle.getMessage(CreateTag.class, (String)"MSG_CreateTag.infoLightWeightTag"));
            } else {
                this.setInfoMessage(null);
            }
        }
        this.okButton.setEnabled(flag);
        this.dd.setValid(flag);
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        if (e.getDocument() == this.panel.tagMessageField.getDocument()) {
            this.validate();
        } else {
            this.validateName();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        if (e.getDocument() == this.panel.tagMessageField.getDocument()) {
            this.validate();
        } else {
            this.validateName();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.validate();
    }

    private void validateName() {
        this.nameValid = false;
        this.tagName = this.panel.tagNameField.getText();
        if (!this.tagName.isEmpty() && GitUtils.isValidTagName(this.tagName)) {
            this.nameValid = null;
            this.branchCheckTask.cancel();
            this.branchCheckTask.schedule(500);
        }
        this.validate();
    }

    boolean isForceUpdate() {
        return this.panel.cbForceUpdate.isEnabled() && this.panel.cbForceUpdate.isSelected();
    }

    private void setInfoMessage(String message) {
        this.panel.lblInfo.setText(message);
        if (message == null || message.isEmpty()) {
            this.panel.lblInfo.setIcon(null);
        } else {
            this.panel.lblInfo.setIcon(this.ICON_INFO);
        }
    }

    private class TagNameCheckWorker
    implements Runnable {
        private TagNameCheckWorker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            final String tagName = CreateTag.this.tagName;
            GitClient client = null;
            try {
                client = Git.getInstance().getClient(CreateTag.this.repository);
                final Map<String, GitTag> tags = client.getTags(GitUtils.NULL_PROGRESS_MONITOR, true);
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (tagName.equals(((CreateTag)CreateTag.this).panel.tagNameField.getText())) {
                            CreateTag.this.nameValid = !tags.containsKey(tagName);
                            if (!((CreateTag)CreateTag.this).panel.cbForceUpdate.isEnabled()) {
                                ((CreateTag)CreateTag.this).panel.cbForceUpdate.setSelected(false);
                            }
                            ((CreateTag)CreateTag.this).panel.cbForceUpdate.setEnabled(CreateTag.this.nameValid == false);
                            CreateTag.this.validate();
                        }
                    }
                });
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
            }
            finally {
                if (client != null) {
                    client.release();
                }
            }
        }
    }
}

