/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.ui.rebase;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import org.netbeans.modules.git.remote.Git;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRebaseResult;
import org.netbeans.modules.git.remote.cli.GitRepositoryState;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.SearchCriteria;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.git.remote.client.GitClient;
import org.netbeans.modules.git.remote.client.GitClientExceptionHandler;
import org.netbeans.modules.git.remote.client.GitProgressSupport;
import org.netbeans.modules.git.remote.client.ProgressDelegate;
import org.netbeans.modules.git.remote.ui.actions.GitAction;
import org.netbeans.modules.git.remote.ui.actions.SingleRepositoryAction;
import org.netbeans.modules.git.remote.ui.conflicts.ResolveConflictsExecutor;
import org.netbeans.modules.git.remote.ui.output.OutputLogger;
import org.netbeans.modules.git.remote.ui.rebase.Bundle;
import org.netbeans.modules.git.remote.ui.rebase.Rebase;
import org.netbeans.modules.git.remote.ui.repository.RepositoryInfo;
import org.netbeans.modules.git.remote.utils.GitUtils;
import org.netbeans.modules.git.remote.utils.LogUtils;
import org.netbeans.modules.git.remote.utils.ResultProcessor;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.remotefs.versioning.hooks.GitHook;
import org.netbeans.modules.remotefs.versioning.hooks.GitHookContext;
import org.netbeans.modules.remotefs.versioning.hooks.VCSHooks;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.core.spi.VCSContext;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.windows.WindowManager;

public class RebaseAction
extends SingleRepositoryAction {
    private static final Logger LOG = Logger.getLogger(RebaseAction.class.getName());
    private static final String NETBEANS_REBASE_ORIGHEAD = "netbeans-rebase.orighead";
    private static final String NETBEANS_REBASE_UPSTREAM = "netbeans-rebase.upstream";
    private static final String NETBEANS_REBASE_ONTO = "netbeans-rebase.onto";
    private static final String REBASE_MERGE_DIR = "rebase-merge";
    private static final String REBASE_APPLY_DIR = "rebase-apply";
    private static final String MESSAGE = "message";

    @Override
    protected void performAction(VCSFileProxy repository, VCSFileProxy[] roots, VCSContext context) {
        RepositoryInfo info = RepositoryInfo.getInstance(repository);
        info.refresh();
        this.rebase(repository, info);
    }

    private void rebase(VCSFileProxy repository, RepositoryInfo info) {
        GitRepositoryState state = info.getRepositoryState();
        if (state == GitRepositoryState.SAFE) {
            GitBranch current = info.getActiveBranch();
            Rebase rebase = new Rebase(repository, info.getBranches(), current);
            if (rebase.showDialog()) {
                this.runRebase(repository, GitClient.RebaseOperationType.BEGIN, rebase.getRevisionSource(), rebase.getRevisionBase(), rebase.getRevisionDest());
            }
        } else if (state == GitRepositoryState.REBASING) {
            JButton btnContinue = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnContinue, (String)Bundle.CTL_RebaseAction_continueButton_text());
            btnContinue.setToolTipText(Bundle.CTL_RebaseAction_continueButton_TTtext());
            JButton btnAbort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnAbort, (String)Bundle.CTL_RebaseAction_abortButton_text());
            btnAbort.setToolTipText(Bundle.CTL_RebaseAction_abortButton_TTtext());
            JButton btnSkip = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)btnSkip, (String)Bundle.CTL_RebaseAction_skipButton_text());
            btnSkip.setToolTipText(Bundle.CTL_RebaseAction_skipButton_TTtext());
            HashMap<JButton, GitClient.RebaseOperationType> operations = new HashMap<JButton, GitClient.RebaseOperationType>();
            operations.put(btnContinue, GitClient.RebaseOperationType.CONTINUE);
            operations.put(btnSkip, GitClient.RebaseOperationType.SKIP);
            operations.put(btnAbort, GitClient.RebaseOperationType.ABORT);
            Object value = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_Rebase_rebasingState_text(repository.getName()), Bundle.LBL_Rebase_rebasingState_title(), 1, 3, new Object[]{btnContinue, btnSkip, btnAbort, NotifyDescriptor.CANCEL_OPTION}, (Object)btnContinue));
            GitClient.RebaseOperationType op = (GitClient.RebaseOperationType)operations.get(value);
            if (op != null) {
                this.runRebase(repository, op, null, null, null);
            }
        } else {
            GitClientExceptionHandler.annotate(Bundle.MSG_RebaseAction_rebaseNotAllowed(state));
        }
    }

    private void runRebase(final VCSFileProxy repository, final GitClient.RebaseOperationType op, final String source, final String upstream, final String onto) {
        GitProgressSupport supp = new GitProgressSupport(){

            @Override
            protected void perform() {
                try {
                    final ProgressDelegate progress = this.getProgress();
                    GitUtils.runWithoutIndexing(new Callable<Void>(){

                        @Override
                        public Void call() throws Exception {
                            String lSource = source;
                            String lOnto = onto;
                            String lUpstream = upstream;
                            if (op != GitClient.RebaseOperationType.BEGIN) {
                                if (op != GitClient.RebaseOperationType.ABORT && !RebaseAction.this.checkRebaseFolder(repository)) {
                                    return null;
                                }
                                lSource = RebaseAction.getRebaseFileContent(repository, RebaseAction.NETBEANS_REBASE_ORIGHEAD);
                                lOnto = RebaseAction.getOnto(repository);
                                lUpstream = RebaseAction.getRebaseFileContent(repository, RebaseAction.NETBEANS_REBASE_UPSTREAM);
                            }
                            GitClient client = this.getClient();
                            RebaseResultProcessor rrp = new RebaseResultProcessor(client, repository, lOnto, lUpstream, lSource, progress, this.getProgressSupport().getLogger());
                            GitClient.RebaseOperationType nextAction = op;
                            while (nextAction != null && !this.isCanceled()) {
                                GitRebaseResult result = client.rebase(nextAction, lOnto, this.getProgressMonitor());
                                rrp.processResult(result);
                                nextAction = rrp.getNextAction();
                            }
                            return null;
                        }
                    }, new VCSFileProxy[0]);
                }
                catch (GitException ex) {
                    try {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    catch (Throwable throwable) {
                        this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                        Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                        GitUtils.headChanged(repository);
                        throw throwable;
                    }
                    this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                    Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                    GitUtils.headChanged(repository);
                }
                this.setDisplayName(NbBundle.getMessage(GitAction.class, (String)"LBL_Progress.RefreshingStatuses"));
                Git.getInstance().getFileStatusCache().refreshAllRoots(Collections.singletonMap(repository, Git.getInstance().getSeenRoots(repository)));
                GitUtils.headChanged(repository);
            }

            private GitProgressSupport getProgressSupport() {
                return this;
            }
        };
        supp.start(Git.getInstance().getRequestProcessor(repository), repository, Bundle.MSG_RebaseAction_progress());
    }

    private boolean checkRebaseFolder(VCSFileProxy repository) {
        VCSFileProxy folder = RebaseAction.getRebaseFolder(repository);
        VCSFileProxy messageFile = VCSFileProxy.createFileProxy((VCSFileProxy)folder, (String)MESSAGE);
        if (messageFile.exists()) {
            return true;
        }
        Mutex.EVENT.readAccess(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(WindowManager.getDefault().getMainWindow(), Bundle.MSG_RebaseAction_continueExternalRebase_text(), Bundle.LBL_RebaseAction_continueExternalRebase_title(), 0);
            }
        });
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getRebaseFileContent(VCSFileProxy repository, String filename) throws GitException {
        VCSFileProxy rebaseFolder = RebaseAction.getRebaseFolder(repository);
        if (rebaseFolder.exists()) {
            VCSFileProxy file = VCSFileProxy.createFileProxy((VCSFileProxy)rebaseFolder, (String)filename);
            if (VCSFileProxySupport.canRead((VCSFileProxy)file)) {
                BufferedReader br = null;
                try {
                    br = new BufferedReader(new InputStreamReader(file.getInputStream(false), "UTF-8"));
                    String string = br.readLine();
                    return string;
                }
                catch (IOException ex) {
                    LOG.log(Level.FINE, null, ex);
                }
                finally {
                    if (br != null) {
                        try {
                            br.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        } else {
            throw new GitException(Bundle.MSG_RebaseAction_noMergeStrategies());
        }
        return null;
    }

    private static VCSFileProxy getRebaseFolder(VCSFileProxy repository) {
        VCSFileProxy rebaseFolder = VCSFileProxy.createFileProxy((VCSFileProxy)GitUtils.getGitFolderForRoot(repository), (String)REBASE_APPLY_DIR);
        if (!rebaseFolder.exists()) {
            rebaseFolder = VCSFileProxy.createFileProxy((VCSFileProxy)GitUtils.getGitFolderForRoot(repository), (String)REBASE_MERGE_DIR);
        }
        return rebaseFolder;
    }

    private static String getOnto(VCSFileProxy repository) throws GitException {
        String onto = RebaseAction.getRebaseFileContent(repository, NETBEANS_REBASE_ONTO);
        if (onto == null) {
            onto = RebaseAction.getRebaseFileContent(repository, "onto-name");
        }
        if (onto == null) {
            onto = RebaseAction.getRebaseFileContent(repository, "onto_name");
        }
        if (onto == null) {
            onto = RebaseAction.getRebaseFileContent(repository, "onto");
        }
        return onto;
    }

    private static Map<String, String> findChangesetMapping(GitHookContext.LogEntry[] originalEntries, GitHookContext.LogEntry[] newEntries) {
        HashMap<String, String> mapping = new HashMap<String, String>(originalEntries.length);
        for (GitHookContext.LogEntry original : originalEntries) {
            boolean found = false;
            for (GitHookContext.LogEntry newEntry : newEntries) {
                if (!original.getChangeset().equals(newEntry.getChangeset()) && (!original.getDate().equals(newEntry.getDate()) || !original.getAuthor().equals(newEntry.getAuthor()) || !original.getMessage().equals(newEntry.getMessage()))) continue;
                mapping.put(original.getChangeset(), newEntry.getChangeset());
                found = true;
                break;
            }
            if (found) continue;
            mapping.put(original.getChangeset(), null);
        }
        return mapping;
    }

    private static GitHookContext.LogEntry[] getEntries(GitClient client, String revisionFrom, String revisionTo, ProgressMonitor pm) throws GitException {
        SearchCriteria crit = new SearchCriteria();
        crit.setRevisionFrom(revisionFrom);
        crit.setRevisionTo(revisionTo);
        GitRevisionInfo[] log = client.log(crit, false, pm);
        return RebaseAction.convertToEntries(log);
    }

    private static GitHookContext.LogEntry[] convertToEntries(GitRevisionInfo[] messages) {
        ArrayList<GitHookContext.LogEntry> entries = new ArrayList<GitHookContext.LogEntry>(messages.length);
        for (GitRevisionInfo msg : messages) {
            entries.add(new GitHookContext.LogEntry(msg.getFullMessage(), msg.getAuthor().toString(), msg.getRevision(), new Date(msg.getCommitTime())));
        }
        return entries.toArray(new GitHookContext.LogEntry[entries.size()]);
    }

    public static class RebaseResultProcessor
    extends ResultProcessor {
        private final OutputLogger logger;
        private final String onto;
        private final String origHead;
        private final String upstream;
        private GitClient.RebaseOperationType nextAction;
        private final ProgressDelegate progress;

        public RebaseResultProcessor(GitClient client, VCSFileProxy repository, String onto, String upstream, String origHead, ProgressDelegate progress, OutputLogger logger) {
            super(client, repository, onto, progress.getProgressMonitor());
            this.origHead = origHead;
            this.onto = onto;
            this.upstream = upstream;
            this.logger = logger;
            this.progress = progress;
        }

        public void processResult(GitRebaseResult result) {
            GitRevisionInfo info;
            this.nextAction = null;
            StringBuilder sb = new StringBuilder(Bundle.MSG_RebaseAction_result(result.getRebaseStatus().toString()));
            String base = null;
            try {
                GitRevisionInfo i;
                info = this.client.log("HEAD", GitUtils.NULL_PROGRESS_MONITOR);
                if (this.origHead != null && this.onto != null && (i = this.client.getCommonAncestor(new String[]{this.origHead, this.onto}, this.pm)) != null) {
                    base = i.getRevision();
                }
            }
            catch (GitException ex) {
                GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                return;
            }
            this.persistNBConfig();
            boolean logActions = false;
            switch (result.getRebaseStatus()) {
                case ABORTED: {
                    sb.append(Bundle.MSG_RebaseAction_result_aborted(info.getRevision()));
                    GitUtils.printInfo(sb, info);
                    break;
                }
                case FAILED: 
                case CONFLICTS: {
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Local modifications in WT during rebase: {0} - {1}", new Object[]{this.repository, result.getFailures()});
                    }
                    try {
                        if (!this.resolveLocalChanges(result.getFailures().toArray(new VCSFileProxy[result.getFailures().size()]))) break;
                        this.nextAction = GitClient.RebaseOperationType.BEGIN;
                    }
                    catch (GitException ex) {
                        GitClientExceptionHandler.notifyException((Exception)((Object)ex), true);
                    }
                    break;
                }
                case NOTHING_TO_COMMIT: {
                    this.nextAction = this.resolveNothingToCommit();
                    break;
                }
                case FAST_FORWARD: 
                case OK: {
                    sb.append(Bundle.MSG_RebaseAction_result_ok(info.getRevision()));
                    GitUtils.printInfo(sb, info, false);
                    logActions = true;
                    this.updatePushHooks();
                    break;
                }
                case STOPPED: {
                    sb.append(Bundle.MSG_RebaseAction_result_conflict());
                    this.printConflicts(this.logger, sb, result.getConflicts());
                    this.nextAction = this.resolveRebaseConflicts(result.getConflicts());
                    break;
                }
                case UP_TO_DATE: {
                    sb.append(Bundle.MSG_RebaseAction_result_alreadyUpToDate(this.onto));
                }
            }
            if (sb.length() > 0) {
                this.logger.outputLine(sb.toString());
            }
            if (logActions) {
                this.logRebaseResult(info.getRevision(), base);
            }
        }

        public GitClient.RebaseOperationType getNextAction() {
            return this.nextAction;
        }

        private GitClient.RebaseOperationType resolveRebaseConflicts(Collection<VCSFileProxy> conflicts) {
            GitClient.RebaseOperationType action = null;
            JButton abort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)abort, (String)Bundle.LBL_RebaseResultProcessor_abortButton_text());
            abort.setToolTipText(Bundle.LBL_RebaseResultProcessor_abortButton_TTtext());
            JButton resolve = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)resolve, (String)Bundle.LBL_RebaseResultProcessor_resolveButton_text());
            resolve.setToolTipText(Bundle.LBL_RebaseResultProcessor_resolveButton_TTtext());
            JButton review = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)review, (String)Bundle.LBL_RebaseResultProcessor_reviewButton_text());
            review.setToolTipText(Bundle.LBL_RebaseResultProcessor_reviewButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_RebaseResultProcessor_resolveConflicts(), Bundle.LBL_RebaseResultProcessor_resolveConflicts(), 2, 3, new Object[]{resolve, review, abort, NotifyDescriptor.CANCEL_OPTION}, (Object)resolve));
            if (o == review) {
                this.openInVersioningView(conflicts);
            } else if (o == resolve) {
                ResolveConflictsExecutor supp = new ResolveConflictsExecutor(conflicts.toArray(new VCSFileProxy[conflicts.size()]));
                supp.start(Git.getInstance().getRequestProcessor(this.repository), this.repository, Bundle.MSG_Rebase_resolving());
            } else if (o == abort) {
                action = GitClient.RebaseOperationType.ABORT;
            }
            return action;
        }

        private GitClient.RebaseOperationType resolveNothingToCommit() {
            GitClient.RebaseOperationType action = null;
            JButton abort = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)abort, (String)Bundle.LBL_RebaseResultProcessor_abortButton_text());
            abort.setToolTipText(Bundle.LBL_RebaseResultProcessor_abortButton_TTtext());
            JButton skip = new JButton();
            Mnemonics.setLocalizedText((AbstractButton)skip, (String)Bundle.LBL_RebaseResultProcessor_skipButton_text());
            skip.setToolTipText(Bundle.LBL_RebaseResultProcessor_skipButton_TTtext());
            Object o = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)Bundle.MSG_RebaseResultProcessor_nothingToCommit(), Bundle.LBL_RebaseResultProcessor_nothingToCommit(), 2, 3, new Object[]{skip, abort, NotifyDescriptor.CANCEL_OPTION}, (Object)skip));
            if (o == skip) {
                action = GitClient.RebaseOperationType.SKIP;
            } else if (o == abort) {
                action = GitClient.RebaseOperationType.ABORT;
            }
            return action;
        }

        private void persistNBConfig() {
            VCSFileProxy rebaseFolder;
            if (this.onto != null && this.upstream != null && this.origHead != null && (rebaseFolder = RebaseAction.getRebaseFolder(this.repository)).canWrite()) {
                try {
                    VCSFileProxySupport.copyStreamToFile((InputStream)new ByteArrayInputStream(this.onto.getBytes("UTF-8")), (VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)rebaseFolder, (String)RebaseAction.NETBEANS_REBASE_ONTO));
                    VCSFileProxySupport.copyStreamToFile((InputStream)new ByteArrayInputStream(this.upstream.getBytes("UTF-8")), (VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)rebaseFolder, (String)RebaseAction.NETBEANS_REBASE_UPSTREAM));
                    VCSFileProxySupport.copyStreamToFile((InputStream)new ByteArrayInputStream(this.origHead.getBytes("UTF-8")), (VCSFileProxy)VCSFileProxy.createFileProxy((VCSFileProxy)rebaseFolder, (String)RebaseAction.NETBEANS_REBASE_ORIGHEAD));
                }
                catch (IOException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
        }

        private void logRebaseResult(String newHeadId, String base) {
            if (base != null && newHeadId != null) {
                String oldId = base;
                String newId = newHeadId;
                String branchName = RepositoryInfo.getInstance(this.repository).getActiveBranch().getName();
                LogUtils.logBranchUpdateReview(this.repository, branchName, oldId, newId, this.logger);
            }
        }

        private void updatePushHooks() {
            Collection hooks;
            if (this.onto != null && this.upstream != null && this.origHead != null && !(hooks = VCSHooks.getInstance().getHooks(GitHook.class)).isEmpty() && !this.pm.isCanceled()) {
                this.progress.setProgress(Bundle.MSG_RebaseAction_updatingHooks());
                try {
                    GitHookContext.LogEntry[] originalEntries = RebaseAction.getEntries(this.client, this.upstream, this.origHead, this.pm);
                    if (this.pm.isCanceled()) {
                        return;
                    }
                    GitHookContext.LogEntry[] newEntries = RebaseAction.getEntries(this.client, this.onto, "HEAD", this.pm);
                    if (this.pm.isCanceled()) {
                        return;
                    }
                    Map mapping = RebaseAction.findChangesetMapping(originalEntries, newEntries);
                    for (GitHook gitHook : hooks) {
                        gitHook.afterCommitReplace(new GitHookContext(new VCSFileProxy[]{this.repository}, null, originalEntries), new GitHookContext(new VCSFileProxy[]{this.repository}, null, newEntries), mapping);
                    }
                }
                catch (GitException ex) {
                    LOG.log(Level.INFO, null, ex);
                }
            }
        }
    }
}

