/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.tools.impl;

import org.clang.driver.Action;
import org.clang.driver.Command;
import org.clang.driver.Compilation;
import org.clang.driver.Driver;
import org.clang.driver.JobAction;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.impl.InputInfo;
import org.clang.driver.impl.ToolsStatics;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.CrossWindowsToolChain;
import org.clank.java.std;
import org.clank.java.std_ptr;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.aliases.char;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class CrossWindowsStatics {

    public static class Linker
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Linker(ToolChain TC) {
            super(NativePointer.$((String)"CrossWindows::Linker"), NativePointer.$((String)"ld"), TC, Tool.ResponseFileSupport.RF_Full);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        @Override
        public boolean isLinkJob() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                CrossWindowsToolChain TC = (CrossWindowsToolChain)this.getToolChain();
                Triple T = TC.getTriple();
                Driver D = TC.getDriver();
                SmallString EntryPoint = new SmallString(128);
                ArgStringList CmdArgs = new ArgStringList();
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_g_Group.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_emit_llvm.getValue()));
                Args.ClaimAllArgs(new OptSpecifier(options.ID.OPT_w.getValue()));
                if (!D.SysRoot.empty()) {
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_T_str$C((String)"--sysroot=", (std.string)D.SysRoot))));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_pie.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-pie"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-export-dynamic"));
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_s.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"--strip-all"));
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"-m"));
                switch (TC.getArch()) {
                    default: {
                        throw new llvm_unreachable("unsupported architecture");
                    }
                    case arm: 
                    case thumb: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"thumb2pe"));
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"i386pe"));
                        EntryPoint.append(new StringRef(NativePointer.$UNDERSCORE));
                        break;
                    }
                    case x86_64: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"i386pep"));
                    }
                }
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                    switch (T.getArch()) {
                        default: {
                            throw new llvm_unreachable("unsupported architecture");
                        }
                        case arm: 
                        case thumb: 
                        case x86_64: {
                            EntryPoint.append(new StringRef("_DllMainCRTStartup"));
                            break;
                        }
                        case x86: {
                            EntryPoint.append(new StringRef("_DllMainCRTStartup@12"));
                        }
                    }
                    CmdArgs.push_back((Object)NativePointer.$((String)"-shared"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--enable-auto-image-base"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--entry"));
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(EntryPoint)));
                } else {
                    EntryPoint.append(new StringRef("mainCRTStartup"));
                    CmdArgs.push_back((Object)(Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue())) ? NativePointer.$((String)"-Bstatic") : NativePointer.$((String)"-Bdynamic")));
                    if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--entry"));
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(EntryPoint)));
                    }
                }
                CmdArgs.push_back((Object)NativePointer.$((String)"--allow-multiple-definition"));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) || Args.hasArg(new OptSpecifier(options.ID.OPT_rdynamic.getValue()))) {
                    SmallString ImpLib = new SmallString(new StringRef(Output.getFilename()), 261);
                    path.replace_extension((SmallString)ImpLib, (Twine)new Twine(".lib"));
                    CmdArgs.push_back((Object)NativePointer.$((String)"--out-implib"));
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(ImpLib)));
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue()), new OptSpecifier(options.ID.OPT_nostartfiles.getValue()))) {
                    std.string CRTPath = std.$add_str$C_T((std.string)D.SysRoot, (CharSequence)"/usr/lib/");
                    char.ptr CRTBegin = Native.$tryClone((char.ptr)(Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue())) ? NativePointer.$((String)"crtbeginS.obj") : NativePointer.$((String)"crtbegin.obj")));
                    CmdArgs.push_back((Object)Args.MakeArgString(new Twine(std.$add_str$C_T((std.string)CRTPath, (char.ptr)CRTBegin))));
                }
                Args.AddAllArgs(CmdArgs, new OptSpecifier(options.ID.OPT_L.getValue()));
                TC.AddFilePathLibArgs(Args, CmdArgs);
                ToolsStatics.AddLinkerInputs(TC, Inputs, Args, CmdArgs);
                if (D.CCCIsCXX() && !Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    boolean StaticCXX;
                    boolean bl = StaticCXX = Args.hasArg(new OptSpecifier(options.ID.OPT_static_libstdcxx.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_static.getValue()));
                    if (StaticCXX) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bstatic"));
                    }
                    TC.AddCXXStdlibLibArgs(Args, CmdArgs);
                    if (StaticCXX) {
                        CmdArgs.push_back((Object)NativePointer.$((String)"-Bdynamic"));
                    }
                }
                if (!Args.hasArg(new OptSpecifier(options.ID.OPT_nostdlib.getValue())) && !Args.hasArg(new OptSpecifier(options.ID.OPT_nodefaultlibs.getValue()))) {
                    CmdArgs.push_back((Object)NativePointer.$((String)"-lmsvcrt"));
                    ToolsStatics.AddRunTimeLibs(TC, D, CmdArgs, Args);
                }
                if (TC.getSanitizerArgs().needsAsanRt()) {
                    if (Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()))) {
                        CmdArgs.push_back((Object)TC.getCompilerRTArgString(Args, new StringRef("asan_dll_thunk")));
                    } else {
                        for (char.ptr Lib : new char.ptr[]{NativePointer.$((String)"asan_dynamic"), NativePointer.$((String)"asan_dynamic_runtime_thunk")}) {
                            CmdArgs.push_back((Object)TC.getCompilerRTArgString(Args, new StringRef(Lib)));
                        }
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine("--undefined")));
                        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(TC.getArch() == Triple.ArchType.x86 ? NativePointer.$((String)"___asan_seh_interceptor") : NativePointer.$((String)"__asan_seh_interceptor"))));
                    }
                }
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(TC.GetLinkerPath())));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }

    public static class Assembler
    extends Tool
    implements Destructors.ClassWithDestructor {
        public Assembler(ToolChain TC) {
            super(NativePointer.$((String)"CrossWindows::Assembler"), NativePointer.$((String)"as"), TC);
        }

        @Override
        public boolean hasIntegratedCPP() {
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void ConstructJob(Compilation C, JobAction JA, InputInfo Output, SmallVector<InputInfo> Inputs, ArgList Args, char.ptr LinkingOutput) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                ToolsStatics.claimNoWarnArgs(Args);
                CrossWindowsToolChain TC = (CrossWindowsToolChain)this.getToolChain();
                ArgStringList CmdArgs = new ArgStringList();
                switch (TC.getArch()) {
                    default: {
                        throw new llvm_unreachable("unsupported architecture");
                    }
                    case arm: 
                    case thumb: {
                        break;
                    }
                    case x86: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--32"));
                        break;
                    }
                    case x86_64: {
                        CmdArgs.push_back((Object)NativePointer.$((String)"--64"));
                    }
                }
                Args.AddAllArgValues(CmdArgs, new OptSpecifier(options.ID.OPT_Wa_COMMA.getValue()), new OptSpecifier(options.ID.OPT_Xassembler.getValue()));
                CmdArgs.push_back((Object)NativePointer.$((String)"-o"));
                CmdArgs.push_back((Object)Output.getFilename());
                for (InputInfo Input : Inputs) {
                    CmdArgs.push_back((Object)Input.getFilename());
                }
                std.string Assembler2 = TC.GetProgramPath(NativePointer.$((String)"as"));
                char.ptr Exec = Native.$tryClone((char.ptr)Args.MakeArgString(new Twine(Assembler2)));
                C.addCommand((std_ptr.unique_ptr<Command>)$c$.track(llvm.make_unique((Object)new Command((Action)JA, (Tool)this, Exec, CmdArgs, Inputs))));
                $c$.clean();
            }
            finally {
                $c$.$destroy();
            }
        }

        @Override
        public void $destroy() {
            super.$destroy();
        }

        @Override
        public String toString() {
            return "" + super.toString();
        }
    }
}

