/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.toolchains.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.driver.Driver;
import org.clang.driver.Tool;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clang.driver.toolchains.impl.Generic_GCC;
import org.clang.driver.toolchains.impl.Linux;
import org.clang.driver.tools.impl.HexagonStatics;
import org.clank.java.std;
import org.clank.java.stdimpl.aliases.StdVectorString;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.NativeType;
import org.clank.support.aliases.char;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.NoneType;
import org.llvm.adt.StringRef;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImpl;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm;

public class HexagonToolChain
extends Linux
implements Destructors.ClassWithDestructor {
    protected Generic_GCC.GCCVersion GCCLibAndIncVersion = new Generic_GCC.GCCVersion();

    @Override
    protected Tool buildAssembler() {
        return new HexagonStatics.Assembler(this);
    }

    @Override
    protected Tool buildLinker() {
        return new HexagonStatics.Linker(this);
    }

    public HexagonToolChain(Driver D, Triple Triple2, ArgList Args) {
        super(D, Triple2, Args);
        std.string TargetDir = this.getHexagonTargetDir(new std.string(D.getInstalledDir()), (SmallVectorImpl<std.string>)D.PrefixDirs);
        std.string BinDir = std.$add_string$C_T((std.string)TargetDir, (String)"/bin");
        if (D.getVFS().exists(new Twine(BinDir))) {
            this.getProgramPaths().push_back((Object)BinDir);
        }
        SmallVector<std.string> LibPaths = this.getFilePaths();
        LibPaths.clear();
        this.getHexagonLibraryPaths(Args, LibPaths);
    }

    @Override
    public void $destroy() {
        this.GCCLibAndIncVersion.$destroy();
        super.$destroy();
    }

    @Override
    public void AddClangSystemIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue()))) {
            return;
        }
        Driver D = this.getDriver();
        std.string TargetDir = this.getHexagonTargetDir(new std.string(D.getInstalledDir()), (SmallVectorImpl<std.string>)D.PrefixDirs);
        HexagonToolChain.addExternCSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)TargetDir, (String)"/hexagon/include")));
    }

    @Override
    public void AddClangCXXStdlibIncludeArgs(ArgList DriverArgs, ArgStringList CC1Args) {
        if (DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdlibinc.getValue())) || DriverArgs.hasArg(new OptSpecifier(options.ID.OPT_nostdincxx.getValue()))) {
            return;
        }
        Driver D = this.getDriver();
        std.string TargetDir = this.getHexagonTargetDir(D.InstalledDir, (SmallVectorImpl<std.string>)D.PrefixDirs);
        HexagonToolChain.addSystemInclude(DriverArgs, CC1Args, new Twine(std.$add_string$C_T((std.string)TargetDir, (String)"/hexagon/include/c++")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ToolChain.CXXStdlibType GetCXXStdlibType(ArgList Args) {
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_stdlib_EQ.getValue()));
        if (A == null) {
            return ToolChain.CXXStdlibType.CST_Libstdcxx;
        }
        StringRef Value = new StringRef(A.getValue());
        if (llvm.$noteq_StringRef((StringRef)Value, (String)"libstdc++")) {
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)this.getDriver().Diag(335))), (StringRef)new StringRef(A.getAsString(Args))));
            }
            finally {
                $c$.$destroy();
            }
        }
        return ToolChain.CXXStdlibType.CST_Libstdcxx;
    }

    public StringRef GetGCCLibAndIncVersion() {
        return new StringRef(this.GCCLibAndIncVersion.Text);
    }

    @Override
    public boolean IsIntegratedAssemblerDefault() {
        return true;
    }

    public std.string getHexagonTargetDir(std.string InstalledDir, SmallVectorImpl<std.string> PrefixDirs) {
        std.string InstallRelDir = new std.string();
        Driver D = this.getDriver();
        for (std.string I : PrefixDirs) {
            if (!D.getVFS().exists(new Twine(I))) continue;
            return new std.string(I);
        }
        if (this.getVFS().exists(new Twine(InstallRelDir.$assignMove(std.$add_string$C_T((std.string)InstalledDir, (String)"/../target"))))) {
            return InstallRelDir;
        }
        return InstallRelDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getHexagonLibraryPaths(ArgList Args, SmallVector<std.string> LibPaths) {
        std.vectorString RootDirs = null;
        try {
            Driver D = this.getDriver();
            for (Arg A : Args.filtered(new OptSpecifier(options.ID.OPT_L.getValue()))) {
                for (char.ptr Value : A.getValues()) {
                    LibPaths.push_back((Object)new std.string(Value));
                }
            }
            RootDirs = new std.vectorString(std.string.EMPTY);
            std.copy((type.iterator)D.PrefixDirs.begin(), (type.iterator)D.PrefixDirs.end(), (std.back_insert_iterator)std.back_inserter((Object)RootDirs));
            std.string TargetDir = this.getHexagonTargetDir(new std.string(D.getInstalledDir()), (SmallVectorImpl<std.string>)D.PrefixDirs);
            if (std.$eq___normal_iterator$C((StdVectorString.iterator)((StdVectorString.iterator)std.find((type.iterator)RootDirs.begin(), (type.iterator)RootDirs.end(), (Object)TargetDir)), (StdVectorString.iterator)RootDirs.end())) {
                RootDirs.push_back(TargetDir);
            }
            boolean HasPIC = Args.hasArg(new OptSpecifier(options.ID.OPT_fpic.getValue()), new OptSpecifier(options.ID.OPT_fPIC.getValue()));
            boolean HasG0 = Args.hasArg(new OptSpecifier(options.ID.OPT_shared.getValue()));
            ADTAliases.OptionalUInt G = HexagonToolChain.getSmallDataThreshold(Args);
            if (G.$bool()) {
                HasG0 = G.getValue() == 0;
            }
            std.string CpuVer = HexagonToolChain.GetTargetCPUVersion(Args).str();
            for (std.string Dir : RootDirs) {
                std.string LibDir = std.$add_string$C_T((std.string)Dir, (String)"/hexagon/lib");
                std.string LibDirCpu = std.$add_string_string$C((std.string)std.$add_string$C_T((std.string)LibDir, (byte)47), (std.string)CpuVer);
                if (HasG0) {
                    if (HasPIC) {
                        LibPaths.push_back((Object)std.$add_string$C_T((std.string)LibDirCpu, (String)"/G0/pic"));
                    }
                    LibPaths.push_back((Object)std.$add_string$C_T((std.string)LibDirCpu, (String)"/G0"));
                }
                LibPaths.push_back((Object)LibDirCpu);
                LibPaths.push_back((Object)LibDir);
            }
        }
        finally {
            if (RootDirs != null) {
                RootDirs.$destroy();
            }
        }
    }

    public static StringRef GetDefaultCPU() {
        return new StringRef("hexagonv60");
    }

    public static StringRef GetTargetCPUVersion(ArgList Args) {
        StringRef CPU;
        Arg CpuArg = null;
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_mcpu_EQ.getValue()), new OptSpecifier(options.ID.OPT_march_EQ.getValue()));
        if (A != null) {
            CpuArg = A;
        }
        StringRef stringRef = CPU = CpuArg != null ? new StringRef(CpuArg.getValue()) : HexagonToolChain.GetDefaultCPU();
        if (CPU.startswith("hexagon")) {
            return CPU.substr(NativeType.sizeof$str((String)"hexagon") - 1);
        }
        return CPU;
    }

    public static ADTAliases.OptionalUInt getSmallDataThreshold(ArgList Args) {
        StringRef Gn = new StringRef(NativePointer.$EMPTY);
        Arg A = Args.getLastArg(new OptSpecifier(options.ID.OPT_G.getValue()), new OptSpecifier(options.ID.OPT_G_EQ.getValue()), new OptSpecifier(options.ID.OPT_msmall_data_threshold_EQ.getValue()));
        if (A != null) {
            Gn.$assignMove(A.getValue());
        } else if (Args.getLastArg(new OptSpecifier(options.ID.OPT_shared.getValue()), new OptSpecifier(options.ID.OPT_fpic.getValue()), new OptSpecifier(options.ID.OPT_fPIC.getValue())) != null) {
            Gn.$assignMove(NativePointer.$0);
        }
        uint.ref G = NativePointer.create_uint$ref();
        if (!Gn.getAsInteger$NotSigned(10, G)) {
            return new ADTAliases.OptionalUInt(G.$deref());
        }
        return new ADTAliases.OptionalUInt(NoneType.None);
    }

    @Override
    public String toString() {
        return "GCCLibAndIncVersion=" + this.GCCLibAndIncVersion + super.toString();
    }
}

