/*
 * Decompiled with CFR 0.152.
 */
package org.clang.driver.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.SanitizerKind;
import org.clang.basic.SanitizerSet;
import org.clang.driver.Driver;
import org.clang.driver.ToolChain;
import org.clang.driver.options;
import org.clank.java.std;
import org.clank.support.JavaCleaner;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.char;
import org.llvm.adt.ADTAliases;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.StringSwitchInt;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;
import org.llvm.option.Arg;
import org.llvm.option.ArgList;
import org.llvm.option.ArgStringList;
import org.llvm.option.OptSpecifier;
import org.llvm.support.llvm_unreachable;
import org.llvm.support.sys.path;

public final class SanitizerArgsStatics {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseArgValues(Driver D, Arg A, boolean DiagnoseErrors) {
        assert (A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_EQ.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_recover_EQ.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_recover_EQ.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_trap_EQ.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_trap_EQ.getValue()))) : "Invalid argument in parseArgValues!";
        long Kinds = 0L;
        int n = A.getNumValues();
        for (int i = 0; i != n; ++i) {
            char.ptr Value = Native.$tryClone((char.ptr)A.getValue(i));
            long Kind2 = A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue())) && 0 == std.strcmp((CharSequence)"all", (char.ptr)Value) ? 0L : (A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue())) && 0 == std.strcmp((CharSequence)"efficiency-all", (char.ptr)Value) ? 0L : BasicClangGlobals.parseSanitizerValue((StringRef)new StringRef(Value), (boolean)true));
            if (Kind2 != 0L) {
                Kinds |= Kind2;
                continue;
            }
            if (!DiagnoseErrors) continue;
            JavaCleaner $c$ = Native.$createJavaCleaner();
            try {
                $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(366))), (StringRef)A.getOption().getName()), (char.ptr)Value));
                continue;
            }
            finally {
                $c$.$destroy();
            }
        }
        return Kinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int parseCoverageFeatures(Driver D, Arg A) {
        assert (A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_coverage.getValue())) || A.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_coverage.getValue())));
        int Features = 0;
        int n = A.getNumValues();
        for (int i = 0; i != n; ++i) {
            char.ptr Value = Native.$tryClone((char.ptr)A.getValue(i));
            int F = new StringSwitchInt(Value).Case("func", 1).Case("bb", 2).Case("edge", 4).Case("indirect-calls", 8).Case("trace-bb", 16).Case("trace-cmp", 32).Case("8bit-counters", 64).Case("trace-pc", 128).Default(0);
            if (F == 0) {
                JavaCleaner $c$ = Native.$createJavaCleaner();
                try {
                    $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(366))), (StringRef)A.getOption().getName()), (char.ptr)Value));
                }
                finally {
                    $c$.$destroy();
                }
            }
            Features |= F;
        }
        return Features;
    }

    public static std.string lastArgumentForMask(Driver D, ArgList Args, long Mask) {
        std.reverse_iterator I = Args.rbegin();
        std.reverse_iterator E = Args.rend();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            Arg Arg2 = (Arg)I.$star();
            if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue()))) {
                long AddKinds = BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.parseArgValues(D, Arg2, false));
                if ((AddKinds & Mask) != 0L) {
                    return SanitizerArgsStatics.describeSanitizeArg(Arg2, Mask);
                }
            } else if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_EQ.getValue()))) {
                long RemoveKinds = BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.parseArgValues(D, Arg2, false));
                Mask &= RemoveKinds ^ 0xFFFFFFFFFFFFFFFFL;
            }
            I.$preInc();
        }
        throw new llvm_unreachable("arg list didn't provide expected value");
    }

    public static std.string describeSanitizeArg(Arg A, long Mask) {
        assert (A.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_EQ.getValue()))) : "Invalid argument in describeSanitizerArg!";
        std.string Sanitizers = new std.string();
        int n = A.getNumValues();
        for (int i = 0; i != n; ++i) {
            if ((BasicClangGlobals.expandSanitizerGroups((long)BasicClangGlobals.parseSanitizerValue((StringRef)new StringRef(A.getValue(i)), (boolean)true)) & Mask) == 0L) continue;
            if (!Sanitizers.empty()) {
                Sanitizers.$addassign((CharSequence)",");
            }
            Sanitizers.$addassign(A.getValue(i));
        }
        assert (!Sanitizers.empty()) : "arg didn't provide expected value";
        return std.$add_T_string$C((String)"-fsanitize=", (std.string)Sanitizers);
    }

    public static std.string __toString(SanitizerSet Sanitizers) {
        std.string Res = new std.string();
        if (Sanitizers.has(SanitizerKind.Address)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"address");
        }
        if (Sanitizers.has(SanitizerKind.KernelAddress)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"kernel-address");
        }
        if (Sanitizers.has(SanitizerKind.Memory)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"memory");
        }
        if (Sanitizers.has(SanitizerKind.Thread)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"thread");
        }
        if (Sanitizers.has(SanitizerKind.Leak)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"leak");
        }
        if (Sanitizers.has(SanitizerKind.Alignment)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"alignment");
        }
        if (Sanitizers.has(SanitizerKind.ArrayBounds)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"array-bounds");
        }
        if (Sanitizers.has(SanitizerKind.Bool)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"bool");
        }
        if (Sanitizers.has(SanitizerKind.Enum)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"enum");
        }
        if (Sanitizers.has(SanitizerKind.FloatCastOverflow)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"float-cast-overflow");
        }
        if (Sanitizers.has(SanitizerKind.FloatDivideByZero)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"float-divide-by-zero");
        }
        if (Sanitizers.has(SanitizerKind.Function)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"function");
        }
        if (Sanitizers.has(SanitizerKind.IntegerDivideByZero)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"integer-divide-by-zero");
        }
        if (Sanitizers.has(SanitizerKind.NonnullAttribute)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"nonnull-attribute");
        }
        if (Sanitizers.has(SanitizerKind.Null)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"null");
        }
        if (Sanitizers.has(SanitizerKind.ObjectSize)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"object-size");
        }
        if (Sanitizers.has(SanitizerKind.Return)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"return");
        }
        if (Sanitizers.has(SanitizerKind.ReturnsNonnullAttribute)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"returns-nonnull-attribute");
        }
        if (Sanitizers.has(SanitizerKind.ShiftBase)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"shift-base");
        }
        if (Sanitizers.has(SanitizerKind.ShiftExponent)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"shift-exponent");
        }
        if (Sanitizers.has(SanitizerKind.SignedIntegerOverflow)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"signed-integer-overflow");
        }
        if (Sanitizers.has(SanitizerKind.Unreachable)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"unreachable");
        }
        if (Sanitizers.has(SanitizerKind.VLABound)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"vla-bound");
        }
        if (Sanitizers.has(SanitizerKind.Vptr)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"vptr");
        }
        if (Sanitizers.has(SanitizerKind.UnsignedIntegerOverflow)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"unsigned-integer-overflow");
        }
        if (Sanitizers.has(SanitizerKind.DataFlow)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"dataflow");
        }
        if (Sanitizers.has(SanitizerKind.CFICastStrict)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-cast-strict");
        }
        if (Sanitizers.has(SanitizerKind.CFIDerivedCast)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-derived-cast");
        }
        if (Sanitizers.has(SanitizerKind.CFIICall)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-icall");
        }
        if (Sanitizers.has(SanitizerKind.CFIUnrelatedCast)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-unrelated-cast");
        }
        if (Sanitizers.has(SanitizerKind.CFINVCall)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-nvcall");
        }
        if (Sanitizers.has(SanitizerKind.CFIVCall)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"cfi-vcall");
        }
        if (Sanitizers.has(SanitizerKind.SafeStack)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"safe-stack");
        }
        if (Sanitizers.has(SanitizerKind.LocalBounds)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"local-bounds");
        }
        if (Sanitizers.has(SanitizerKind.EfficiencyCacheFrag)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"efficiency-cache-frag");
        }
        if (Sanitizers.has(SanitizerKind.EfficiencyWorkingSet)) {
            if (!Res.empty()) {
                Res.$addassign((CharSequence)",");
            }
            Res.$addassign((CharSequence)"efficiency-working-set");
        }
        return Res;
    }

    public static boolean getDefaultBlacklist(Driver D, long Kinds, std.string BLPath) {
        char.ptr BlacklistFile = null;
        if ((Kinds & SanitizerKind.Address) != 0L) {
            BlacklistFile = Native.$tryClone((char.ptr)NativePointer.$((String)"asan_blacklist.txt"));
        } else if ((Kinds & SanitizerKind.Memory) != 0L) {
            BlacklistFile = Native.$tryClone((char.ptr)NativePointer.$((String)"msan_blacklist.txt"));
        } else if ((Kinds & SanitizerKind.Thread) != 0L) {
            BlacklistFile = Native.$tryClone((char.ptr)NativePointer.$((String)"tsan_blacklist.txt"));
        } else if ((Kinds & SanitizerKind.DataFlow) != 0L) {
            BlacklistFile = Native.$tryClone((char.ptr)NativePointer.$((String)"dfsan_abilist.txt"));
        } else if ((Kinds & SanitizerKind.CFI) != 0L) {
            BlacklistFile = Native.$tryClone((char.ptr)NativePointer.$((String)"cfi_blacklist.txt"));
        }
        if (BlacklistFile != null) {
            SmallString Path = new SmallString(new StringRef(D.ResourceDir), 64);
            path.append((SmallString)Path, (Twine)new Twine(BlacklistFile));
            BLPath.$assignMove(Path.str().$basic_string());
            return true;
        }
        return false;
    }

    public static long setGroupBits(long Kinds) {
        if ((Kinds & SanitizerKind.Shift) != 0L) {
            Kinds |= SanitizerKind.ShiftGroup;
        }
        if ((Kinds & SanitizerKind.CFI) != 0L) {
            Kinds |= SanitizerKind.CFIGroup;
        }
        if ((Kinds & SanitizerKind.Undefined) != 0L) {
            Kinds |= SanitizerKind.UndefinedGroup;
        }
        if ((Kinds & SanitizerKind.UndefinedTrap) != 0L) {
            Kinds |= SanitizerKind.UndefinedTrapGroup;
        }
        if ((Kinds & SanitizerKind.Integer) != 0L) {
            Kinds |= SanitizerKind.IntegerGroup;
        }
        if ((Kinds & SanitizerKind.Bounds) != 0L) {
            Kinds |= SanitizerKind.BoundsGroup;
        }
        if ((Kinds & SanitizerKind.Efficiency) != 0L) {
            Kinds |= SanitizerKind.EfficiencyGroup;
        }
        if ((Kinds & SanitizerKind.All) != 0L) {
            Kinds |= SanitizerKind.AllGroup;
        }
        return Kinds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long parseSanitizeTrapArgs(Driver D, ArgList Args) {
        long TrapRemove = 0L;
        long TrappingKinds = 0L;
        long TrappingSupportedWithGroups = SanitizerArgsStatics.setGroupBits(SanitizerArgs_cpp_Unnamed_enum.TrappingSupported.getValue());
        std.reverse_iterator I = Args.rbegin();
        std.reverse_iterator E = Args.rend();
        while (ADTAliases.$noteq_reverse_iterator$C((abstract_iterator)I, (abstract_iterator)E)) {
            Arg Arg2 = (Arg)I.$star();
            if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_trap_EQ.getValue()))) {
                Arg2.claim();
                long Add = SanitizerArgsStatics.parseArgValues(D, Arg2, true);
                long InvalidValues = (Add &= TrapRemove ^ 0xFFFFFFFFFFFFFFFFL) & (TrappingSupportedWithGroups ^ 0xFFFFFFFFFFFFFFFFL);
                if (InvalidValues != 0L) {
                    JavaCleaner $c$ = Native.$createJavaCleaner();
                    try {
                        SanitizerSet S = new SanitizerSet();
                        S.Mask = InvalidValues;
                        $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)BasicClangGlobals.$out_DiagnosticBuilder_char$ptr$C((DiagnosticBuilder)((DiagnosticBuilder)$c$.track((Object)D.Diag(366))), (String)"-fsanitize-trap"), (StringRef)new StringRef(SanitizerArgsStatics.__toString(S))));
                    }
                    finally {
                        $c$.$destroy();
                    }
                }
                TrappingKinds |= BasicClangGlobals.expandSanitizerGroups((long)Add) & (TrapRemove ^ 0xFFFFFFFFFFFFFFFFL);
            } else if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_trap_EQ.getValue()))) {
                Arg2.claim();
                TrapRemove |= BasicClangGlobals.expandSanitizerGroups((long)SanitizerArgsStatics.parseArgValues(D, Arg2, true));
            } else if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fsanitize_undefined_trap_on_error.getValue()))) {
                Arg2.claim();
                TrappingKinds |= BasicClangGlobals.expandSanitizerGroups((long)(SanitizerKind.UndefinedGroup & (TrapRemove ^ 0xFFFFFFFFFFFFFFFFL))) & (TrapRemove ^ 0xFFFFFFFFFFFFFFFFL);
            } else if (Arg2.getOption().matches(new OptSpecifier(options.ID.OPT_fno_sanitize_undefined_trap_on_error.getValue()))) {
                Arg2.claim();
                TrapRemove |= BasicClangGlobals.expandSanitizerGroups((long)SanitizerKind.UndefinedGroup);
            }
            I.$preInc();
        }
        return TrappingKinds |= SanitizerArgs_cpp_Unnamed_enum.TrappingDefault.getValue() & (TrapRemove ^ 0xFFFFFFFFFFFFFFFFL);
    }

    public static void addIncludeLinkerOption(ToolChain TC, ArgList Args, ArgStringList CmdArgs, StringRef SymbolName) {
        SmallString LinkerOptionFlag = new SmallString(64);
        LinkerOptionFlag.$assign("--linker-option=/include:");
        if (TC.getTriple().getArch() == Triple.ArchType.x86) {
            LinkerOptionFlag.$addassign((byte)95);
        }
        LinkerOptionFlag.$addassign(SymbolName);
        CmdArgs.push_back((Object)Args.MakeArgString(new Twine(LinkerOptionFlag)));
    }

    public static final class SanitizerArgs_cpp_Unnamed_enum
    extends Enum<SanitizerArgs_cpp_Unnamed_enum>
    implements Native.ComparableLower {
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum NeedsUbsanRt = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Undefined | SanitizerKind.Integer | SanitizerKind.CFI);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum NeedsUbsanCxxRt = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Vptr | SanitizerKind.CFI);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum NotAllowedWithTrap = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Vptr);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum RequiresPIE = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.DataFlow);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum NeedsUnwindTables = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Address | SanitizerKind.Thread | SanitizerKind.Memory | SanitizerKind.DataFlow);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum SupportsCoverage = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Address | SanitizerKind.Memory | SanitizerKind.Leak | SanitizerKind.Undefined | SanitizerKind.Integer | SanitizerKind.DataFlow);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum RecoverableByDefault = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Undefined | SanitizerKind.Integer);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum Unrecoverable = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Unreachable | SanitizerKind.Return);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum LegacyFsanitizeRecoverMask = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Undefined | SanitizerKind.Integer);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum NeedsLTO = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.CFI);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum TrappingSupported = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.Undefined & (SanitizerKind.Vptr ^ 0xFFFFFFFFFFFFFFFFL) | SanitizerKind.UnsignedIntegerOverflow | SanitizerKind.LocalBounds | SanitizerKind.CFI);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum TrappingDefault = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.CFI);
        public static final /* enum */ SanitizerArgs_cpp_Unnamed_enum CFIClasses = new SanitizerArgs_cpp_Unnamed_enum(SanitizerKind.CFIVCall | SanitizerKind.CFINVCall | SanitizerKind.CFIDerivedCast | SanitizerKind.CFIUnrelatedCast);
        private final long value;
        private static final /* synthetic */ SanitizerArgs_cpp_Unnamed_enum[] $VALUES;

        public static SanitizerArgs_cpp_Unnamed_enum[] values() {
            return (SanitizerArgs_cpp_Unnamed_enum[])$VALUES.clone();
        }

        public static SanitizerArgs_cpp_Unnamed_enum valueOf(String name) {
            return Enum.valueOf(SanitizerArgs_cpp_Unnamed_enum.class, name);
        }

        public static SanitizerArgs_cpp_Unnamed_enum valueOf(long val) {
            SanitizerArgs_cpp_Unnamed_enum out = SanitizerArgs_cpp_Unnamed_enum.valueOf((int)val);
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]. Int not capable to keep values?";
            return out;
        }

        public static SanitizerArgs_cpp_Unnamed_enum valueOf(int val) {
            SanitizerArgs_cpp_Unnamed_enum out;
            SanitizerArgs_cpp_Unnamed_enum sanitizerArgs_cpp_Unnamed_enum = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == (long)val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private SanitizerArgs_cpp_Unnamed_enum(long val) {
            this.value = val;
        }

        public long getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_ulong((long)this.value, (long)((SanitizerArgs_cpp_Unnamed_enum)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_ulong((long)this.value, (long)((SanitizerArgs_cpp_Unnamed_enum)((Object)obj)).value);
        }

        static {
            $VALUES = new SanitizerArgs_cpp_Unnamed_enum[]{NeedsUbsanRt, NeedsUbsanCxxRt, NotAllowedWithTrap, RequiresPIE, NeedsUnwindTables, SupportsCoverage, RecoverableByDefault, Unrecoverable, LegacyFsanitizeRecoverMask, NeedsLTO, TrappingSupported, TrappingDefault, CFIClasses};
        }

        private static final class Values {
            private static final SanitizerArgs_cpp_Unnamed_enum[] VALUES;
            private static final SanitizerArgs_cpp_Unnamed_enum[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (SanitizerArgs_cpp_Unnamed_enum kind : SanitizerArgs_cpp_Unnamed_enum.values()) {
                    if (kind.value > (long)max) {
                        max = (int)kind.value;
                    }
                    if (kind.value >= (long)min) continue;
                    min = (int)kind.value;
                }
                _VALUES = new SanitizerArgs_cpp_Unnamed_enum[min < 0 ? 1 - min : 0];
                VALUES = new SanitizerArgs_cpp_Unnamed_enum[max >= 0 ? 1 + max : 0];
                for (SanitizerArgs_cpp_Unnamed_enum kind : SanitizerArgs_cpp_Unnamed_enum.values()) {
                    if (kind.value < 0L) {
                        Values._VALUES[-((int)((SanitizerArgs_cpp_Unnamed_enum)kind).value)] = kind;
                        continue;
                    }
                    Values.VALUES[(int)((SanitizerArgs_cpp_Unnamed_enum)kind).value] = kind;
                }
            }
        }
    }
}

