/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.sendto.action;

import java.awt.event.ActionEvent;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.sendto.config.ConfigureAction;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public final class DynamicMenu
extends JMenu {
    private static final Action validating;
    private static final Action emptyAction;
    private final Object countersLock = new Object();
    private final List<Action> actions = new ArrayList<Action>();
    private int vcount = 0;

    public DynamicMenu(String name) {
        super(name);
        this.add(validating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setEmpty() {
        Object object = this.countersLock;
        synchronized (object) {
            this.actions.clear();
            this.actions.add(emptyAction);
            this.vcount = 0;
            this.refresh();
        }
    }

    private void refresh() {
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    DynamicMenu.this.removeAll();
                    if (DynamicMenu.this.vcount == 0 && DynamicMenu.this.actions.isEmpty()) {
                        DynamicMenu.this.add(emptyAction);
                    } else {
                        for (Action action : DynamicMenu.this.actions) {
                            DynamicMenu.this.add(action);
                        }
                        if (DynamicMenu.this.vcount > 0) {
                            DynamicMenu.this.add(validating);
                        }
                    }
                    DynamicMenu.this.add(new JPopupMenu.Separator());
                    DynamicMenu.this.add(ConfigureAction.getInstance());
                    if (DynamicMenu.this.isPopupMenuVisible()) {
                        DynamicMenu.this.setPopupMenuVisible(false);
                        DynamicMenu.this.setPopupMenuVisible(true);
                    }
                }
            });
        }
        catch (InterruptedException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addDynamicItem(Action action) {
        Object object = this.countersLock;
        synchronized (object) {
            if (!this.actions.contains(action)) {
                this.actions.add(action);
            }
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addValidatingItem() {
        Object object = this.countersLock;
        synchronized (object) {
            ++this.vcount;
            this.refresh();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeValidatingItem() {
        Object object = this.countersLock;
        synchronized (object) {
            --this.vcount;
            this.refresh();
        }
    }

    static {
        emptyAction = new AbstractAction(NbBundle.getMessage(DynamicMenu.class, (String)"EmptyAction.text")){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        validating = new AbstractAction(NbBundle.getMessage(DynamicMenu.class, (String)"ValidatingAction.text"), ImageUtilities.loadImageIcon((String)"org/netbeans/modules/dlight/sendto/resources/wait.png", (boolean)false)){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        };
        emptyAction.setEnabled(false);
        validating.setEnabled(false);
    }
}

