/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.update;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;

public class FileUpdateInfo {
    private static final String KNOWN_ACTIONS = "ADUCG ";
    public static final int ACTION_TYPE_FILE = 1;
    public static final int ACTION_TYPE_PROPERTY = 2;
    public static final int ACTION_ADDED = 4;
    public static final int ACTION_DELETED = 8;
    public static final int ACTION_UPDATED = 16;
    public static final int ACTION_CONFLICTED = 32;
    public static final int ACTION_MERGED = 64;
    public static final int ACTION_CONFLICTED_RESOLVED = 128;
    public static final int ACTION_LOCK_BROKEN = 256;
    private final VCSFileProxy file;
    private final int action;
    private static final Pattern pattern = Pattern.compile("^([ADUCG ])([ADUCG ])([B ])( *)(.+)$");

    FileUpdateInfo(VCSFileProxy file, int action) {
        this.file = file;
        this.action = action;
    }

    public VCSFileProxy getFile() {
        return this.file;
    }

    public int getAction() {
        return this.action;
    }

    public static FileUpdateInfo[] createFromLogMsg(VCSFileProxy root, String log) {
        Matcher m = pattern.matcher(log);
        if (!m.matches()) {
            return null;
        }
        String fileActionValue = m.group(1);
        String propertyActionValue = m.group(2);
        String broken = m.group(3);
        String filePath = m.group(5);
        if (KNOWN_ACTIONS.indexOf(fileActionValue) < 0 || KNOWN_ACTIONS.indexOf(propertyActionValue) < 0) {
            return null;
        }
        FileUpdateInfo[] fui = new FileUpdateInfo[2];
        int fileAction = FileUpdateInfo.parseAction(fileActionValue.charAt(0)) | (broken.equals("B") ? 256 : 0);
        int propertyAction = FileUpdateInfo.parseAction(propertyActionValue.charAt(0));
        VCSFileProxy aFile = VCSFileProxySupport.getResource((VCSFileProxy)root, (String)filePath).normalizeFile();
        fui[0] = fileAction != 0 ? new FileUpdateInfo(aFile, fileAction | 1) : null;
        fui[1] = propertyAction != 0 ? new FileUpdateInfo(aFile, propertyAction | 2) : null;
        return fui;
    }

    private static int parseAction(char actionChar) {
        switch (actionChar) {
            case 'A': {
                return 4;
            }
            case 'D': {
                return 8;
            }
            case 'U': {
                return 16;
            }
            case 'C': {
                return 32;
            }
            case 'G': {
                return 64;
            }
        }
        return 0;
    }
}

