/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.remote.ui.status;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import org.netbeans.modules.remotefs.versioning.api.VCSFileProxySupport;
import org.netbeans.modules.subversion.remote.util.SvnUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.ViewCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class OpenInEditorAction
extends AbstractAction {
    public OpenInEditorAction() {
        super(NbBundle.getBundle(OpenInEditorAction.class).getString("CTL_Synchronize_Popup_OpenInEditor"));
        this.setEnabled(this.isActionEnabled());
    }

    private boolean isActionEnabled() {
        VCSFileProxy[] files;
        for (VCSFileProxy file : files = SvnUtils.getCurrentContext(null).getFiles()) {
            if (!VCSFileProxySupport.canRead((VCSFileProxy)file)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        VCSFileProxy[] files;
        for (VCSFileProxy file : files = SvnUtils.getCurrentContext(null).getFiles()) {
            FileObject fo = file.normalizeFile().toFileObject();
            if (fo == null) continue;
            try {
                this.openDataObjectByCookie(DataObject.find((FileObject)fo));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                // empty catch block
            }
        }
    }

    private boolean openDataObjectByCookie(DataObject dataObject) {
        block3: {
            Node.Cookie cookie;
            Class<EditorCookie.Observable> cookieClass;
            block2: {
                cookieClass = EditorCookie.Observable.class;
                cookie = dataObject.getCookie(EditorCookie.Observable.class);
                if (cookie != null) break block2;
                cookieClass = EditorCookie.class;
                cookie = dataObject.getCookie(EditorCookie.class);
                if (cookie != null) break block2;
                cookieClass = OpenCookie.class;
                cookie = dataObject.getCookie(OpenCookie.class);
                if (cookie != null) break block2;
                cookieClass = EditCookie.class;
                cookie = dataObject.getCookie(EditCookie.class);
                if (cookie != null) break block2;
                cookieClass = ViewCookie.class;
                cookie = dataObject.getCookie(ViewCookie.class);
                if (cookie == null) break block3;
            }
            return this.openByCookie(cookie, cookieClass);
        }
        return false;
    }

    private boolean openByCookie(Node.Cookie cookie, Class cookieClass) {
        if (cookieClass == EditorCookie.class || cookieClass == EditorCookie.Observable.class) {
            ((EditorCookie)cookie).open();
        } else if (cookieClass == OpenCookie.class) {
            ((OpenCookie)cookie).open();
        } else if (cookieClass == EditCookie.class) {
            ((EditCookie)cookie).edit();
        } else if (cookieClass == ViewCookie.class) {
            ((ViewCookie)cookie).view();
        } else {
            throw new IllegalArgumentException("Reopen #58766: " + cookieClass);
        }
        return true;
    }
}

