/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic;

import java.util.Iterator;
import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.Diagnostic;
import org.clang.basic.DiagnosticBuilder;
import org.clang.basic.DiagnosticConsumer;
import org.clang.basic.DiagnosticIDs;
import org.clang.basic.DiagnosticMapping;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.FixItHint;
import org.clang.basic.FullSourceLoc;
import org.clang.basic.OverloadsShown;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.basic.StoredDiagnostic;
import org.clang.basic.diag;
import org.clang.basic.impl.DiagnosticIDsStatics;
import org.clang.basic.impl.DiagnosticStatics;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.java.std_ptr;
import org.clank.java.stdimpl.aliases.StdVector;
import org.clank.support.Destructors;
import org.clank.support.JavaCleaner;
import org.clank.support.JavaDifferentiators;
import org.clank.support.Native;
import org.clank.support.NativePointer;
import org.clank.support.Unsigned;
import org.clank.support.aliases.type;
import org.llvm.adt.DenseMapInfoUIntImpl;
import org.llvm.adt.IntrusiveRefCntPtr;
import org.llvm.adt.RefCountedBase;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.DenseMapInfoUInt;
import org.llvm.adt.aliases.DenseMapIteratorUIntType;
import org.llvm.adt.aliases.DenseMapUIntType;
import org.llvm.adt.aliases.SmallVector;
import org.llvm.adt.aliases.SmallVectorImplUInt;
import org.llvm.adt.aliases.SmallVectorUInt;
import org.llvm.adt.iterator_range;

public class DiagnosticsEngine
extends RefCountedBase<DiagnosticsEngine>
implements Destructors.ClassWithDestructor {
    byte AllExtensionsSilenced;
    boolean IgnoreAllWarnings;
    boolean WarningsAsErrors;
    boolean EnableAllWarnings;
    boolean ErrorsAsFatal;
    boolean FatalsAsError;
    boolean SuppressSystemWarnings;
    boolean SuppressAllDiagnostics;
    boolean ElideType;
    boolean PrintTemplateTree;
    boolean ShowColors;
    private OverloadsShown ShowOverloads;
    int ErrorLimit;
    private int TemplateBacktraceLimit;
    private int ConstexprBacktraceLimit;
    diag.Severity ExtBehavior;
    private IntrusiveRefCntPtr<DiagnosticIDs> Diags;
    private IntrusiveRefCntPtr<DiagnosticOptions> DiagOpts;
    DiagnosticConsumer Client;
    private std_ptr.unique_ptr<DiagnosticConsumer> Owner;
    private SourceManager SourceMgr;
    private std.list<DiagState> DiagStates;
    private static final Native.ComparatorLower DiagStatePointComparator = new Native.ComparatorLower<DiagStatePoint, DiagStatePoint>(){

        public boolean $less(DiagStatePoint one, DiagStatePoint other) {
            return one.$less(other);
        }
    };
    private std.vector<DiagStatePoint> DiagStatePoints;
    private std.vector<DiagState> DiagStateOnPushStack;
    boolean ErrorOccurred;
    boolean UncompilableErrorOccurred;
    boolean FatalErrorOccurred;
    boolean UnrecoverableErrorOccurred;
    int TrapNumErrorsOccurred;
    int TrapNumUnrecoverableErrorsOccurred;
    DiagnosticIDs.Level LastDiagLevel;
    int NumWarnings;
    int NumErrors;
    private Object ArgToStringCookie;
    private ArgToStringFn ArgToStringFn;
    private static final ArgToStringFn DummyArgToStringFn = new ArgToStringFn(){

        @Override
        public void $call(ArgumentKind Kind2, Object Val, StringRef Modifier, StringRef Argument, ArrayRef<std_pair.pair<ArgumentKind, ?>> PrevArgs, SmallString Output, Object Cookie, ArrayRef<Object> QualTypeVals) {
            DiagnosticStatics.DummyArgToStringFn(Kind2, Val, Modifier, Argument, PrevArgs, Output, Cookie, QualTypeVals);
        }
    };
    private int DelayedDiagID;
    private std.string DelayedDiagArg1;
    private std.string DelayedDiagArg2;
    std.string FlagValue;
    SourceLocation CurDiagLoc;
    int CurDiagID;
    public static final int MaxArguments = 10;
    byte NumDiagArgs;
    ArgumentKind[] DiagArgumentsKind = new ArgumentKind[10];
    std.string[] DiagArgumentsStr = new std.string[10];
    Object[] DiagArgumentsVal = new Object[10];
    SmallVector<CharSourceRange> DiagRanges;
    SmallVector<FixItHint> DiagFixItHints;

    private DiagnosticsEngine(DiagnosticsEngine $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private void $assign(DiagnosticsEngine $Prm0) {
        throw new UnsupportedOperationException("Deleted");
    }

    private DiagState GetCurDiagState() {
        assert (!this.DiagStatePoints.empty());
        return ((DiagStatePoint)this.DiagStatePoints.back()).State;
    }

    private void PushDiagStatePoint(DiagState State, SourceLocation L) {
        FullSourceLoc Loc = new FullSourceLoc(L, this.getSourceManager());
        assert (Loc.isValid()) : "Adding invalid loc point";
        assert (!this.DiagStatePoints.empty() && (((DiagStatePoint)this.DiagStatePoints.back()).Loc.isInvalid() || ((DiagStatePoint)this.DiagStatePoints.back()).Loc.isBeforeInTranslationUnitThan(Loc))) : "Previous point loc comes after or is the same as new one";
        this.DiagStatePoints.push_back((Object)new DiagStatePoint(State, Loc));
    }

    DiagStatePoint GetDiagStatePointForLoc(SourceLocation L) {
        assert (!this.DiagStatePoints.empty());
        return (DiagStatePoint)this.DiagStatePoints.$at(this.GetDiagStatePointForLocIndex(L));
    }

    int GetDiagStatePointForLocIndex(SourceLocation L) {
        assert (!this.DiagStatePoints.empty());
        assert (((DiagStatePoint)this.DiagStatePoints.front()).Loc.isInvalid()) : "Should have created a DiagStatePoint for command-line";
        if (this.SourceMgr == null) {
            return this.DiagStatePoints.size() - 1;
        }
        FullSourceLoc Loc = new FullSourceLoc(L, this.SourceMgr);
        if (Loc.isInvalid()) {
            return this.DiagStatePoints.size() - 1;
        }
        int Pos = this.DiagStatePoints.size();
        FullSourceLoc LastStateChangePos = new FullSourceLoc(((DiagStatePoint)this.DiagStatePoints.back()).Loc);
        if (LastStateChangePos.isValid() && Loc.isBeforeInTranslationUnitThan(LastStateChangePos)) {
            Pos = ((StdVector.iterator)std.upper_bound((type.iterator)this.DiagStatePoints.begin(), (type.iterator)this.DiagStatePoints.end(), (Object)new DiagStatePoint((DiagState)null, Loc), (Native.ComparatorLower)DiagStatePointComparator)).$index();
        }
        return --Pos;
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts) {
        this(diags, DiagOpts, null, true);
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts, DiagnosticConsumer client) {
        this(diags, DiagOpts, client, true);
    }

    public DiagnosticsEngine(IntrusiveRefCntPtr<DiagnosticIDs> diags, DiagnosticOptions DiagOpts, DiagnosticConsumer client, boolean ShouldOwnClient) {
        this.Diags = new IntrusiveRefCntPtr(diags);
        this.DiagOpts = new IntrusiveRefCntPtr((Object)DiagOpts);
        this.Client = null;
        this.Owner = new std_ptr.unique_ptr();
        this.SourceMgr = null;
        this.DiagStates = new std.list((Object)new DiagState());
        this.DiagStatePoints = new std.vector((Object)new DiagStatePoint());
        this.DiagStateOnPushStack = new std.vector((Object)null);
        this.DelayedDiagArg1 = new std.string();
        this.DelayedDiagArg2 = new std.string();
        this.FlagValue = new std.string();
        this.CurDiagLoc = new SourceLocation();
        this.DiagArgumentsStr = (std.string[])NativePointer.new$T((Object[])new std.string[10], () -> new std.string());
        this.DiagRanges = new SmallVector(8, (Object)new CharSourceRange());
        this.DiagFixItHints = new SmallVector(8, (Object)new FixItHint());
        this.setClient(client, ShouldOwnClient);
        this.ArgToStringFn = DummyArgToStringFn;
        this.ArgToStringCookie = null;
        this.AllExtensionsSilenced = 0;
        this.IgnoreAllWarnings = false;
        this.WarningsAsErrors = false;
        this.EnableAllWarnings = false;
        this.ErrorsAsFatal = false;
        this.FatalsAsError = false;
        this.SuppressSystemWarnings = false;
        this.SuppressAllDiagnostics = false;
        this.ElideType = true;
        this.PrintTemplateTree = false;
        this.ShowColors = false;
        this.ShowOverloads = OverloadsShown.Ovl_All;
        this.ExtBehavior = diag.Severity.Ignored;
        this.ErrorLimit = 0;
        this.TemplateBacktraceLimit = 0;
        this.ConstexprBacktraceLimit = 0;
        this.Reset();
    }

    public void $destroy() {
        this.setClient(null);
        this.DiagFixItHints.$destroy();
        this.DiagRanges.$destroy();
        this.FlagValue.$destroy();
        this.DelayedDiagArg2.$destroy();
        this.DelayedDiagArg1.$destroy();
        this.DiagStateOnPushStack.$destroy();
        this.DiagStatePoints.$destroy();
        this.DiagStates.$destroy();
        this.Owner.$destroy();
        this.DiagOpts.$destroy();
        this.Diags.$destroy();
        super.$destroy();
    }

    public IntrusiveRefCntPtr<DiagnosticIDs> getDiagnosticIDs() {
        return this.Diags;
    }

    public DiagnosticOptions getDiagnosticOptions() {
        return (DiagnosticOptions)((Object)this.DiagOpts.$star());
    }

    public iterator_range<std_pair.pairUIntType<DiagnosticMapping>> getDiagnosticMappings() {
        DiagState DS = this.GetCurDiagState();
        return new iterator_range(DS.begin(), DS.end());
    }

    public DiagnosticConsumer getClient() {
        return this.Client;
    }

    public boolean ownsClient() {
        return std.$noteq_unique_ptr$C_nullptr_t(this.Owner, null);
    }

    public std_ptr.unique_ptr<DiagnosticConsumer> takeClient() {
        return new std_ptr.unique_ptr(JavaDifferentiators.JD.Move.INSTANCE, std.move(this.Owner));
    }

    public boolean hasSourceManager() {
        return this.SourceMgr != null;
    }

    public SourceManager getSourceManager() {
        assert (this.SourceMgr != null) : "SourceManager not set!";
        return this.SourceMgr;
    }

    public void setSourceManager(SourceManager SrcMgr2) {
        this.SourceMgr = SrcMgr2;
    }

    public void pushMappings(SourceLocation Loc) {
        this.DiagStateOnPushStack.push_back((Object)this.GetCurDiagState());
    }

    public boolean popMappings(SourceLocation Loc) {
        if (this.DiagStateOnPushStack.empty()) {
            return false;
        }
        if (this.DiagStateOnPushStack.back() != this.GetCurDiagState()) {
            this.PushDiagStatePoint((DiagState)this.DiagStateOnPushStack.back(), Loc);
        }
        this.DiagStateOnPushStack.pop_back();
        return true;
    }

    public void setClient(DiagnosticConsumer client) {
        this.setClient(client, true);
    }

    public void setClient(DiagnosticConsumer client, boolean ShouldOwnClient) {
        this.Owner.reset((Object)(ShouldOwnClient ? client : (DiagnosticConsumer)null));
        this.Client = client;
    }

    public void setErrorLimit(int Limit) {
        this.ErrorLimit = Limit;
    }

    public void setTemplateBacktraceLimit(int Limit) {
        this.TemplateBacktraceLimit = Limit;
    }

    public int getTemplateBacktraceLimit() {
        return this.TemplateBacktraceLimit;
    }

    public void setConstexprBacktraceLimit(int Limit) {
        this.ConstexprBacktraceLimit = Limit;
    }

    public int getConstexprBacktraceLimit() {
        return this.ConstexprBacktraceLimit;
    }

    public void setIgnoreAllWarnings(boolean Val) {
        this.IgnoreAllWarnings = Val;
    }

    public boolean getIgnoreAllWarnings() {
        return this.IgnoreAllWarnings;
    }

    public void setEnableAllWarnings(boolean Val) {
        this.EnableAllWarnings = Val;
    }

    public boolean getEnableAllWarnings() {
        return this.EnableAllWarnings;
    }

    public void setWarningsAsErrors(boolean Val) {
        this.WarningsAsErrors = Val;
    }

    public boolean getWarningsAsErrors() {
        return this.WarningsAsErrors;
    }

    public void setErrorsAsFatal(boolean Val) {
        this.ErrorsAsFatal = Val;
    }

    public boolean getErrorsAsFatal() {
        return this.ErrorsAsFatal;
    }

    public void setFatalsAsError(boolean Val) {
        this.FatalsAsError = Val;
    }

    public boolean getFatalsAsError() {
        return this.FatalsAsError;
    }

    public void setSuppressSystemWarnings(boolean Val) {
        this.SuppressSystemWarnings = Val;
    }

    public boolean getSuppressSystemWarnings() {
        return this.SuppressSystemWarnings;
    }

    public void setSuppressAllDiagnostics() {
        this.setSuppressAllDiagnostics(true);
    }

    public void setSuppressAllDiagnostics(boolean Val) {
        this.SuppressAllDiagnostics = Val;
    }

    public boolean getSuppressAllDiagnostics() {
        return this.SuppressAllDiagnostics;
    }

    public void setElideType() {
        this.setElideType(true);
    }

    public void setElideType(boolean Val) {
        this.ElideType = Val;
    }

    public boolean getElideType() {
        return this.ElideType;
    }

    public void setPrintTemplateTree() {
        this.setPrintTemplateTree(false);
    }

    public void setPrintTemplateTree(boolean Val) {
        this.PrintTemplateTree = Val;
    }

    public boolean getPrintTemplateTree() {
        return this.PrintTemplateTree;
    }

    public void setShowColors() {
        this.setShowColors(false);
    }

    public void setShowColors(boolean Val) {
        this.ShowColors = Val;
    }

    public boolean getShowColors() {
        return this.ShowColors;
    }

    public void setShowOverloads(OverloadsShown Val) {
        this.ShowOverloads = Val;
    }

    public OverloadsShown getShowOverloads() {
        return this.ShowOverloads;
    }

    public void setLastDiagnosticIgnored() {
        if (this.LastDiagLevel == DiagnosticIDs.Level.Fatal) {
            this.FatalErrorOccurred = true;
        }
        this.LastDiagLevel = DiagnosticIDs.Level.Ignored;
    }

    public boolean isLastDiagnosticIgnored() {
        return this.LastDiagLevel == DiagnosticIDs.Level.Ignored;
    }

    public void setExtensionHandlingBehavior(diag.Severity H) {
        this.ExtBehavior = H;
    }

    public diag.Severity getExtensionHandlingBehavior() {
        return this.ExtBehavior;
    }

    public void IncrementAllExtensionsSilenced() {
        this.AllExtensionsSilenced = (byte)(this.AllExtensionsSilenced + 1);
    }

    public void DecrementAllExtensionsSilenced() {
        this.AllExtensionsSilenced = (byte)(this.AllExtensionsSilenced - 1);
    }

    public boolean hasAllExtensionsSilenced() {
        return Unsigned.$uchar2int((byte)this.AllExtensionsSilenced) != 0;
    }

    public void setSeverity(int Diag, diag.Severity Map2, SourceLocation L) {
        DiagnosticMapping Info2;
        assert (Unsigned.$less_uint((int)Diag, (int)5330)) : "Can only map builtin diagnostics";
        if (!$assertionsDisabled) {
            DiagnosticIDs cfr_ignored_0 = (DiagnosticIDs)((Object)this.Diags.$arrow());
            if (!DiagnosticIDs.isBuiltinWarningOrExtension(Diag) && Map2 != diag.Severity.Fatal && Map2 != diag.Severity.Error) {
                throw new AssertionError((Object)"Cannot map errors into warnings!");
            }
        }
        assert (!this.DiagStatePoints.empty());
        assert (L.isInvalid() || this.SourceMgr != null) : "No SourceMgr for valid location";
        FullSourceLoc Loc = this.SourceMgr != null ? new FullSourceLoc(L, this.SourceMgr) : new FullSourceLoc();
        FullSourceLoc LastStateChangePos = new FullSourceLoc(((DiagStatePoint)this.DiagStatePoints.back()).Loc);
        if (Map2 == diag.Severity.Warning && ((Info2 = this.GetCurDiagState().getOrAddMapping(Diag)).getSeverity() == diag.Severity.Error || Info2.getSeverity() == diag.Severity.Fatal)) {
            Map2 = Info2.getSeverity();
        }
        DiagnosticMapping Mapping = this.makeUserMapping(Map2, L);
        if (Loc.isInvalid() || FullSourceLoc.$eq_FullSourceLoc(Loc, LastStateChangePos)) {
            this.GetCurDiagState().setMapping(Diag, new DiagnosticMapping(Mapping));
            return;
        }
        if (Loc.isValid() && LastStateChangePos.isInvalid() || LastStateChangePos.isBeforeInTranslationUnitThan(Loc)) {
            this.DiagStates.push_back((Object)this.GetCurDiagState());
            this.PushDiagStatePoint((DiagState)this.DiagStates.back(), Loc);
            this.GetCurDiagState().setMapping(Diag, new DiagnosticMapping(Mapping));
            return;
        }
        int $Pos = this.GetDiagStatePointForLocIndex(Loc);
        assert ($Pos != this.DiagStatePoints.size());
        DiagStatePoint $at$Pos = (DiagStatePoint)this.DiagStatePoints.$at($Pos);
        int E = this.DiagStatePoints.size();
        for (int I = $Pos + 1; I != E; ++I) {
            ((DiagStatePoint)this.DiagStatePoints.$at((int)I)).State.setMapping(Diag, new DiagnosticMapping(Mapping));
        }
        if (FullSourceLoc.$eq_FullSourceLoc($at$Pos.Loc, Loc)) {
            $at$Pos.State.setMapping(Diag, new DiagnosticMapping(Mapping));
            return;
        }
        assert ($at$Pos.Loc.isBeforeInTranslationUnitThan(Loc));
        this.DiagStates.push_back((Object)$at$Pos.State);
        DiagState NewState = (DiagState)this.DiagStates.back();
        NewState.setMapping(Diag, new DiagnosticMapping(Mapping));
        StdVector.iterator Pos$Add$1 = this.DiagStatePoints.begin().$add($Pos + 1);
        this.DiagStatePoints.insert(Pos$Add$1, (Object)new DiagStatePoint(NewState, new FullSourceLoc(Loc, this.SourceMgr)));
    }

    public boolean setSeverityForGroup(diag.Flavor Flavor2, StringRef Group, diag.Severity Map2) {
        return this.setSeverityForGroup(Flavor2, Group, Map2, new SourceLocation());
    }

    public boolean setSeverityForGroup(diag.Flavor Flavor2, StringRef Group, diag.Severity Map2, SourceLocation Loc) {
        SmallVectorUInt GroupDiags = new SmallVectorUInt(256, 0);
        if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(Flavor2, Group, (SmallVectorImplUInt)GroupDiags)) {
            return true;
        }
        Iterator iterator2 = GroupDiags.iterator();
        while (iterator2.hasNext()) {
            int Diag = (Integer)iterator2.next();
            this.setSeverity(Diag, Map2, Loc);
        }
        return false;
    }

    public boolean setDiagnosticGroupWarningAsError(StringRef Group, boolean Enabled) {
        if (Enabled) {
            return this.setSeverityForGroup(diag.Flavor.WarningOrError, Group, diag.Severity.Error);
        }
        SmallVectorUInt GroupDiags = new SmallVectorUInt(8, 0);
        if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(diag.Flavor.WarningOrError, Group, (SmallVectorImplUInt)GroupDiags)) {
            return true;
        }
        Iterator iterator2 = GroupDiags.iterator();
        while (iterator2.hasNext()) {
            int Diag = (Integer)iterator2.next();
            DiagnosticMapping Info2 = this.GetCurDiagState().getOrAddMapping(Diag);
            if (Info2.getSeverity() == diag.Severity.Error || Info2.getSeverity() == diag.Severity.Fatal) {
                Info2.setSeverity(diag.Severity.Warning);
            }
            Info2.setNoWarningAsError(true);
        }
        return false;
    }

    public boolean setDiagnosticGroupErrorAsFatal(StringRef Group, boolean Enabled) {
        if (Enabled) {
            return this.setSeverityForGroup(diag.Flavor.WarningOrError, Group, diag.Severity.Fatal);
        }
        SmallVectorUInt GroupDiags = new SmallVectorUInt(8, 0);
        if (((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticsInGroup(diag.Flavor.WarningOrError, Group, (SmallVectorImplUInt)GroupDiags)) {
            return true;
        }
        Iterator iterator2 = GroupDiags.iterator();
        while (iterator2.hasNext()) {
            int Diag = (Integer)iterator2.next();
            DiagnosticMapping Info2 = this.GetCurDiagState().getOrAddMapping(Diag);
            if (Info2.getSeverity() == diag.Severity.Fatal) {
                Info2.setSeverity(diag.Severity.Error);
            }
            Info2.setNoErrorAsFatal(true);
        }
        return false;
    }

    public void setSeverityForAll(diag.Flavor Flavor2, diag.Severity Map2) {
        this.setSeverityForAll(Flavor2, Map2, new SourceLocation());
    }

    public void setSeverityForAll(diag.Flavor Flavor2, diag.Severity Map2, SourceLocation Loc) {
        SmallVectorUInt AllDiags = new SmallVectorUInt(64, 0);
        ((DiagnosticIDs)((Object)this.Diags.$arrow())).getAllDiagnostics(Flavor2, (SmallVectorImplUInt)AllDiags);
        Iterator iterator2 = AllDiags.iterator();
        while (iterator2.hasNext()) {
            int Diag = (Integer)iterator2.next();
            DiagnosticIDs cfr_ignored_0 = (DiagnosticIDs)((Object)this.Diags.$arrow());
            if (!DiagnosticIDs.isBuiltinWarningOrExtension(Diag)) continue;
            this.setSeverity(Diag, Map2, Loc);
        }
    }

    public boolean hasErrorOccurred() {
        return this.ErrorOccurred;
    }

    public boolean hasUncompilableErrorOccurred() {
        return this.UncompilableErrorOccurred;
    }

    public boolean hasFatalErrorOccurred() {
        return this.FatalErrorOccurred;
    }

    public boolean hasUnrecoverableErrorOccurred() {
        return this.FatalErrorOccurred || this.UnrecoverableErrorOccurred;
    }

    public int getNumWarnings() {
        return this.NumWarnings;
    }

    public void setNumWarnings(int NumWarnings) {
        this.NumWarnings = NumWarnings;
    }

    public int getCustomDiagID(Level L, String FormatString) {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).getCustomDiagID(DiagnosticIDs.Level.valueOf(L.getValue()), new StringRef(FormatString));
    }

    public void ConvertArgToString(ArgumentKind Kind2, Object Val, StringRef Modifier, StringRef Argument, ArrayRef<std_pair.pair<ArgumentKind, ?>> PrevArgs, SmallString Output, ArrayRef<Object> QualTypeVals) {
        this.ArgToStringFn.$call(Kind2, Val, Modifier, Argument, PrevArgs, Output, this.ArgToStringCookie, QualTypeVals);
    }

    public void SetArgToStringFn(ArgToStringFn Fn, Object Cookie) {
        this.ArgToStringFn = (ArgToStringFn)Native.$tryClone((Object)Fn);
        this.ArgToStringCookie = Native.$tryClone((Object)Cookie);
    }

    public void notePriorDiagnosticFrom(DiagnosticsEngine Other) {
        this.LastDiagLevel = Other.LastDiagLevel;
    }

    public void Reset() {
        this.ErrorOccurred = false;
        this.UncompilableErrorOccurred = false;
        this.FatalErrorOccurred = false;
        this.UnrecoverableErrorOccurred = false;
        this.NumWarnings = 0;
        this.NumErrors = 0;
        this.TrapNumErrorsOccurred = 0;
        this.TrapNumUnrecoverableErrorsOccurred = 0;
        this.CurDiagID = -1;
        this.LastDiagLevel = DiagnosticIDs.Level.Ignored;
        this.DelayedDiagID = 0;
        this.DiagStates.clear();
        this.DiagStatePoints.clear();
        this.DiagStateOnPushStack.clear();
        this.DiagStates.emplace_back();
        this.DiagStatePoints.push_back((Object)new DiagStatePoint((DiagState)this.DiagStates.back(), new FullSourceLoc()));
    }

    public boolean isIgnored(int DiagID, SourceLocation Loc) {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticSeverity(DiagID, Loc, this) == diag.Severity.Ignored;
    }

    public boolean isIgnored(int DiagID, int Loc) {
        return this.isIgnored(DiagID, SourceLocation.getFromRawEncoding(Loc));
    }

    public Level getDiagnosticLevel(int DiagID, SourceLocation Loc) {
        return Level.valueOf(((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticLevel(DiagID, Loc, this).getValue());
    }

    public Level getDiagnosticLevel(int DiagID, int Loc) {
        return this.getDiagnosticLevel(DiagID, SourceLocation.getFromRawEncoding(Loc));
    }

    public DiagnosticBuilder Report(SourceLocation Loc, int DiagID) {
        assert (this.CurDiagID == -1) : "Multiple diagnostics in flight at once!";
        this.CurDiagLoc.$assign(Loc);
        this.CurDiagID = DiagID;
        this.FlagValue.clear();
        return new DiagnosticBuilder(this);
    }

    public DiagnosticBuilder Report(int Loc, int DiagID) {
        return this.Report(SourceLocation.getFromRawEncoding(Loc), DiagID);
    }

    public DiagnosticBuilder Report(int DiagID) {
        return this.Report(new SourceLocation(), DiagID);
    }

    public void Report(StoredDiagnostic storedDiag) {
        assert (this.CurDiagID == -1) : "Multiple diagnostics in flight at once!";
        this.CurDiagLoc.$assign(storedDiag.getLocation());
        this.CurDiagID = storedDiag.getID();
        this.NumDiagArgs = 0;
        this.DiagRanges.clear();
        this.DiagRanges.append(storedDiag.range_begin(), storedDiag.range_end());
        this.DiagFixItHints.clear();
        this.DiagFixItHints.append(storedDiag.fixit_begin(), storedDiag.fixit_end());
        assert (this.Client != null) : "DiagnosticConsumer not set!";
        Level DiagLevel = storedDiag.getLevel();
        Diagnostic Info2 = new Diagnostic(this, storedDiag.getMessage());
        this.Client.HandleDiagnostic(DiagLevel, Info2);
        if (this.Client.IncludeInDiagnosticCounts() && DiagLevel == Level.Warning) {
            ++this.NumWarnings;
        }
        this.CurDiagID = -1;
    }

    public boolean isDiagnosticInFlight() {
        return this.CurDiagID != -1;
    }

    public void SetDelayedDiagnostic(int DiagID) {
        this.SetDelayedDiagnostic(DiagID, StringRef.R$EMPTY, StringRef.R$EMPTY);
    }

    public void SetDelayedDiagnostic(int DiagID, StringRef Arg1) {
        this.SetDelayedDiagnostic(DiagID, Arg1, StringRef.R$EMPTY);
    }

    public void SetDelayedDiagnostic(int DiagID, StringRef Arg1, StringRef Arg2) {
        if (this.DelayedDiagID != 0) {
            return;
        }
        this.DelayedDiagID = DiagID;
        this.DelayedDiagArg1.$assignMove(Arg1.str());
        this.DelayedDiagArg2.$assignMove(Arg2.str());
    }

    public void Clear() {
        this.CurDiagID = -1;
    }

    public StringRef getFlagValue() {
        return new StringRef(this.FlagValue);
    }

    private void ReportDelayed() {
        JavaCleaner $c$ = Native.$createJavaCleaner();
        try {
            $c$.clean((Object)BasicClangGlobals.$out_DiagnosticBuilder_StringRef(BasicClangGlobals.$out_DiagnosticBuilder_StringRef((DiagnosticBuilder)$c$.track((Object)this.Report(this.DelayedDiagID)), new StringRef(this.DelayedDiagArg1)), new StringRef(this.DelayedDiagArg2)));
            this.DelayedDiagID = 0;
            this.DelayedDiagArg1.clear();
            this.DelayedDiagArg2.clear();
        }
        finally {
            $c$.$destroy();
        }
    }

    private DiagnosticMapping makeUserMapping(diag.Severity Map2, SourceLocation L) {
        boolean isPragma = L.isValid();
        DiagnosticMapping Mapping = DiagnosticMapping.Make(Map2, true, isPragma);
        if (isPragma) {
            Mapping.setNoWarningAsError(true);
            Mapping.setNoErrorAsFatal(true);
        }
        return Mapping;
    }

    private boolean ProcessDiag() {
        return ((DiagnosticIDs)((Object)this.Diags.$arrow())).ProcessDiag(this);
    }

    protected boolean EmitCurrentDiagnostic() {
        return this.EmitCurrentDiagnostic(false);
    }

    protected boolean EmitCurrentDiagnostic(boolean Force) {
        boolean Emitted;
        assert (this.getClient() != null) : "DiagnosticClient not set!";
        if (Force) {
            Diagnostic Info2 = new Diagnostic(this);
            DiagnosticIDs.Level DiagLevel = ((DiagnosticIDs)((Object)this.Diags.$arrow())).getDiagnosticLevel(Info2.getID(), Info2.getLocation(), this);
            boolean bl = Emitted = DiagLevel != DiagnosticIDs.Level.Ignored;
            if (Emitted) {
                ((DiagnosticIDs)((Object)this.Diags.$arrow())).EmitDiag(this, DiagLevel);
            }
        } else {
            Emitted = this.ProcessDiag();
        }
        int DiagID = this.CurDiagID;
        this.Clear();
        if (!Force && this.DelayedDiagID != 0 && this.DelayedDiagID != DiagID) {
            this.ReportDelayed();
        }
        return Emitted;
    }

    protected int getCurrentDiagID() {
        return this.CurDiagID;
    }

    protected SourceLocation getCurrentDiagLoc() {
        return new SourceLocation(this.CurDiagLoc);
    }

    public String toString() {
        return "AllExtensionsSilenced=" + this.AllExtensionsSilenced + ", IgnoreAllWarnings=" + this.IgnoreAllWarnings + ", WarningsAsErrors=" + this.WarningsAsErrors + ", EnableAllWarnings=" + this.EnableAllWarnings + ", ErrorsAsFatal=" + this.ErrorsAsFatal + ", FatalsAsError=" + this.FatalsAsError + ", SuppressSystemWarnings=" + this.SuppressSystemWarnings + ", SuppressAllDiagnostics=" + this.SuppressAllDiagnostics + ", ElideType=" + this.ElideType + ", PrintTemplateTree=" + this.PrintTemplateTree + ", ShowColors=" + this.ShowColors + ", ShowOverloads=" + (Object)((Object)this.ShowOverloads) + ", ErrorLimit=" + this.ErrorLimit + ", TemplateBacktraceLimit=" + this.TemplateBacktraceLimit + ", ConstexprBacktraceLimit=" + this.ConstexprBacktraceLimit + ", ExtBehavior=" + (Object)((Object)this.ExtBehavior) + ", DiagOpts=" + this.DiagOpts + ", Client=" + this.Client + ", Owner=" + this.Owner + ", DiagStates=" + this.DiagStates + ", DiagStatePoints=" + this.DiagStatePoints + ", DiagStateOnPushStack=" + this.DiagStateOnPushStack + ", ErrorOccurred=" + this.ErrorOccurred + ", UncompilableErrorOccurred=" + this.UncompilableErrorOccurred + ", FatalErrorOccurred=" + this.FatalErrorOccurred + ", UnrecoverableErrorOccurred=" + this.UnrecoverableErrorOccurred + ", TrapNumErrorsOccurred=" + this.TrapNumErrorsOccurred + ", TrapNumUnrecoverableErrorsOccurred=" + this.TrapNumUnrecoverableErrorsOccurred + ", LastDiagLevel=" + (Object)((Object)this.LastDiagLevel) + ", NumWarnings=" + this.NumWarnings + ", NumErrors=" + this.NumErrors + ", ArgToStringCookie=" + this.ArgToStringCookie + ", ArgToStringFn=" + this.ArgToStringFn + ", DelayedDiagID=" + this.DelayedDiagID + ", DelayedDiagArg1=" + this.DelayedDiagArg1 + ", DelayedDiagArg2=" + this.DelayedDiagArg2 + ", FlagValue=" + this.FlagValue + ", CurDiagLoc=" + this.CurDiagLoc + ", CurDiagID=" + this.CurDiagID + ", NumDiagArgs=" + this.NumDiagArgs + ", DiagArgumentsKind=" + this.DiagArgumentsKind + ", DiagArgumentsStr=" + this.DiagArgumentsStr + ", DiagArgumentsVal=" + this.DiagArgumentsVal + ", DiagRanges=" + this.DiagRanges + ", DiagFixItHints=" + this.DiagFixItHints + super.toString();
    }

    public static interface ArgToStringFn {
        public void $call(ArgumentKind var1, Object var2, StringRef var3, StringRef var4, ArrayRef<std_pair.pair<ArgumentKind, ?>> var5, SmallString var6, Object var7, ArrayRef<Object> var8);
    }

    static class DiagStatePoint {
        public DiagState State;
        public FullSourceLoc Loc;

        public DiagStatePoint() {
        }

        public DiagStatePoint(DiagState State, FullSourceLoc Loc) {
            this.State = State;
            this.Loc = new FullSourceLoc(Loc);
        }

        public boolean $less(DiagStatePoint RHS) {
            if (RHS.Loc.isInvalid()) {
                return false;
            }
            if (this.Loc.isInvalid()) {
                return true;
            }
            return this.Loc.isBeforeInTranslationUnitThan(RHS.Loc);
        }

        public DiagStatePoint(JavaDifferentiators.JD.Move _dparam, DiagStatePoint $Prm0) {
            this.State = $Prm0.State;
            this.Loc = new FullSourceLoc(JavaDifferentiators.JD.Move.INSTANCE, $Prm0.Loc);
        }

        public DiagStatePoint $assignMove(DiagStatePoint $Prm0) {
            this.State = $Prm0.State;
            this.Loc.$assignMove($Prm0.Loc);
            return this;
        }

        public String toString() {
            return "State=" + this.State + ", Loc=" + this.Loc;
        }
    }

    static class DiagState
    implements Destructors.ClassWithDestructor {
        private DenseMapUIntType<DiagnosticMapping> DiagMap;

        public void setMapping(int Diag, DiagnosticMapping Info2) {
            ((DiagnosticMapping)this.DiagMap.$at(Diag)).$assign(Info2);
        }

        public DiagnosticMapping getOrAddMapping(int Diag) {
            std_pair.pairTypeBool Result = this.DiagMap.insert(std.make_pair_uint_T((int)Diag, (Object)new DiagnosticMapping()));
            if (Result.second) {
                ((DiagnosticMapping)((DenseMapIteratorUIntType)Result.first).$star().second).$assignMove(DiagnosticIDsStatics.GetDefaultDiagMapping(Diag));
            }
            return (DiagnosticMapping)((DenseMapIteratorUIntType)Result.first).$star().second;
        }

        public DenseMapIteratorUIntType<DiagnosticMapping> begin() {
            return this.DiagMap.begin();
        }

        public DenseMapIteratorUIntType<DiagnosticMapping> end() {
            return this.DiagMap.end();
        }

        public void $destroy() {
            this.DiagMap.$destroy();
        }

        public DiagState(DiagState $Prm0) {
            this.DiagMap = new DenseMapUIntType($Prm0.DiagMap);
        }

        public DiagState() {
            this.DiagMap = new DenseMapUIntType((DenseMapInfoUInt)new DenseMapInfoUIntImpl(), (Object)new DiagnosticMapping());
        }

        public String toString() {
            return "DiagMap=" + this.DiagMap;
        }
    }

    public static final class ArgumentKind
    extends Enum<ArgumentKind>
    implements Native.ComparableLower {
        public static final /* enum */ ArgumentKind ak_std_string = new ArgumentKind(0);
        public static final /* enum */ ArgumentKind ak_c_string = new ArgumentKind(ak_std_string.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_sint = new ArgumentKind(ak_c_string.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_uint = new ArgumentKind(ak_sint.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_tokenkind = new ArgumentKind(ak_uint.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_identifierinfo = new ArgumentKind(ak_tokenkind.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_qualtype = new ArgumentKind(ak_identifierinfo.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_declarationname = new ArgumentKind(ak_qualtype.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_nameddecl = new ArgumentKind(ak_declarationname.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_nestednamespec = new ArgumentKind(ak_nameddecl.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_declcontext = new ArgumentKind(ak_nestednamespec.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_qualtype_pair = new ArgumentKind(ak_declcontext.getValue() + 1);
        public static final /* enum */ ArgumentKind ak_attr = new ArgumentKind(ak_qualtype_pair.getValue() + 1);
        private final int value;
        private static final /* synthetic */ ArgumentKind[] $VALUES;

        public static ArgumentKind[] values() {
            return (ArgumentKind[])$VALUES.clone();
        }

        public static ArgumentKind valueOf(String name) {
            return Enum.valueOf(ArgumentKind.class, name);
        }

        public static ArgumentKind valueOf(int val) {
            ArgumentKind out;
            ArgumentKind argumentKind = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private ArgumentKind(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((ArgumentKind)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((ArgumentKind)((Object)obj)).value);
        }

        static {
            $VALUES = new ArgumentKind[]{ak_std_string, ak_c_string, ak_sint, ak_uint, ak_tokenkind, ak_identifierinfo, ak_qualtype, ak_declarationname, ak_nameddecl, ak_nestednamespec, ak_declcontext, ak_qualtype_pair, ak_attr};
        }

        private static final class Values {
            private static final ArgumentKind[] VALUES;
            private static final ArgumentKind[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (ArgumentKind kind : ArgumentKind.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new ArgumentKind[min < 0 ? 1 - min : 0];
                VALUES = new ArgumentKind[max >= 0 ? 1 + max : 0];
                for (ArgumentKind kind : ArgumentKind.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((ArgumentKind)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((ArgumentKind)kind).value] = kind;
                }
            }
        }
    }

    public static final class Level
    extends Enum<Level>
    implements Native.ComparableLower {
        public static final /* enum */ Level Ignored = new Level(DiagnosticIDs.Level.Ignored.getValue());
        public static final /* enum */ Level Note = new Level(DiagnosticIDs.Level.Note.getValue());
        public static final /* enum */ Level Remark = new Level(DiagnosticIDs.Level.Remark.getValue());
        public static final /* enum */ Level Warning = new Level(DiagnosticIDs.Level.Warning.getValue());
        public static final /* enum */ Level Error = new Level(DiagnosticIDs.Level.Error.getValue());
        public static final /* enum */ Level Fatal = new Level(DiagnosticIDs.Level.Fatal.getValue());
        private final int value;
        private static final /* synthetic */ Level[] $VALUES;

        public static Level[] values() {
            return (Level[])$VALUES.clone();
        }

        public static Level valueOf(String name) {
            return Enum.valueOf(Level.class, name);
        }

        public static Level valueOf(int val) {
            Level out;
            Level level = out = val < 0 ? Values._VALUES[-val] : Values.VALUES[val];
            assert (out != null) : "no value for " + val;
            assert (out.value == val) : "asked [" + val + "] got " + (Object)((Object)out) + ":" + out.value + "]";
            return out;
        }

        private Level(int val) {
            this.value = val;
        }

        public int getValue() {
            return this.value;
        }

        public boolean $less(Object obj) {
            return Unsigned.$less_uint((int)this.value, (int)((Level)((Object)obj)).value);
        }

        public boolean $lesseq(Object obj) {
            return Unsigned.$lesseq_uint((int)this.value, (int)((Level)((Object)obj)).value);
        }

        static {
            $VALUES = new Level[]{Ignored, Note, Remark, Warning, Error, Fatal};
        }

        private static final class Values {
            private static final Level[] VALUES;
            private static final Level[] _VALUES;

            private Values() {
            }

            static {
                int max = 0;
                int min = 0;
                for (Level kind : Level.values()) {
                    if (kind.value > max) {
                        max = kind.value;
                    }
                    if (kind.value >= min) continue;
                    min = kind.value;
                }
                _VALUES = new Level[min < 0 ? 1 - min : 0];
                VALUES = new Level[max >= 0 ? 1 + max : 0];
                for (Level kind : Level.values()) {
                    if (kind.value < 0) {
                        Values._VALUES[-((Level)kind).value] = kind;
                        continue;
                    }
                    Values.VALUES[((Level)kind).value] = kind;
                }
            }
        }
    }
}

