/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.toolbar;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.UIResource;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.remote.ui.ServerListUI;
import org.netbeans.modules.cnd.remote.projectui.toolbar.RemoteHostAction;
import org.openide.awt.Actions;
import org.openide.awt.DynamicMenuContent;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;
import org.openide.util.actions.Presenter;

public class RemoteHostActionPerformer
implements ActionListener,
PropertyChangeListener,
Presenter.Menu {
    private static final Logger LOGGER = Logger.getLogger("remote.toolbar");
    private static final RequestProcessor RP = new RequestProcessor(RemoteHostActionPerformer.class);
    private static final DefaultComboBoxModel EMPTY_MODEL = new DefaultComboBoxModel();
    private static final Object CUSTOMIZE_ENTRY = new Object();
    private JComboBox hostListCombo;
    private boolean listeningToCombo = true;
    private RemoteHostAction presenter;

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("performerActivated".equals(e.getActionCommand()) && this.presenter == null) {
            this.presenter = (RemoteHostAction)((Object)e.getSource());
            this.hostListCombo = this.presenter.hostListCombo;
            this.initHostsListCombo();
            ServerList.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)ServerList.getRecords()));
        }
    }

    private void initHostsListCombo() {
        assert (EventQueue.isDispatchThread());
        if (this.hostListCombo == null) {
            return;
        }
        LOGGER.fine("initConfigListCombo");
        this.hostListCombo.addPopupMenuListener(new PopupMenuListener(){
            private Component prevFocusOwner = null;

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                this.prevFocusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                RemoteHostActionPerformer.this.hostListCombo.setFocusable(true);
                RemoteHostActionPerformer.this.hostListCombo.requestFocusInWindow();
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                if (this.prevFocusOwner != null) {
                    this.prevFocusOwner.requestFocusInWindow();
                }
                this.prevFocusOwner = null;
                RemoteHostActionPerformer.this.hostListCombo.setFocusable(false);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
            }
        });
        this.hostListCombo.setRenderer(new HostCellRenderer());
        this.hostListCombo.setToolTipText(Actions.cutAmpersand((String)this.presenter.getName()));
        this.hostListCombo.setFocusable(false);
        this.hostsListChanged(ServerList.getRecords());
        this.defaultHostChanged(ServerList.getDefaultRecord());
        this.hostListCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!RemoteHostActionPerformer.this.listeningToCombo) {
                    return;
                }
                Object o = RemoteHostActionPerformer.this.hostListCombo.getSelectedItem();
                if (o == CUSTOMIZE_ENTRY) {
                    RemoteHostActionPerformer.this.defaultHostChanged(ServerList.getDefaultRecord());
                    RP.post(new Runnable(){

                        @Override
                        public void run() {
                            ServerListUI.showServerListDialog();
                            RemoteHostActionPerformer.this.defaultHostChanged(ServerList.getDefaultRecord());
                        }
                    });
                } else if (o != null) {
                    RemoteHostActionPerformer.this.activeHostSelected((ServerRecord)o);
                }
            }
        });
    }

    private synchronized void hostsListChanged(Collection<? extends ServerRecord> records) {
        LOGGER.log(Level.FINE, "hostsListChanged: {0}", records);
        if (records == null) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteHostActionPerformer.this.hostListCombo.setModel(EMPTY_MODEL);
                    RemoteHostActionPerformer.this.hostListCombo.setEnabled(false);
                }
            });
        } else {
            final DefaultComboBoxModel<Object> model = new DefaultComboBoxModel<Object>(records.toArray());
            model.addElement(CUSTOMIZE_ENTRY);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    RemoteHostActionPerformer.this.hostListCombo.setModel(model);
                    RemoteHostActionPerformer.this.hostListCombo.setEnabled(true);
                    RemoteHostActionPerformer.this.defaultHostChanged(ServerList.getDefaultRecord());
                }
            });
        }
    }

    private synchronized void defaultHostChanged(final ServerRecord record) {
        LOGGER.log(Level.FINE, "defaultHostChanged: {0}", record);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                block4: {
                    RemoteHostActionPerformer.this.listeningToCombo = false;
                    try {
                        RemoteHostActionPerformer.this.hostListCombo.setSelectedIndex(-1);
                        if (record == null) break block4;
                        ComboBoxModel m = RemoteHostActionPerformer.this.hostListCombo.getModel();
                        for (int i = 0; i < m.getSize(); ++i) {
                            if (!record.equals(m.getElementAt(i))) continue;
                            RemoteHostActionPerformer.this.hostListCombo.setSelectedIndex(i);
                            break;
                        }
                    }
                    finally {
                        RemoteHostActionPerformer.this.listeningToCombo = true;
                    }
                }
            }
        });
    }

    private synchronized void activeHostSelected(final ServerRecord record) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                LOGGER.log(Level.FINE, "activeHostSelected: {0}", record);
                ServerList.setDefaultRecord((ServerRecord)record);
            }
        });
    }

    private static ServerRecord getActiveHost() {
        return ServerList.getDefaultRecord();
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("RECORD_LIST".equals(evt.getPropertyName())) {
            this.hostsListChanged(ServerList.getRecords());
        } else if ("DEFAULT_RECORD".equals(evt.getPropertyName())) {
            this.defaultHostChanged(ServerList.getDefaultRecord());
        }
    }

    public JMenuItem getMenuPresenter() {
        return new HostMenu();
    }

    private static class HostCellRenderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        private Border defaultBorder = this.getBorder();

        public HostCellRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String label;
            this.setName("ComboBox.listRenderer");
            if (value instanceof ServerRecord) {
                label = ((ServerRecord)value).getDisplayName();
                this.setBorder(this.defaultBorder);
            } else if (value == CUSTOMIZE_ENTRY) {
                label = Actions.cutAmpersand((String)NbBundle.getMessage(RemoteHostActionPerformer.class, (String)"ActiveHost.customize"));
                this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, UIManager.getColor("controlDkShadow")), this.defaultBorder));
            } else {
                assert (value == null);
                label = null;
                this.setBorder(this.defaultBorder);
            }
            this.setText(label);
            this.setIcon(null);
            if (isSelected) {
                this.setBackground(list.getSelectionBackground());
                this.setForeground(list.getSelectionForeground());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            return this;
        }

        @Override
        public String getName() {
            String name = super.getName();
            return name == null ? "ComboBox.renderer" : name;
        }
    }

    private class HostMenu
    extends JMenu
    implements DynamicMenuContent,
    ActionListener {
        public HostMenu() {
            Mnemonics.setLocalizedText((AbstractButton)this, (String)RemoteHostActionPerformer.this.presenter.getName());
        }

        public JComponent[] getMenuPresenters() {
            this.removeAll();
            boolean something = false;
            final ServerRecord activeHost = RemoteHostActionPerformer.getActiveHost();
            for (ServerRecord host : ServerList.getRecords()) {
                JRadioButtonMenuItem jmi = new JRadioButtonMenuItem(host.getDisplayName(), host.equals(activeHost));
                jmi.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        RemoteHostActionPerformer.this.activeHostSelected(activeHost);
                    }
                });
                this.add(jmi);
                something = true;
            }
            this.setEnabled(something);
            return new JComponent[]{this};
        }

        public JComponent[] synchMenuPresenters(JComponent[] items) {
            return this.getMenuPresenters();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }
    }
}

