/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.projectui.actions;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.remote.projectui.actions.ConnectionStatusAction;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionListener;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.openide.awt.StatusDisplayer;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class ConnectionStatusActionPerformer
implements ActionListener,
PropertyChangeListener,
ConnectionListener {
    private RequestProcessor RP = new RequestProcessor("Connection worker", 1);
    private static final Logger logger = Logger.getLogger("remote.toolbar");
    private ConnectionStatusAction presenter;
    private ExecutionEnvironment prevEnv = null;

    private void init() {
        ServerList.addPropertyChangeListener((PropertyChangeListener)WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this));
        ConnectionManager.getInstance().addConnectionListener((ConnectionListener)WeakListeners.create(ConnectionListener.class, (EventListener)this, (Object)ConnectionManager.getInstance()));
        this.updateStatus();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if ("performerActivated".equals(e.getActionCommand())) {
            this.presenter = (ConnectionStatusAction)e.getSource();
            this.init();
            return;
        }
        ExecutionEnvironment executionEnvironment = ServerList.getDefaultRecord().getExecutionEnvironment();
        if (executionEnvironment.isLocal()) {
            return;
        }
        this.actionPerformed(executionEnvironment, ConnectionManager.getInstance().isConnectedTo(executionEnvironment));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        ServerRecord r;
        Object source;
        if ("DEFAULT_RECORD".equals(evt.getPropertyName())) {
            if (logger.isLoggable(Level.FINE)) {
                ExecutionEnvironment executionEnvironment = ServerList.getDefaultRecord().getExecutionEnvironment();
                boolean connectedTo = ConnectionManager.getInstance().isConnectedTo(executionEnvironment);
                logger.log(Level.FINE, "change default host {0}, connected {1}", new Object[]{executionEnvironment, connectedTo});
            }
            this.updateStatus();
        }
        if ("stateChanged".equals(evt.getPropertyName()) && (source = evt.getSource()) instanceof ServerRecord && (r = (ServerRecord)source).getExecutionEnvironment().equals((Object)ServerList.getDefaultRecord().getExecutionEnvironment())) {
            this.updateStatus();
        }
    }

    public void connected(ExecutionEnvironment env) {
        ExecutionEnvironment executionEnvironment = ServerList.getDefaultRecord().getExecutionEnvironment();
        if (env.equals((Object)executionEnvironment)) {
            logger.log(Level.FINE, "change state host {0}, connected {1}", new Object[]{executionEnvironment, true});
            this.updateStatus();
        }
    }

    public void disconnected(ExecutionEnvironment env) {
        ExecutionEnvironment executionEnvironment = ServerList.getDefaultRecord().getExecutionEnvironment();
        if (env.equals((Object)executionEnvironment)) {
            logger.log(Level.FINE, "change state host {0}, connected {1}", new Object[]{executionEnvironment, false});
            this.updateStatus();
        }
    }

    private void updateStatus() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (ConnectionStatusActionPerformer.this.presenter != null) {
                    ExecutionEnvironment executionEnvironment = ServerList.getDefaultRecord().getExecutionEnvironment();
                    ServerRecord record = ServerList.get((ExecutionEnvironment)executionEnvironment);
                    if (!executionEnvironment.equals((Object)ConnectionStatusActionPerformer.this.prevEnv)) {
                        record.addPropertyChangeListener((PropertyChangeListener)ConnectionStatusActionPerformer.this);
                        if (ConnectionStatusActionPerformer.this.prevEnv != null) {
                            ServerRecord prevRecord = ServerList.get((ExecutionEnvironment)ConnectionStatusActionPerformer.this.prevEnv);
                            prevRecord.removePropertyChangeListener((PropertyChangeListener)ConnectionStatusActionPerformer.this);
                        }
                        ConnectionStatusActionPerformer.this.prevEnv = executionEnvironment;
                    }
                    ConnectionStatusActionPerformer.this.presenter.setEnabled(!executionEnvironment.isLocal());
                    boolean connectedTo = ConnectionManager.getInstance().isConnectedTo(executionEnvironment);
                    if (executionEnvironment.isLocal()) {
                        ConnectionStatusActionPerformer.this.presenter.putValue("iconBase", "org/netbeans/modules/cnd/remote/projectui/resources/connected.png");
                    } else if (connectedTo) {
                        if (record != null && record.isOnline()) {
                            ConnectionStatusActionPerformer.this.presenter.putValue("iconBase", "org/netbeans/modules/cnd/remote/projectui/resources/connected.png");
                        } else {
                            ConnectionStatusActionPerformer.this.presenter.putValue("iconBase", "org/netbeans/modules/cnd/remote/projectui/resources/not_set_up.png");
                        }
                    } else {
                        ConnectionStatusActionPerformer.this.presenter.putValue("iconBase", "org/netbeans/modules/cnd/remote/projectui/resources/disconnected.png");
                    }
                }
            }
        });
    }

    private void actionPerformed(final ExecutionEnvironment executionEnvironment, final boolean isConnected) {
        this.RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!isConnected) {
                        ConnectionManager.getInstance().connectTo(executionEnvironment);
                        ServerRecord record = ServerList.get((ExecutionEnvironment)executionEnvironment);
                        record.checkSetupAfterConnection(null);
                    } else {
                        ConnectionManager.getInstance().disconnect(executionEnvironment);
                    }
                }
                catch (Exception ex) {
                    String message = NbBundle.getMessage(ConnectionStatusActionPerformer.class, (String)"ErrorConnectingHost", (Object)executionEnvironment.getDisplayName(), (Object)ex.getMessage());
                    StatusDisplayer.getDefault().setStatusText(message);
                }
            }
        });
    }
}

