/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor.fxml;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.SwingUtilities;
import org.netbeans.modules.javafx2.editor.fxml.Bundle;
import org.openide.cookies.OpenCookie;
import org.openide.loaders.DataObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;

public class FXMLEditAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final Lookup context;
    private Lookup.Result<DataObject> lkpInfo;

    public FXMLEditAction() {
        this(Utilities.actionsGlobalContext());
    }

    public FXMLEditAction(Lookup context) {
        this.context = context;
        this.putValue("Name", Bundle.CTL_EditAction());
        this.putValue("hideWhenDisabled", true);
    }

    void init() {
        assert (SwingUtilities.isEventDispatchThread()) : "this shall be called just from AWT thread";
        if (this.lkpInfo != null) {
            return;
        }
        this.lkpInfo = this.context.lookupResult(DataObject.class);
        this.lkpInfo.addLookupListener((LookupListener)this);
        this.resultChanged(null);
    }

    @Override
    public boolean isEnabled() {
        this.init();
        return super.isEnabled() && this.context.lookupAll(DataObject.class).size() == 1;
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnabled(!this.lkpInfo.allInstances().isEmpty());
    }

    public Action createContextAwareInstance(Lookup context) {
        return new FXMLEditAction(context);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        DataObject dobj = (DataObject)this.context.lookup(DataObject.class);
        OpenCookie oc = (OpenCookie)dobj.getCookie(OpenCookie.class);
        if (oc != null) {
            oc.open();
        }
    }
}

