/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mercurial.remote.ui.queues;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.mercurial.remote.HgModuleConfig;
import org.netbeans.modules.mercurial.remote.ui.queues.Bundle;
import org.netbeans.modules.mercurial.remote.ui.queues.CommitPanel;
import org.netbeans.modules.mercurial.remote.ui.queues.QPatch;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.netbeans.modules.versioning.util.common.VCSCommitParameters;
import org.openide.util.NbBundle;

public class QCreatePatchParameters
extends VCSCommitParameters.DefaultCommitParameters
implements ItemListener,
DocumentListener,
ActionListener {
    private CommitPanel panel;
    private final String commitMessage;
    private final QPatch patch;
    private String errorMessage;
    private boolean userValid;
    private String user;
    private final List<String> recentUsers;
    private final VCSFileProxy root;

    public QCreatePatchParameters(VCSFileProxy root, Preferences preferences, String commitMessage, QPatch patch, List<String> recentUsers) {
        super(preferences);
        this.root = root;
        this.commitMessage = commitMessage;
        this.patch = patch;
        this.recentUsers = recentUsers;
    }

    public CommitPanel getPanel() {
        if (this.panel == null) {
            this.panel = this.createPanel();
            this.panel.txtPatchName.getDocument().addDocumentListener(this);
            this.panel.cbAuthor.addActionListener(this);
            ((JTextComponent)this.panel.cmbAuthor.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
        }
        return this.panel;
    }

    public JLabel getMessagesTemplateLink(JTextArea text) {
        return super.getMessagesTemplateLink(text, "org.netbeans.modules.mercurial.remote.ui.queues.TemplatePanel");
    }

    public JLabel getRecentMessagesLink(JTextArea text) {
        return super.getRecentMessagesLink(text);
    }

    public Preferences getPreferences() {
        return super.getPreferences();
    }

    public String getLastCanceledCommitMessage() {
        return HgModuleConfig.getDefault(this.root).getLastCanceledCommitMessage("qcreate");
    }

    List<String> getCommitMessages() {
        return QCreatePatchParameters.getRecentCommitMessages((Preferences)this.getPreferences());
    }

    protected CommitPanel createPanel() {
        return new CommitPanel(this, this.commitMessage, this.patch == null ? null : this.patch.getId());
    }

    public String getCommitMessage() {
        return this.getPanel().messageTextArea.getText();
    }

    public String getPatchName() {
        return this.getPanel().txtPatchName.getText().trim();
    }

    QPatch getPatch() {
        return this.patch;
    }

    public boolean isCommitable() {
        if (this.getPatchName().isEmpty()) {
            this.errorMessage = NbBundle.getMessage(QCreatePatchParameters.class, (String)"MSG_WARNING_EMPTY_PATCH_NAME");
            return false;
        }
        if (!this.isUserValid()) {
            this.errorMessage = Bundle.MSG_QPatchForm_ErrorInvalidAuthor();
            return false;
        }
        this.errorMessage = null;
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.changedUpdate(e);
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        if (e.getDocument() == ((JTextComponent)this.panel.cmbAuthor.getEditor().getEditorComponent()).getDocument()) {
            boolean oldUserValid = this.userValid;
            this.validateUser();
            if (this.userValid != oldUserValid && this.panel.cbAuthor.isSelected()) {
                this.fireChange();
            }
        } else {
            this.fireChange();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.panel.cbAuthor) {
            this.panel.cmbAuthor.setEnabled(this.panel.cbAuthor.isSelected());
            this.validateUser();
            this.fireChange();
        }
    }

    String getUser() {
        return this.panel.cbAuthor.isSelected() && this.isUserValid() ? this.user : null;
    }

    ComboBoxModel createRecentUsersModel() {
        return new DefaultComboBoxModel<String>(this.recentUsers.toArray(new String[this.recentUsers.size()]));
    }

    private boolean isUserValid() {
        return this.userValid || !this.panel.cbAuthor.isSelected();
    }

    private void validateUser() {
        this.user = this.panel.cmbAuthor.getEditor().getItem().toString().trim();
        this.userValid = !this.user.isEmpty();
    }
}

