/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository;

import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;
import org.netbeans.modules.cnd.repository.AsyncRepositoryWriter;
import org.netbeans.modules.cnd.repository.AsyncRepositoryWriterImpl;
import org.netbeans.modules.cnd.repository.Logger;
import org.netbeans.modules.cnd.repository.RemoveKeySupport;
import org.netbeans.modules.cnd.repository.RepositoryCache;
import org.netbeans.modules.cnd.repository.api.RepositoryExceptions;
import org.netbeans.modules.cnd.repository.api.UnitDescriptor;
import org.netbeans.modules.cnd.repository.impl.spi.LayeringSupport;
import org.netbeans.modules.cnd.repository.impl.spi.RepositoryImplementation;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryDataInput;
import org.netbeans.modules.cnd.repository.storage.StorageManager;

public final class RepositoryImpl
implements RepositoryImplementation,
RemoveKeySupport {
    static final Persistent REMOVED_OBJECT = new RemovedObject();
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<Integer, RepositoryCache> caches = new ConcurrentHashMap();
    private final StorageManager storage;
    private final AsyncRepositoryWriter writer;
    private static final java.util.logging.Logger log = Logger.getInstance();

    public RepositoryImpl(int persistMechanismVersion) {
        this.storage = new StorageManager(persistMechanismVersion);
        this.writer = new AsyncRepositoryWriterImpl(this.storage, this);
    }

    public Persistent get(Key key) {
        try {
            RepositoryCache unitCache = this.getCache(key.getUnitId());
            Persistent result = unitCache.get(key);
            if (result == REMOVED_OBJECT) {
                return null;
            }
            if (result == null) {
                result = this.writer.get(key);
            }
            if (result == null) {
                Persistent old;
                RepositoryDataInput in = this.storage.getInputStream(key);
                if (in == null) {
                    return null;
                }
                try {
                    result = key.getPersistentFactory().read(in);
                }
                catch (IllegalArgumentException ex) {
                    CharSequence unitName = null;
                    try {
                        unitName = this.storage.getUnitName(key.getUnitId());
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    this.storage.getInputStream(key);
                    throw new IllegalArgumentException(ex.getMessage() + ". Occured for the key: " + key.getClass().getName() + " with unit id: " + key.getUnitId() + " " + unitName + " and behaviour: " + key.getBehavior(), ex);
                }
                if (result == null) {
                    result = REMOVED_OBJECT;
                }
                if ((old = unitCache.putIfAbsent(key, result)) != null) {
                    result = old;
                }
            }
            if (REMOVED_OBJECT.equals(result)) {
                return null;
            }
            return result;
        }
        catch (Throwable th) {
            RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)th);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Key key, Persistent obj) {
        try {
            RepositoryCache unitCache = this.getCache(key.getUnitId());
            this.lock.lock();
            try {
                if (obj != REMOVED_OBJECT) {
                    unitCache.put(key, obj);
                }
                this.putImpl(key, obj);
            }
            finally {
                this.lock.unlock();
            }
        }
        catch (Throwable th) {
            RepositoryExceptions.throwException((Object)this, (Key)key, (Throwable)th);
        }
    }

    @Override
    public void removeKey(Key key) {
        RepositoryCache unitCache = this.getCache(key.getUnitId());
        try {
            this.lock.lock();
            this.storage.remove(key);
            unitCache.removePhysically(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void remove(Key key) {
        RepositoryCache unitCache = this.getCache(key.getUnitId());
        unitCache.remove(key);
        this.put(key, REMOVED_OBJECT);
    }

    public void shutdown() {
        this.storage.flush();
        try {
            this.writer.flush();
            this.writer.shutdown();
        }
        catch (InterruptedException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        this.storage.shutdown();
    }

    public void closeUnit(int unitID, boolean cleanRepository, Set<Integer> requiredUnits) {
        HashSet<RepositoryCache.Pair<Key, Persistent>> hung = new HashSet<RepositoryCache.Pair<Key, Persistent>>();
        RepositoryCache cache = this.getCache(unitID);
        hung.addAll(cache.clearHungObjects());
        for (RepositoryCache.Pair pair : hung) {
            this.putImpl((Key)pair.first, (Persistent)pair.second);
        }
        try {
            this.writer.flush(unitID);
        }
        catch (IOException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        catch (InterruptedException ex) {
            RepositoryExceptions.throwException((Object)this, (Throwable)ex);
        }
        cache.clearSoftRefs();
        this.storage.close(unitID, cleanRepository, requiredUnits);
    }

    public void openUnit(int unitID) {
        this.storage.open(unitID);
    }

    public void removeUnit(int unitID) {
        this.writer.removeUnit(unitID);
        this.storage.removeUnit(unitID);
    }

    public void hang(Key key, Persistent obj) {
        this.getCache(key.getUnitId()).hang(key, obj);
    }

    public void debugDistribution() {
    }

    public void debugDump(Key key) {
    }

    private RepositoryCache getCache(int unitID) {
        RepositoryCache result = this.caches.get(unitID);
        if (result == null) {
            result = new RepositoryCache();
            RepositoryCache old = this.caches.putIfAbsent(unitID, result);
            if (old != null) {
                result = old;
            }
        }
        return result;
    }

    public int getFileIdByName(int unitID, CharSequence fileName) {
        return this.storage.getFileIdByName(unitID, fileName);
    }

    public CharSequence getFileNameById(int unitID, int fileID) {
        return this.storage.getFileNameByIdx(unitID, fileID);
    }

    public CharSequence getFileNameByIdSafe(int unitId, int fileID) {
        return this.getFileNameById(unitId, fileID);
    }

    public CharSequence getUnitName(int unitID) {
        return this.storage.getUnitName(unitID);
    }

    public int getUnitID(UnitDescriptor unitDescriptor) {
        return this.storage.getUnitID(unitDescriptor);
    }

    public int getUnitID(UnitDescriptor unitDescriptor, int storageID) {
        return this.storage.getUnitID(unitDescriptor, storageID);
    }

    public int getRepositoryID(int sourceUnitId) {
        return this.storage.getStorageID(sourceUnitId);
    }

    private void putImpl(Key key, Persistent obj) {
        this.writer.put(key, obj);
    }

    public LayeringSupport getLayeringSupport(int clientUnitID) {
        return this.storage.getLayeringSupport(clientUnitID);
    }

    private static final class RemovedObject
    implements Persistent {
        private RemovedObject() {
        }

        public String toString() {
            return "RemovedObject";
        }
    }
}

