/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.modelimpl.csm.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmCompoundClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmField;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInheritance;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmTypedef;
import org.netbeans.modules.cnd.api.model.CsmVisibility;
import org.netbeans.modules.cnd.api.model.services.CsmInheritanceUtilities;
import org.netbeans.modules.cnd.api.model.support.CsmFileLanguageProvider;
import org.netbeans.modules.cnd.api.model.util.CsmBaseUtilities;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.apt.support.APTHandlersSupport;
import org.netbeans.modules.cnd.apt.support.api.PreprocHandler;
import org.netbeans.modules.cnd.apt.support.api.StartEntry;
import org.netbeans.modules.cnd.modelimpl.content.project.FileContainer;
import org.netbeans.modules.cnd.modelimpl.csm.core.CsmIdentifiable;
import org.netbeans.modules.cnd.modelimpl.csm.core.Disposable;
import org.netbeans.modules.cnd.modelimpl.csm.core.FileImpl;
import org.netbeans.modules.cnd.modelimpl.csm.core.Offsetable;
import org.netbeans.modules.cnd.modelimpl.csm.core.OffsetableIdentifiableBase;
import org.netbeans.modules.cnd.modelimpl.csm.core.ProjectBase;
import org.netbeans.modules.cnd.modelimpl.debug.TraceFlags;
import org.netbeans.modules.cnd.modelimpl.repository.RepositoryUtils;
import org.netbeans.modules.cnd.modelimpl.textcache.NameCache;
import org.netbeans.modules.cnd.modelutil.ClassifiersAntiLoop;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.openide.util.lookup.Lookups;

public class Utils {
    public static final Logger LOG = Logger.getLogger("org.netbeans.modules.cnd.modelimpl");
    private static final int LOG_LEVEL = Integer.getInteger("org.netbeans.modules.cnd.modelimpl.level", -1);
    private static final int SIZEOF_SIMPLE_POINTER = 4;
    private static final int SIZEOF_SIMPLE_REFERENCE = 4;
    private static final int SIZEOF_SIMPLE_ENUM = 4;
    private static final Map<String, Integer> builtInSizes;
    private static final ThreadLocal<ClassifiersAntiLoop> threadLocalClassifiersAntiloop;

    private Utils() {
    }

    public static String getLanguage(CsmFile.FileType fileType, String path) {
        String lang;
        if (!LangProviders.langProviders.isEmpty()) {
            for (CsmFileLanguageProvider provider : LangProviders.langProviders) {
                lang = provider.getLanguage(fileType, path);
                if (lang == null) continue;
                return lang;
            }
        }
        if (fileType == CsmFile.FileType.SOURCE_CPP_FILE) {
            lang = "Gnu C++ Language";
        } else if (fileType == CsmFile.FileType.SOURCE_C_FILE) {
            lang = "Gnu C Language";
        } else if (fileType == CsmFile.FileType.SOURCE_FORTRAN_FILE) {
            lang = "Fortran Language";
        } else {
            lang = "Gnu C++ Language";
            if (path.length() > 2 && path.endsWith(".c")) {
                lang = "Gnu C Language";
            }
        }
        return lang;
    }

    public static String getLanguageFlavor(NativeFileItem.LanguageFlavor flavor) {
        if (flavor == NativeFileItem.LanguageFlavor.CPP11 || flavor == NativeFileItem.LanguageFlavor.CPP14) {
            return "C++11";
        }
        return "";
    }

    public static CsmOffsetable createOffsetable(CsmFile file, int startOffset, int endOffset) {
        return new Offsetable(file, startOffset, endOffset);
    }

    public static CharSequence getQualifiedName(CharSequence name, CsmNamespace parent) {
        if (parent != null && !parent.isGlobal()) {
            return CharSequenceUtils.concatenate((CharSequence)parent.getQualifiedName(), (CharSequence)"::", (CharSequence)name);
        }
        return name;
    }

    public static CharSequence[] splitQualifiedName(String qualified) {
        ArrayList<CharSequence> v = new ArrayList<CharSequence>();
        StringTokenizer t = new StringTokenizer(qualified, ": \t\n\r\f", false);
        while (t.hasMoreTokens()) {
            v.add(NameCache.getManager().getString((CharSequence)t.nextToken()));
        }
        return v.toArray(new CharSequence[v.size()]);
    }

    public static void disposeAll(Collection<? extends CsmObject> coll) {
        for (CsmObject csmObject : coll) {
            if (csmObject instanceof Disposable) {
                Disposable decl = (Disposable)csmObject;
                if (TraceFlags.TRACE_DISPOSE) {
                    System.err.println("disposing with UID " + ((CsmIdentifiable)csmObject).getUID());
                }
                decl.dispose();
                continue;
            }
            if (!TraceFlags.TRACE_DISPOSE) continue;
            System.err.println("non disposable with UID " + ((CsmIdentifiable)csmObject).getUID());
        }
    }

    public static void setSelfUID(CsmObject decl) {
        if (!(decl instanceof OffsetableIdentifiableBase)) {
            throw new IllegalArgumentException("unexpected object:" + decl);
        }
        ((OffsetableIdentifiableBase)decl).setSelfUID();
    }

    public static char getCsmIncludeKindKey() {
        return 'I';
    }

    public static char getCsmInheritanceKindKey(CsmInheritance obj) {
        switch (obj.getVisibility()) {
            case PRIVATE: {
                return 'h';
            }
            case PROTECTED: {
                return 'y';
            }
            case PUBLIC: {
                return 'H';
            }
        }
        return 'Y';
    }

    public static char getCsmInheritanceKindKey(CsmVisibility obj) {
        switch (obj) {
            case PRIVATE: {
                return 'h';
            }
            case PROTECTED: {
                return 'y';
            }
            case PUBLIC: {
                return 'H';
            }
        }
        return 'Y';
    }

    public static CsmVisibility getCsmVisibility(char c) {
        switch (c) {
            case 'h': {
                return CsmVisibility.PRIVATE;
            }
            case 'y': {
                return CsmVisibility.PROTECTED;
            }
            case 'H': {
                return CsmVisibility.PUBLIC;
            }
        }
        return CsmVisibility.NONE;
    }

    public static char getCsmParamListKindKey() {
        return 'P';
    }

    public static char getCsmInstantiationKindKey() {
        return 'i';
    }

    public static CharSequence[] getAllClassifiersUniqueNames(CharSequence uniqueName) {
        CharSequence namePostfix = uniqueName.subSequence(1, uniqueName.length());
        CharSequence[] out = new CharSequence[]{CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.STRUCT), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.UNION), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.ENUM), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.TYPEDEF), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.TYPEALIAS), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION), (CharSequence)namePostfix), CharSequenceUtils.concatenate((char)Utils.getCsmDeclarationKindkey(CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION), (CharSequence)namePostfix)};
        return out;
    }

    public static char getCsmDeclarationKindkey(CsmDeclaration.Kind kind) {
        switch (kind) {
            case ASM: {
                return 'A';
            }
            case BUILT_IN: {
                return 'B';
            }
            case CLASS: {
                return 'C';
            }
            case ENUM: {
                return 'E';
            }
            case FUNCTION: {
                return 'F';
            }
            case MACRO: {
                return 'M';
            }
            case NAMESPACE_DEFINITION: {
                return 'N';
            }
            case STRUCT: {
                return 'S';
            }
            case TEMPLATE_DECLARATION: {
                return 'T';
            }
            case UNION: {
                return 'U';
            }
            case VARIABLE: {
                return 'V';
            }
            case NAMESPACE_ALIAS: {
                return 'a';
            }
            case ENUMERATOR: {
                return 'e';
            }
            case FUNCTION_DEFINITION: {
                return 'f';
            }
            case FUNCTION_LAMBDA: {
                return 'l';
            }
            case FUNCTION_INSTANTIATION: {
                return 'j';
            }
            case USING_DIRECTIVE: {
                return 'g';
            }
            case TEMPLATE_PARAMETER: {
                return 'p';
            }
            case CLASS_FRIEND_DECLARATION: {
                return 'r';
            }
            case TEMPLATE_SPECIALIZATION: {
                return 's';
            }
            case TYPEDEF: {
                return 't';
            }
            case TYPEALIAS: {
                return 'x';
            }
            case USING_DECLARATION: {
                return 'u';
            }
            case VARIABLE_DEFINITION: {
                return 'v';
            }
            case CLASS_FORWARD_DECLARATION: {
                return 'w';
            }
            case ENUM_FORWARD_DECLARATION: {
                return 'W';
            }
            case FUNCTION_FRIEND: {
                return 'D';
            }
            case FUNCTION_FRIEND_DEFINITION: {
                return 'd';
            }
            case FUNCTION_TYPE: {
                return 'z';
            }
        }
        throw new IllegalArgumentException("Unexpected value of CsmDeclaration.Kind:" + kind);
    }

    public static CsmDeclaration.Kind getCsmDeclarationKind(char kind) {
        switch (kind) {
            case 'A': {
                return CsmDeclaration.Kind.ASM;
            }
            case 'B': {
                return CsmDeclaration.Kind.BUILT_IN;
            }
            case 'C': {
                return CsmDeclaration.Kind.CLASS;
            }
            case 'E': {
                return CsmDeclaration.Kind.ENUM;
            }
            case 'F': {
                return CsmDeclaration.Kind.FUNCTION;
            }
            case 'M': {
                return CsmDeclaration.Kind.MACRO;
            }
            case 'N': {
                return CsmDeclaration.Kind.NAMESPACE_DEFINITION;
            }
            case 'S': {
                return CsmDeclaration.Kind.STRUCT;
            }
            case 'T': {
                return CsmDeclaration.Kind.TEMPLATE_DECLARATION;
            }
            case 'U': {
                return CsmDeclaration.Kind.UNION;
            }
            case 'V': {
                return CsmDeclaration.Kind.VARIABLE;
            }
            case 'a': {
                return CsmDeclaration.Kind.NAMESPACE_ALIAS;
            }
            case 'e': {
                return CsmDeclaration.Kind.ENUMERATOR;
            }
            case 'f': {
                return CsmDeclaration.Kind.FUNCTION_DEFINITION;
            }
            case 'l': {
                return CsmDeclaration.Kind.FUNCTION_LAMBDA;
            }
            case 'j': {
                return CsmDeclaration.Kind.FUNCTION_INSTANTIATION;
            }
            case 'g': {
                return CsmDeclaration.Kind.USING_DIRECTIVE;
            }
            case 'p': {
                return CsmDeclaration.Kind.TEMPLATE_PARAMETER;
            }
            case 'r': {
                return CsmDeclaration.Kind.CLASS_FRIEND_DECLARATION;
            }
            case 's': {
                return CsmDeclaration.Kind.TEMPLATE_SPECIALIZATION;
            }
            case 't': {
                return CsmDeclaration.Kind.TYPEDEF;
            }
            case 'x': {
                return CsmDeclaration.Kind.TYPEALIAS;
            }
            case 'u': {
                return CsmDeclaration.Kind.USING_DECLARATION;
            }
            case 'v': {
                return CsmDeclaration.Kind.VARIABLE_DEFINITION;
            }
            case 'w': {
                return CsmDeclaration.Kind.CLASS_FORWARD_DECLARATION;
            }
            case 'W': {
                return CsmDeclaration.Kind.ENUM_FORWARD_DECLARATION;
            }
            case 'D': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND;
            }
            case 'd': {
                return CsmDeclaration.Kind.FUNCTION_FRIEND_DEFINITION;
            }
            case 'z': {
                return CsmDeclaration.Kind.FUNCTION_TYPE;
            }
        }
        throw new IllegalArgumentException("Unexpected char for CsmDeclaration.Kind: " + kind);
    }

    public static boolean canRegisterDeclaration(CsmDeclaration decl) {
        assert (decl != null);
        assert (decl.getName() != null);
        if (decl.getName().length() == 0) {
            return false;
        }
        CsmScope scope = decl.getScope();
        if (scope instanceof CsmCompoundClassifier) {
            return Utils.canRegisterDeclaration((CsmDeclaration)((CsmCompoundClassifier)scope));
        }
        return true;
    }

    public static <T> LinkedList<T> reverse(LinkedList<T> original) {
        LinkedList<T> reverse = new LinkedList<T>();
        ListIterator<T> it = original.listIterator(original.size());
        while (it.hasPrevious()) {
            reverse.addLast(it.previous());
        }
        return reverse;
    }

    public static NativeFileItem getCompiledFileItem(FileImpl fileImpl) {
        NativeFileItem out = null;
        ProjectBase filePrj = fileImpl.getProjectImpl(true);
        if (filePrj != null) {
            CharSequence fileKey = FileContainer.getFileKey(fileImpl.getAbsolutePath(), false);
            PreprocHandler.State state = filePrj.getFirstValidPreprocState(fileKey);
            if (state == null) {
                return null;
            }
            FileImpl startFile = Utils.getStartFile(state);
            out = startFile != null ? startFile.getNativeFileItem() : null;
        }
        return out;
    }

    public static FileImpl getStartFile(PreprocHandler.State state) {
        StartEntry startEntry = APTHandlersSupport.extractStartEntry((PreprocHandler.State)state);
        ProjectBase startProject = Utils.getStartProject(startEntry);
        FileImpl csmFile = startProject == null ? null : startProject.getFile(startEntry.getStartFile(), false);
        return csmFile;
    }

    public static ProjectBase getStartProject(PreprocHandler.State state) {
        return Utils.getStartProject(APTHandlersSupport.extractStartEntry((PreprocHandler.State)state));
    }

    public static ProjectBase getStartProject(StartEntry startEntry) {
        if (startEntry == null) {
            return null;
        }
        Key key = startEntry.getStartFileProject();
        ProjectBase prj = (ProjectBase)RepositoryUtils.get(key);
        return prj;
    }

    public static boolean isCppFile(CsmFile file) {
        return file instanceof FileImpl && ((FileImpl)file).isCppFile();
    }

    public static CsmFile.FileType getFileType(NativeFileItem nativeFile) {
        switch (nativeFile.getLanguage()) {
            case C: {
                return CsmFile.FileType.SOURCE_C_FILE;
            }
            case CPP: {
                return CsmFile.FileType.SOURCE_CPP_FILE;
            }
            case FORTRAN: {
                return CsmFile.FileType.SOURCE_FORTRAN_FILE;
            }
            case C_HEADER: {
                return CsmFile.FileType.HEADER_FILE;
            }
        }
        return CsmFile.FileType.UNDEFINED_FILE;
    }

    public static boolean acceptNativeItem(NativeFileItem item) {
        if (item.getFileObject() == null || !item.getFileObject().isValid()) {
            return false;
        }
        NativeFileItem.Language language = item.getLanguage();
        return (language == NativeFileItem.Language.C || language == NativeFileItem.Language.CPP || language == NativeFileItem.Language.FORTRAN || language == NativeFileItem.Language.C_HEADER) && !item.isExcluded();
    }

    public static int getSizeOfType(CsmType type, CsmFile context) {
        if (!CsmBaseUtilities.isValid((CsmObject)type)) {
            return -1;
        }
        if (type.isReference()) {
            return Utils.getSizeOfReference(type.getContainingFile());
        }
        if (type.isPointer()) {
            return Utils.getSizeOfPointer(type.getContainingFile());
        }
        if (type.getArrayDepth() > 0) {
            CsmClassifier cls = type.getClassifier();
            return Utils.getSizeOfClassifier(cls, type.getContainingFile());
        }
        CsmClassifier cls = type.getClassifier();
        return Utils.getSizeOfClassifier(cls, type.getContainingFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getSizeOfClassifier(CsmClassifier classifier, CsmFile context) {
        if (!CsmBaseUtilities.isValid((CsmObject)classifier)) {
            return -1;
        }
        if (threadLocalClassifiersAntiloop.get().add(classifier)) {
            try {
                if (CsmKindUtilities.isClass((CsmObject)classifier)) {
                    int size = 0;
                    CsmClass cls = (CsmClass)classifier;
                    Collection baseClasses = cls.getBaseClasses();
                    for (CsmInheritance inheritance : baseClasses) {
                        CsmClass baseClass = CsmInheritanceUtilities.getCsmClass((CsmInheritance)inheritance);
                        int baseClassSize = Utils.getSizeOfClassifier((CsmClassifier)baseClass, context);
                        if (baseClassSize == -1) {
                            int n = -1;
                            return n;
                        }
                        size += baseClassSize;
                    }
                    for (CsmMember member : cls.getMembers()) {
                        CsmField field;
                        if (!CsmKindUtilities.isField((CsmObject)member) || (field = (CsmField)member).isStatic()) continue;
                        CsmType fieldType = field.getType();
                        int fieldSize = Utils.getSizeOfType(fieldType, context);
                        if (fieldSize == -1) {
                            int n = -1;
                            return n;
                        }
                        size += fieldSize;
                    }
                    int n = Math.max(size, 1);
                    return n;
                }
                if (CsmKindUtilities.isEnum((CsmObject)classifier)) {
                    int n = Utils.getSizeOfEnum(context);
                    return n;
                }
                if (CsmKindUtilities.isBuiltIn((CsmObject)classifier)) {
                    int n = Utils.getSizeofBuiltIn(classifier.getName(), context);
                    return n;
                }
                if (CsmKindUtilities.isTypedef((CsmObject)classifier)) {
                    int n = Utils.getSizeOfType(((CsmTypedef)classifier).getType(), context);
                    return n;
                }
            }
            finally {
                threadLocalClassifiersAntiloop.get().remove(classifier);
            }
        }
        return -1;
    }

    private static int getSizeOfPointer(CsmFile contextFile) {
        return 4;
    }

    private static int getSizeOfReference(CsmFile contextFile) {
        return 4;
    }

    private static int getSizeOfEnum(CsmFile contextFile) {
        return 4;
    }

    private static int getSizeofBuiltIn(CharSequence _name, CsmFile contextFile) {
        String name = _name.toString();
        Integer size = builtInSizes.get(name);
        return size != null ? size : -1;
    }

    static {
        if (LOG_LEVEL == -1) {
            if (TraceFlags.DEBUG) {
                LOG.setLevel(Level.ALL);
            } else {
                LOG.setLevel(Level.SEVERE);
            }
        }
        builtInSizes = new HashMap<String, Integer>();
        builtInSizes.put("char", 1);
        builtInSizes.put("short", 2);
        builtInSizes.put("int", 4);
        builtInSizes.put("unsigned", 4);
        builtInSizes.put("float", 4);
        builtInSizes.put("double", 8);
        threadLocalClassifiersAntiloop = new ThreadLocal<ClassifiersAntiLoop>(){

            @Override
            protected ClassifiersAntiLoop initialValue() {
                return new ClassifiersAntiLoop();
            }
        };
    }

    private static final class LangProviders {
        private static final Collection<? extends CsmFileLanguageProvider> langProviders = Lookups.forPath((String)"CND/CsmFileLanguageProvider").lookupAll(CsmFileLanguageProvider.class);

        private LangProviders() {
        }
    }
}

