/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.impl;

import java.awt.Point;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.netbeans.api.visual.anchor.Anchor;
import org.netbeans.api.visual.router.Router;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.LayerWidget;
import org.netbeans.api.visual.widget.Widget;

public class RelativePathRouter
implements Router {
    private static final int SHIFT_DISTANCE = 15;
    private final LayerWidget connectionLayer;

    public RelativePathRouter(LayerWidget connectionLayer) {
        this.connectionLayer = connectionLayer;
    }

    public List<Point> routeConnection(ConnectionWidget widget) {
        ArrayList<Point> list = new ArrayList<Point>();
        Anchor sourceAnchor = widget.getSourceAnchor();
        Anchor targetAnchor = widget.getTargetAnchor();
        if (sourceAnchor == null || targetAnchor == null) {
            return Collections.emptyList();
        }
        Point p0 = sourceAnchor.compute(widget.getSourceAnchorEntry()).getAnchorSceneLocation();
        Point p1 = targetAnchor.compute(widget.getTargetAnchorEntry()).getAnchorSceneLocation();
        if (p0.x == p1.x && p0.y == p1.y) {
            return Collections.emptyList();
        }
        list.add(p0);
        Point medium = new Point((p0.x + p1.x) / 2, (p0.y + p1.y) / 2);
        ConnectionWidget opposite = this.oppositeConnection(widget);
        if (opposite != null) {
            Point shiftedMedium;
            int h1;
            boolean positiveShift;
            int h0 = widget.hashCode();
            boolean bl = positiveShift = h0 >= (h1 = opposite.hashCode());
            if (p1.x - p0.x == 0) {
                shiftedMedium = new Point(positiveShift ? medium.x + 15 : medium.x - 15, medium.y);
            } else if (p1.y - p0.y == 0) {
                shiftedMedium = new Point(medium.x, positiveShift ? medium.y + 15 : medium.y - 15);
            } else {
                double x2;
                double y2;
                double k = (double)(p1.y - p0.y) / (double)(p1.x - p0.x);
                double invK = -1.0 / k;
                if (Math.abs(invK) >= 1.0) {
                    y2 = positiveShift ? (double)(medium.y + 15) : (double)(medium.y - 15);
                    x2 = (double)medium.x + (y2 - (double)medium.y) / invK;
                } else {
                    x2 = positiveShift ? (double)(medium.x + 15) : (double)(medium.x - 15);
                    y2 = invK * (x2 - (double)medium.x) + (double)medium.y;
                }
                shiftedMedium = new Point((int)x2, (int)y2);
            }
            list.add(shiftedMedium);
        } else {
            list.add(medium);
        }
        list.add(p1);
        return list;
    }

    private ConnectionWidget oppositeConnection(ConnectionWidget c0) {
        Widget sourceAnchorWidget = c0.getSourceAnchor().getRelatedWidget();
        Widget targetAnchorWidget = c0.getTargetAnchor().getRelatedWidget();
        for (Widget w : this.connectionLayer.getChildren()) {
            if (!(w instanceof ConnectionWidget)) continue;
            ConnectionWidget c1 = (ConnectionWidget)w;
            Anchor sourceAnchor = c1.getSourceAnchor();
            Anchor targetAnchor = c1.getTargetAnchor();
            if (sourceAnchor == null || targetAnchor == null || !sourceAnchor.getRelatedWidget().equals((Object)targetAnchorWidget) || !targetAnchor.getRelatedWidget().equals((Object)sourceAnchorWidget)) continue;
            return c1;
        }
        return null;
    }
}

