/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger;

import org.netbeans.modules.cnd.debugger.common2.debugger.Address;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

public class Location {
    public static final Location EMPTY = new Location(null, 0, null, 0L, 0, null);
    public static final int UPDATE = 1;
    public static final int VISITED = 2;
    public static final int CALLED = 4;
    public static final int TOPFRAME = 8;
    public static final int BOTTOMFRAME = 16;
    public static final int SRC_OOD = 32;
    private final String src;
    private final int line;
    private final String func;
    private final long pc;
    private int flags;
    private final NativeBreakpoint breakpoint;

    protected Location(String src, int line, String func, long pc, int flags, NativeBreakpoint breakpoint) {
        this.src = src;
        this.line = line;
        this.func = func;
        this.pc = pc;
        this.flags = flags;
        this.breakpoint = breakpoint;
    }

    public Location line(int line) {
        return new Location(this.src, line, this.func, this.pc, this.flags, this.breakpoint);
    }

    public final void setVisited(boolean v) {
        this.flags = v ? (this.flags |= 2) : (this.flags &= 0xFFFFFFFD);
    }

    public final String src() {
        return this.src;
    }

    public final int line() {
        return this.line;
    }

    public final String func() {
        return this.func;
    }

    public final long pc() {
        return this.pc;
    }

    public final boolean update() {
        return (this.flags & 1) == 1;
    }

    public final boolean visited() {
        return (this.flags & 2) == 2;
    }

    public final boolean called() {
        return (this.flags & 4) == 4;
    }

    public final boolean topframe() {
        return (this.flags & 8) == 8;
    }

    public final boolean bottomframe() {
        return (this.flags & 0x10) == 16;
    }

    public final boolean srcOutOfdate() {
        return (this.flags & 0x20) == 32;
    }

    public final boolean hasSource() {
        return this.src != null && this.line > 0;
    }

    public NativeBreakpoint getBreakpoint() {
        return this.breakpoint;
    }

    public String toString() {
        String address = Address.toHexString0x(this.pc, true);
        return "\"" + this.src + "\":" + this.line + " " + this.func + "()" + " " + address + " " + (this.update() ? "UPDATE" : "NOUPDATE") + " " + (this.hasSource() ? "SRC" : "NOSRC");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Location)) {
            return false;
        }
        Location that = (Location)obj;
        if (this.line != that.line) {
            return false;
        }
        if (IpeUtils.sameString(this.src, that.src)) {
            return true;
        }
        return this.pc == that.pc;
    }

    public int hashCode() {
        int hash = 5;
        hash = 97 * hash + (this.src != null ? this.src.hashCode() : 0);
        hash = 97 * hash + this.line;
        hash = 97 * hash + (int)(this.pc ^ this.pc >>> 32);
        return hash;
    }
}

