/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.introduce;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.DialogBinding;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmNamedElement;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmTemplate;
import org.netbeans.modules.cnd.api.model.CsmTemplateParameter;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmInstantiationProvider;
import org.netbeans.modules.cnd.api.model.support.CsmTypes;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.refactoring.api.CsmContext;
import org.netbeans.modules.cnd.refactoring.api.IntroduceMethodRefactoring;
import org.netbeans.modules.cnd.refactoring.introduce.ErrorLabel;
import org.netbeans.modules.cnd.refactoring.ui.InsertPoint;
import org.netbeans.modules.cnd.refactoring.ui.UIUtilities;
import org.netbeans.modules.cnd.utils.cache.CharSequenceUtils;
import org.netbeans.modules.refactoring.spi.ui.CustomRefactoringPanel;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

public class IntroduceMethodPanel
extends JPanel
implements CustomRefactoringPanel {
    private final ParamTableModel model;
    private final FileObject fileObject;
    private final ChangeListener parent;
    private final CsmObject selectedObj;
    private final CsmContext editorContext;
    private final IntroduceMethodRefactoring refactoring;
    private IntroduceMethodRefactoring.IntroduceMethodContext res;
    private static final String DEFAULT_VALUES_ONLY_IN_DECLARATION = "UseDefaultValueOnlyInFunctionDefinition";
    private static Action editAction = null;
    private static final String[] columnNames = new String[]{IntroduceMethodPanel.getString("LBL_ChangeParsColByRef"), IntroduceMethodPanel.getString("LBL_ChangeParsColName"), IntroduceMethodPanel.getString("LBL_ChangeParsColType")};
    private static final String ACTION_INLINE_EDITOR = "invokeInlineEditor";
    private boolean initialized = false;
    private JPanel buttonsPanel;
    private JPanel eastPanel;
    private JLabel errorLabel;
    private JPanel fillPanel;
    private JComboBox insertPointCombo;
    private JLabel insertionPointLabel;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JLabel lblName;
    private JPanel modifiersPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JTextField name;
    private JTable paramTable;
    private JLabel paramTitle;
    private JLabel previewChange;
    private JEditorPane previewEditorPane;
    private JLabel returnTypeLabel;
    private JTextField returnTypeTextField;
    private JScrollPane westPanel;

    public IntroduceMethodPanel(IntroduceMethodRefactoring refactoring, CsmObject selectedObj, CsmContext editorContext, ChangeListener parent) {
        this.refactoring = refactoring;
        this.parent = parent;
        this.selectedObj = selectedObj;
        this.editorContext = editorContext;
        this.fileObject = editorContext.getFileObject();
        this.model = new ParamTableModel(columnNames, 0);
        this.initComponents();
        this.paramTable.setAutoResizeMode(3);
    }

    public void initialize() {
        if (this.initialized) {
            return;
        }
        this.res = this.refactoring.getIntroduceMethodContext();
        if (this.res == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IntroduceMethodPanel.this.name.requestFocus();
                IntroduceMethodPanel.this.returnTypeTextField.setText("void");
                IntroduceMethodPanel.this.name.setText("function");
                IntroduceMethodPanel.this.name.selectAll();
                if (IntroduceMethodPanel.this.res.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDefinition) {
                    IntroduceMethodPanel.this.insertionPointLabel.setVisible(true);
                    IntroduceMethodPanel.this.insertPointCombo.setVisible(true);
                    IntroduceMethodPanel.this.insertPointCombo.setEnabled(true);
                    InsertPoint.initInsertPoints(IntroduceMethodPanel.this.insertPointCombo, IntroduceMethodPanel.this.res.getEnclosingClass());
                } else {
                    IntroduceMethodPanel.this.insertionPointLabel.setVisible(false);
                    IntroduceMethodPanel.this.insertPointCombo.setEnabled(false);
                    IntroduceMethodPanel.this.insertPointCombo.setVisible(false);
                }
                IntroduceMethodPanel.this.initTableData();
                DialogBinding.bindComponentToFile((FileObject)IntroduceMethodPanel.this.fileObject, (int)IntroduceMethodPanel.this.res.getSelectionFrom(), (int)(IntroduceMethodPanel.this.res.getSelectionTo() - IntroduceMethodPanel.this.res.getSelectionFrom()), (JTextComponent)IntroduceMethodPanel.this.previewEditorPane);
                IntroduceMethodPanel.this.previewEditorPane.setBackground(IntroduceMethodPanel.this.getBackground());
                IntroduceMethodPanel.this.updateSignaturePreview();
                DocumentListener documentListener = new DocumentListener(){

                    @Override
                    public void insertUpdate(DocumentEvent e) {
                        IntroduceMethodPanel.this.updateSignaturePreview();
                    }

                    @Override
                    public void removeUpdate(DocumentEvent e) {
                        IntroduceMethodPanel.this.updateSignaturePreview();
                    }

                    @Override
                    public void changedUpdate(DocumentEvent e) {
                        IntroduceMethodPanel.this.updateSignaturePreview();
                    }
                };
                IntroduceMethodPanel.this.returnTypeTextField.getDocument().addDocumentListener(documentListener);
                IntroduceMethodPanel.this.name.getDocument().addDocumentListener(documentListener);
                IntroduceMethodPanel.this.initialized = true;
            }
        });
    }

    @Override
    public boolean requestFocusInWindow() {
        this.name.requestFocusInWindow();
        return true;
    }

    @Override
    public void requestFocus() {
        this.name.requestFocus();
    }

    public Component getComponent() {
        return this;
    }

    public DefaultTableModel getTableModel() {
        return this.model;
    }

    protected boolean isUseDefaultValueOnlyInFunctionDeclaration() {
        return NbPreferences.forModule(IntroduceMethodPanel.class).getBoolean(DEFAULT_VALUES_ONLY_IN_DECLARATION, false);
    }

    private JLabel createErrorLabel() {
        ErrorLabel.Validator validator = new ErrorLabel.Validator(){

            @Override
            public String validate(String text) {
                if (null == text || text.length() == 0) {
                    return "";
                }
                if (!CndLexerUtilities.isCppIdentifier((CharSequence)text)) {
                    return IntroduceMethodPanel.this.getDefaultErrorMessage(text);
                }
                return null;
            }
        };
        ErrorLabel eLabel = new ErrorLabel(this.name.getDocument(), validator);
        eLabel.addPropertyChangeListener("isValid", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
            }
        });
        return eLabel;
    }

    String getDefaultErrorMessage(String inputText) {
        return "'" + inputText + "' is not a valid identifier";
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.lblName = new JLabel();
        this.name = new JTextField();
        this.returnTypeLabel = new JLabel();
        this.returnTypeTextField = new JTextField();
        this.modifiersPanel = new JPanel();
        this.insertionPointLabel = new JLabel();
        this.insertPointCombo = new JComboBox();
        this.eastPanel = new JPanel();
        this.buttonsPanel = new JPanel();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.fillPanel = new JPanel();
        this.westPanel = new JScrollPane();
        this.paramTable = new JTable();
        this.paramTitle = new JLabel();
        this.previewChange = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.previewEditorPane = new JEditorPane();
        this.errorLabel = this.createErrorLabel();
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 11, 11));
        this.setAutoscrolls(true);
        this.setName(IntroduceMethodPanel.getString("LBL_TitleChangeParameters"));
        this.setLayout(new GridBagLayout());
        this.lblName.setLabelFor(this.name);
        Mnemonics.setLocalizedText((JLabel)this.lblName, (String)NbBundle.getBundle(IntroduceMethodPanel.class).getString("IntroduceMethodPanel.lblName.text"));
        this.name.setColumns(20);
        this.returnTypeLabel.setLabelFor(this.returnTypeTextField);
        Mnemonics.setLocalizedText((JLabel)this.returnTypeLabel, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"IntroduceMethodPanel.returnTypeLabel.text"));
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.returnTypeLabel, -1, -1, Short.MAX_VALUE).addComponent(this.lblName, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.name, -1, 362, Short.MAX_VALUE).addComponent(this.returnTypeTextField))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(5, 5, 5).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.name, -2, -1, -2).addComponent(this.lblName)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.returnTypeTextField, -2, -1, -2).addComponent(this.returnTypeLabel, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.modifiersPanel.setLayout(new GridBagLayout());
        this.insertionPointLabel.setLabelFor(this.insertPointCombo);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/refactoring/introduce/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.insertionPointLabel, (String)bundle.getString("LBL_InsertPoint"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.modifiersPanel.add((Component)this.insertionPointLabel, gridBagConstraints);
        this.insertPointCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceMethodPanel.this.insertPointComboActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 12, 0, 0);
        this.modifiersPanel.add((Component)this.insertPointCombo, gridBagConstraints);
        this.insertPointCombo.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_modifiersCombo"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.modifiersPanel, gridBagConstraints);
        this.eastPanel.setLayout(new GridBagLayout());
        this.buttonsPanel.setBorder(BorderFactory.createEmptyBorder(1, 11, 1, 1));
        this.buttonsPanel.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)bundle.getString("LBL_ChangeParsMoveUp"));
        this.moveUpButton.setEnabled(false);
        this.moveUpButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceMethodPanel.this.moveUpButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        this.buttonsPanel.add((Component)this.moveUpButton, gridBagConstraints);
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsMoveUp"));
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)bundle.getString("LBL_ChangeParsMoveDown"));
        this.moveDownButton.setEnabled(false);
        this.moveDownButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                IntroduceMethodPanel.this.moveDownButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.buttonsPanel.add((Component)this.moveDownButton, gridBagConstraints);
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_ChangeParsMoveDown"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.eastPanel.add((Component)this.buttonsPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.eastPanel.add((Component)this.fillPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.eastPanel, gridBagConstraints);
        this.westPanel.setPreferredSize(new Dimension(453, 100));
        this.paramTable.setModel(this.model);
        this.initRenderer();
        this.paramTable.getSelectionModel().addListSelectionListener(this.getListener1());
        this.paramTable.getSelectionModel().setSelectionMode(1);
        this.model.addTableModelListener(this.getListener2());
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(32, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getInputMap().put(KeyStroke.getKeyStroke(113, 0), ACTION_INLINE_EDITOR);
        this.paramTable.getActionMap().put(ACTION_INLINE_EDITOR, this.getEditAction());
        this.paramTable.setSurrendersFocusOnKeystroke(true);
        this.paramTable.setCellSelectionEnabled(false);
        this.paramTable.setRowSelectionAllowed(true);
        this.paramTable.putClientProperty("JTable.autoStartsEdit", Boolean.FALSE);
        this.paramTable.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        this.westPanel.setViewportView(this.paramTable);
        this.paramTable.getAccessibleContext().setAccessibleDescription(bundle.getString("ACSD_paramTable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.westPanel, gridBagConstraints);
        this.paramTitle.setHorizontalAlignment(2);
        this.paramTitle.setLabelFor(this.paramTable);
        Mnemonics.setLocalizedText((JLabel)this.paramTitle, (String)bundle.getString("LBL_ChangeParsParameters"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.add((Component)this.paramTitle, gridBagConstraints);
        this.previewChange.setLabelFor(this.previewEditorPane);
        Mnemonics.setLocalizedText((JLabel)this.previewChange, (String)NbBundle.getMessage(IntroduceMethodPanel.class, (String)"LBL_ChangeParsPreview"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(11, 0, 0, 0);
        this.add((Component)this.previewChange, gridBagConstraints);
        this.jScrollPane1.setPreferredSize(new Dimension(110, 70));
        this.previewEditorPane.setEditable(false);
        this.jScrollPane1.setViewportView(this.previewEditorPane);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.3;
        this.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        this.add((Component)this.errorLabel, gridBagConstraints);
    }

    private void insertPointComboActionPerformed(ActionEvent evt) {
        this.updateSignaturePreview();
    }

    private void moveDownButtonActionPerformed(ActionEvent evt) {
        this.doMove(1);
    }

    private void moveUpButtonActionPerformed(ActionEvent evt) {
        this.doMove(-1);
    }

    private ListSelectionListener getListener1() {
        return new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                if (!lsm.isSelectionEmpty()) {
                    int minIndex = lsm.getMinSelectionIndex();
                    int maxIndex = lsm.getMaxSelectionIndex();
                    IntroduceMethodPanel.this.setButtons(minIndex, maxIndex);
                } else {
                    IntroduceMethodPanel.this.moveDownButton.setEnabled(false);
                    IntroduceMethodPanel.this.moveUpButton.setEnabled(false);
                }
            }
        };
    }

    private TableModelListener getListener2() {
        return new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                int[] selectedRows = IntroduceMethodPanel.this.paramTable.getSelectedRows();
                if (selectedRows.length > 0) {
                    int min = selectedRows[0];
                    int max = selectedRows[selectedRows.length - 1];
                    IntroduceMethodPanel.this.setButtons(min, max);
                }
                IntroduceMethodPanel.this.updateSignaturePreview();
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTableData() {
        boolean isC = this.res.isC();
        CsmCacheManager.enter();
        try {
            for (IntroduceMethodRefactoring.VariableContext info : this.res.getImportantVariables()) {
                this.model.addRow(IntroduceMethodPanel.getParameterRow(info, isC));
            }
        }
        finally {
            CsmCacheManager.leave();
        }
    }

    private static Object[] getParameterRow(IntroduceMethodRefactoring.VariableContext info, boolean isC) {
        CsmVariable variable = info.getVariable();
        CsmType desc = variable.getType();
        if (isC) {
            CsmClassifier classifier;
            CharSequence typeText = CsmInstantiationProvider.getDefault().getInstantiatedText(desc);
            if (isC && (classifier = desc.getClassifier()) != null && classifier.getKind() == CsmDeclaration.Kind.STRUCT && !CharSequenceUtils.startsWith((CharSequence)typeText, (CharSequence)"struct")) {
                typeText = "struct " + typeText;
            }
            String typeRepresentation = typeText.toString();
            return new Object[]{info.isWriteAccessInside(), variable.getName().toString(), typeRepresentation};
        }
        if (desc.isReference()) {
            CsmTypes.TypeDescriptor typeDescriptor = new CsmTypes.TypeDescriptor(desc.isConst(), desc.isVolatile(), 0, desc.getPointerDepth(), desc.getArrayDepth());
            CsmType createType = CsmTypes.createType((CsmType)desc, (CsmTypes.TypeDescriptor)typeDescriptor);
            return new Object[]{true, variable.getName().toString(), createType.getCanonicalText().toString()};
        }
        if (desc.getArrayDepth() > 0) {
            CsmTypes.TypeDescriptor typeDescriptor = new CsmTypes.TypeDescriptor(false, desc.isVolatile(), 0, desc.getPointerDepth(), desc.getArrayDepth());
            CsmType createType = CsmTypes.createType((CsmType)desc, (CsmTypes.TypeDescriptor)typeDescriptor);
            return new Object[]{false, variable.getName().toString(), createType.getCanonicalText().toString()};
        }
        CsmTypes.TypeDescriptor typeDescriptor = new CsmTypes.TypeDescriptor(desc.isConst(), desc.isVolatile(), 0, desc.getPointerDepth(), desc.getArrayDepth());
        CsmType createType = CsmTypes.createType((CsmType)desc, (CsmTypes.TypeDescriptor)typeDescriptor);
        if (desc.isBuiltInBased(true) && !info.isWriteAccessInside()) {
            return new Object[]{false, variable.getName().toString(), createType.getCanonicalText().toString()};
        }
        if (desc.isPointer() && !info.isWriteAccessInside()) {
            return new Object[]{false, variable.getName().toString(), createType.getCanonicalText().toString()};
        }
        return new Object[]{true, variable.getName().toString(), createType.getCanonicalText().toString()};
    }

    private boolean acceptEditedValue() {
        TableCellEditor tce = this.paramTable.getCellEditor();
        if (tce != null) {
            return this.paramTable.getCellEditor().stopCellEditing();
        }
        return false;
    }

    private void doMove(int step) {
        this.acceptEditedValue();
        ListSelectionModel selectionModel = this.paramTable.getSelectionModel();
        int min = selectionModel.getMinSelectionIndex();
        int max = selectionModel.getMaxSelectionIndex();
        selectionModel.clearSelection();
        this.model.moveRow(min, max, min + step);
        selectionModel.addSelectionInterval(min + step, max + step);
    }

    private void setButtons(int min, int max) {
        int r = this.model.getRowCount() - 1;
        this.moveUpButton.setEnabled(min > 0);
        this.moveDownButton.setEnabled(max < r);
    }

    private void initRenderer() {
        TableColumnModel tcm = this.paramTable.getColumnModel();
        Enumeration<TableColumn> columns = this.paramTable.getColumnModel().getColumns();
        int i = 0;
        while (columns.hasMoreElements()) {
            TableColumn tc = columns.nextElement();
            switch (i) {
                case 0: {
                    tc.setPreferredWidth(40);
                    tc.setMaxWidth(60);
                    break;
                }
                case 1: {
                    tc.setPreferredWidth(100);
                    break;
                }
                case 2: {
                    tc.setPreferredWidth(200);
                    break;
                }
            }
            ++i;
        }
        this.paramTable.setDefaultRenderer(String.class, new ParamRenderer());
        this.paramTable.setDefaultRenderer(Boolean.class, new UIUtilities.BooleanTableCellRenderer());
    }

    String getMethodDefinition() {
        try {
            String text = this.res.getDocument().getText(this.res.getSelectionFrom(), this.res.getSelectionTo() - this.res.getSelectionFrom());
            ArrayList<Diff> diffs = new ArrayList<Diff>();
            if (this.res.isC()) {
                Vector<Vector> data = this.model.getDataVector();
                List[] parameters = data.toArray(new List[0]);
                for (int i = 0; i < parameters.length; ++i) {
                    if (!((Boolean)parameters[i].get(0)).booleanValue()) continue;
                    String name = (String)parameters[i].get(1);
                    for (IntroduceMethodRefactoring.VariableContext varInfo : this.res.getImportantVariables()) {
                        if (!name.equals(varInfo.getVariable().getName().toString())) continue;
                        for (CsmReference reference : varInfo.getReferences()) {
                            if (this.res.getSelectionFrom() > reference.getStartOffset() || reference.getEndOffset() > this.res.getSelectionTo()) continue;
                            diffs.add(new Diff(reference.getStartOffset() - this.res.getSelectionFrom(), name.length(), "(*" + name + ")"));
                        }
                    }
                }
            }
            if (diffs.size() > 0) {
                Collections.sort(diffs);
                StringBuilder buf = new StringBuilder(text);
                for (Diff diff : diffs) {
                    buf.replace(diff.start, diff.start + diff.len, diff.to);
                }
                text = buf.toString();
            }
            return "\n" + this.genDeclarationString() + "{\n" + text + "\n}\n";
        }
        catch (BadLocationException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return "";
        }
    }

    int getInsertPoint() {
        if (this.res.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDefinition) {
            CsmFunction functionDeclaration = this.res.getFunctionDeclaration();
            InsertPoint insertPoint = (InsertPoint)this.insertPointCombo.getSelectedItem();
            if (insertPoint.getContainerClass() == null) {
                return functionDeclaration.getEndOffset();
            }
            if (insertPoint.getIndex() == Integer.MIN_VALUE) {
                return insertPoint.getContainerClass().getLeftBracketOffset() + 1;
            }
            if (insertPoint.getIndex() == Integer.MAX_VALUE) {
                return insertPoint.getContainerClass().getEndOffset() - 1;
            }
            return insertPoint.getElementDeclaration().getEndOffset();
        }
        return 0;
    }

    String getFunctionName() {
        return this.name.getText();
    }

    String getMethodCall() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.name.getText());
        buf.append('(');
        Vector<Vector> data = this.model.getDataVector();
        List[] parameters = data.toArray(new List[0]);
        for (int i = 0; i < parameters.length; ++i) {
            if (((Boolean)parameters[i].get(0)).booleanValue() && this.res.isC()) {
                buf.append('&');
            }
            buf.append(parameters[i].get(1));
            if (i >= parameters.length - 1) continue;
            buf.append(',').append(' ');
        }
        buf.append(')');
        buf.append(';');
        return buf.toString();
    }

    private void updateSignaturePreview() {
        this.previewEditorPane.setText(this.genWrapDeclarationString());
        this.previewEditorPane.setCaretPosition(0);
    }

    private String genWrapDeclarationString() {
        String decl = this.genDeclarationString();
        StringBuilder buf = new StringBuilder();
        int col = 0;
        for (int i = 0; i < decl.length(); ++i) {
            buf.append(decl.charAt(i));
            if (++col <= 50 || decl.charAt(i) != ',') continue;
            buf.append('\n');
            col = 0;
        }
        return buf.toString();
    }

    private String genDeclarationString() {
        StringBuilder buf = new StringBuilder();
        if (this.res.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.Function || this.res.getFunctionKind() == IntroduceMethodRefactoring.IntroduceMethodContext.FunctionKind.MethodDeclarationDefinition) {
            buf.append(this.returnTypeTextField.getText());
            buf.append(' ');
        } else {
            IntroduceMethodPanel.createDefinitionQualifiedName(this.res.getFunctionDeclaration(), this.res.getEnclosingClass(), this.returnTypeTextField.getText(), this.res.getInsertScope(), buf);
        }
        buf.append(this.name.getText());
        buf.append('(');
        Vector<Vector> data = this.model.getDataVector();
        List[] parameters = data.toArray(new List[0]);
        for (int i = 0; i < parameters.length; ++i) {
            buf.append(parameters[i].get(2));
            if (((Boolean)parameters[i].get(0)).booleanValue()) {
                if (this.res.isC()) {
                    buf.append('*');
                } else {
                    buf.append('&');
                }
            }
            buf.append(' ');
            buf.append(parameters[i].get(1));
            if (i >= parameters.length - 1) continue;
            buf.append(',').append(' ');
        }
        buf.append(')');
        return buf.toString();
    }

    String getMethodDeclarationString() {
        StringBuilder buf = new StringBuilder("\n");
        buf.append(this.returnTypeTextField.getText());
        buf.append(' ');
        buf.append(this.name.getText());
        buf.append('(');
        Vector<Vector> data = this.model.getDataVector();
        List[] parameters = data.toArray(new List[0]);
        for (int i = 0; i < parameters.length; ++i) {
            buf.append(parameters[i].get(2));
            if (((Boolean)parameters[i].get(0)).booleanValue()) {
                if (this.res.isC()) {
                    buf.append('*');
                } else {
                    buf.append('&');
                }
            }
            buf.append(' ');
            buf.append(parameters[i].get(1));
            if (i >= parameters.length - 1) continue;
            buf.append(',').append(' ');
        }
        buf.append(");\n");
        return buf.toString();
    }

    private static void createDefinitionQualifiedName(CsmFunction item, CsmClass parent, String returnType, CsmScope insertScope, StringBuilder buf) {
        CsmTemplate template;
        List templateParameters;
        IntroduceMethodPanel.addTemplate(item, parent, buf);
        buf.append(returnType);
        buf.append(' ');
        String scope = IntroduceMethodPanel.getQualifiedName(insertScope, (CsmScope)parent);
        if (scope.isEmpty()) {
            buf.append(parent.getName());
        } else {
            buf.append(scope);
        }
        if (CsmKindUtilities.isTemplate((CsmObject)parent) && (templateParameters = (template = (CsmTemplate)parent).getTemplateParameters()).size() > 0) {
            buf.append("<");
            boolean first = true;
            for (CsmTemplateParameter param : templateParameters) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(param.getName());
            }
            buf.append(">");
        }
        buf.append("::");
    }

    private static String getQualifiedName(CsmScope from, CsmScope to) {
        ArrayList<CsmScope> scopes = new ArrayList<CsmScope>();
        while (!Objects.equals(from, to) && CsmKindUtilities.isScopeElement((CsmObject)to)) {
            scopes.add(0, to);
            to = ((CsmScopeElement)to).getScope();
        }
        boolean first = true;
        StringBuilder sb = new StringBuilder();
        for (CsmScope scope : scopes) {
            CsmNamedElement named;
            if (!CsmKindUtilities.isNamedElement((CsmObject)scope) || CharSequenceUtils.isNullOrEmpty((CharSequence)(named = (CsmNamedElement)scope).getName())) continue;
            if (!first) {
                sb.append("::");
            } else {
                first = false;
            }
            sb.append(named.getName());
        }
        return sb.toString();
    }

    private static void addTemplate(CsmFunction item, CsmClass parent, StringBuilder buf) {
        boolean first;
        CsmTemplate template;
        List templateParameters;
        if (CsmKindUtilities.isTemplate((CsmObject)parent) && (templateParameters = (template = (CsmTemplate)parent).getTemplateParameters()).size() > 0) {
            buf.append("template<");
            first = true;
            for (CsmTemplateParameter param : templateParameters) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(param.getText());
            }
            buf.append(">\n");
        }
        if (CsmKindUtilities.isTemplate((CsmObject)item) && (templateParameters = (template = (CsmTemplate)item).getTemplateParameters()).size() > 0) {
            buf.append("template<");
            first = true;
            for (CsmTemplateParameter param : templateParameters) {
                if (!first) {
                    buf.append(", ");
                }
                first = false;
                buf.append(param.getText());
            }
            buf.append(">\n");
        }
    }

    private static String getString(String key) {
        return NbBundle.getMessage(IntroduceMethodPanel.class, (String)key);
    }

    private Action getEditAction() {
        if (editAction == null) {
            editAction = new EditAction();
        }
        return editAction;
    }

    private void autoEdit(JTable tab) {
        if (tab.editCellAt(tab.getSelectedRow(), tab.getSelectedColumn(), null) && tab.getEditorComponent() != null) {
            if (tab.getEditorComponent() instanceof JTextField) {
                JTextField field = (JTextField)tab.getEditorComponent();
                field.setCaretPosition(field.getText().length());
                field.requestFocusInWindow();
                field.selectAll();
            } else if (tab.getEditorComponent() instanceof JCheckBox) {
                JCheckBox field;
                field.setSelected(!(field = (JCheckBox)tab.getEditorComponent()).isSelected());
            }
        }
    }

    private static class Diff
    implements Comparable<Diff> {
        private int start;
        private int len;
        private String to;

        public Diff(int start, int len, String to) {
            this.start = start;
            this.len = len;
            this.to = to;
        }

        @Override
        public int compareTo(Diff o) {
            return o.start - this.start;
        }
    }

    private class ParamRenderer
    extends DefaultTableCellRenderer
    implements TableCellRenderer {
        private final Color origBackground;
        private final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);

        public ParamRenderer() {
            this.setOpaque(true);
            this.origBackground = this.getBackground();
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!isSelected) {
                this.setBackground(this.origBackground);
            }
            this.setBorder(hasFocus ? UIManager.getBorder("Table.focusCellHighlightBorder") : this.noFocusBorder);
            return this;
        }
    }

    private class EditAction
    extends AbstractAction {
        private EditAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ae) {
            IntroduceMethodPanel.this.autoEdit((JTable)ae.getSource());
        }
    }

    private static class ParamTableModel
    extends DefaultTableModel {
        public ParamTableModel(Object[] data, int rowCount) {
            super(data, rowCount);
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (column == 0) {
                return true;
            }
            if (column == 1) {
                return false;
            }
            return column == 2;
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public void setValueAt(Object aValue, int row, int column) {
            if ((column == 1 || column == 2) && aValue instanceof String) {
                aValue = ((String)aValue).trim();
            }
            super.setValueAt(aValue, row, column);
        }
    }
}

