/*
 * Decompiled with CFR 0.152.
 */
package org.clang.frontend.impl;

import org.clang.basic.BasicClangGlobals;
import org.clang.basic.CharSourceRange;
import org.clang.basic.DiagnosticOptions;
import org.clang.basic.FileID;
import org.clang.basic.FixItHint;
import org.clang.basic.LangOptions;
import org.clang.basic.SourceLocation;
import org.clang.basic.SourceManager;
import org.clang.frontend.impl.SourceColumnMap;
import org.clang.lex.Lexer;
import org.clank.java.std;
import org.clank.java.std_pair;
import org.clank.support.Native;
import org.clank.support.NativeCallback;
import org.clank.support.NativeCloneable;
import org.clank.support.NativePointer;
import org.clank.support.abstract_iterator;
import org.clank.support.aliases.bool;
import org.clank.support.aliases.char;
import org.clank.support.aliases.int;
import org.clank.support.aliases.type;
import org.clank.support.aliases.uint;
import org.llvm.adt.SmallString;
import org.llvm.adt.StringRef;
import org.llvm.adt.aliases.ArrayRef;
import org.llvm.adt.aliases.SmallVectorImplInt;
import org.llvm.support.ConvertUTFGlobals;
import org.llvm.support.llvm;
import org.llvm.support.raw_ostream;
import org.llvm.support.sys.locale;

public final class TextDiagnosticStatics {
    public static raw_ostream.Colors noteColor = raw_ostream.Colors.BLACK;
    public static raw_ostream.Colors remarkColor = raw_ostream.Colors.BLUE;
    public static raw_ostream.Colors fixitColor = raw_ostream.Colors.GREEN;
    public static raw_ostream.Colors caretColor = raw_ostream.Colors.GREEN;
    public static raw_ostream.Colors warningColor = raw_ostream.Colors.MAGENTA;
    public static raw_ostream.Colors templateColor = raw_ostream.Colors.CYAN;
    public static raw_ostream.Colors errorColor = raw_ostream.Colors.RED;
    public static raw_ostream.Colors fatalColor = raw_ostream.Colors.RED;
    public static raw_ostream.Colors savedColor = raw_ostream.Colors.SAVEDCOLOR;
    public static int WordWrapIndentation = 6;

    public static void applyTemplateHighlighting(raw_ostream OS, StringRef Str, bool.ref Normal, boolean Bold) {
        while (true) {
            int Pos = Str.find(BasicClangGlobals.ToggleHighlight);
            OS.$out(Str.slice(0, Pos));
            if (Pos == StringRef.npos) break;
            Str.$assign$substr(Pos + 1);
            if (Normal.$deref()) {
                OS.changeColor(templateColor, true);
            } else {
                OS.resetColor();
                if (Bold) {
                    OS.changeColor(savedColor, true);
                }
            }
            Normal.$set(!Normal.$deref());
        }
    }

    public static int bytesSincePreviousTabOrLineBegin(StringRef SourceLine, int i) {
        int bytes = 0;
        while (0 < i && SourceLine.$at(--i) != 9) {
            ++bytes;
        }
        return bytes;
    }

    public static std_pair.pairTypeBool<SmallString> printableTextForNextCharacter(StringRef SourceLine, int.ptr i, int TabStop) {
        char.ptr end;
        assert (i != null) : "i must not be null";
        assert (i.$star() < SourceLine.size()) : "must point to a valid index";
        if (SourceLine.$at(i.$star()) == 9) {
            assert (0 < TabStop && TabStop <= DiagnosticOptions.Unnamed_enum1.MaxTabStop.getValue()) : "Invalid -ftabstop value";
            int col = TextDiagnosticStatics.bytesSincePreviousTabOrLineBegin(SourceLine, i.$star());
            int NumSpaces = TabStop - col % TabStop;
            assert (0 < NumSpaces && NumSpaces <= TabStop) : "Invalid computation of space amt";
            i.$set$preInc(0);
            SmallString expandedTab = new SmallString(16);
            expandedTab.assign(NumSpaces, ' ');
            return std.make_pair_T_bool((Object)expandedTab, (boolean)true);
        }
        char.ptr begin = (char.ptr)SourceLine.begin().$add(i.$star());
        if (ConvertUTFGlobals.isLegalUTF8Sequence((char.ptr)begin, (char.ptr)(end = (char.ptr)begin.$add(SourceLine.size() - i.$star()))) != 0) {
            int c;
            int[] c_buf = NativePointer.new$uint$elem((int)0);
            uint.ptr cptr = NativePointer.create_uint$ptr((int[])c_buf);
            char.ptr original_begin = Native.$tryClone((char.ptr)begin);
            char.ptr cp_end = (char.ptr)begin.$add(ConvertUTFGlobals.getNumBytesForUTF8((byte)SourceLine.$at(i.$star())));
            ConvertUTFGlobals.ConversionResult res = ConvertUTFGlobals.ConvertUTF8toUTF32((type.ptr)begin.$addr(), (char.ptr)cp_end, (type.ptr)cptr.$addr(), (uint.ptr)((uint.ptr)cptr.$add(1)), (ConvertUTFGlobals.ConversionFlags)ConvertUTFGlobals.ConversionFlags.strictConversion);
            assert (ConvertUTFGlobals.ConversionResult.conversionOK == res);
            assert (0 < begin.$sub((abstract_iterator)original_begin)) : "we must be further along in the string now";
            i.$set$addassign(0, begin.$sub((abstract_iterator)original_begin));
            if (!locale.isPrint((int)c)) {
                SmallString expandedCP = new SmallString(new StringRef("<U+>"), 16);
                for (c = c_buf[0]; c != 0; c /= 16) {
                    expandedCP.insert(expandedCP.begin().$add(3), llvm.hexdigit((int)(c % 16)));
                }
                while (expandedCP.size() < 8) {
                    expandedCP.insert(expandedCP.begin().$add(3), llvm.hexdigit((int)0));
                }
                return std.make_pair_T_bool((Object)expandedCP, (boolean)false);
            }
            return std.make_pair_T_bool((Object)new SmallString((char.iterator)original_begin, (char.iterator)cp_end, 16), (boolean)true);
        }
        SmallString expandedByte = new SmallString(new StringRef("<XX>"), 16);
        short __byte = SourceLine.$at(i.$star());
        expandedByte.$set(1, llvm.hexdigit((int)(__byte / 16)));
        expandedByte.$set(2, llvm.hexdigit((int)(__byte % 16)));
        i.$set$preInc(0);
        return std.make_pair_T_bool((Object)expandedByte, (boolean)false);
    }

    public static void expandTabs(std.string SourceLine, int TabStop) {
        int i = SourceLine.size();
        while (i > 0) {
            if (SourceLine.$at(--i) != 9) continue;
            int.ptr tmp_i = NativePointer.create_int$ptr((int)i);
            std_pair.pairTypeBool<SmallString> res = TextDiagnosticStatics.printableTextForNextCharacter(new StringRef(SourceLine), tmp_i, TabStop);
            SourceLine.replace(i, 1, ((SmallString)res.first).c_str());
        }
    }

    public static void byteToColumn(StringRef SourceLine, int TabStop, SmallVectorImplInt out) {
        out.clear();
        if (SourceLine.empty()) {
            out.resize(1, 0);
            return;
        }
        out.resize(SourceLine.size() + 1, -1);
        int columns = 0;
        int.ptr i = NativePointer.create_int$ptr((int)0);
        while (i.$star() < SourceLine.size()) {
            out.$set(i.$star(), columns);
            std_pair.pairTypeBool<SmallString> res = TextDiagnosticStatics.printableTextForNextCharacter(SourceLine, i, TabStop);
            columns += locale.columnWidth((StringRef)((SmallString)res.first).$StringRef());
        }
        out.ref$back().$set(columns);
    }

    public static void columnToByte(StringRef SourceLine, int TabStop, SmallVectorImplInt out) {
        out.clear();
        if (SourceLine.empty()) {
            out.resize(1, 0);
            return;
        }
        int columns = 0;
        int.ptr i = NativePointer.create_int$ptr((int)0);
        while (i.$star() < SourceLine.size()) {
            out.resize(columns + 1, -1);
            out.ref$back().$set(i.$star());
            std_pair.pairTypeBool<SmallString> res = TextDiagnosticStatics.printableTextForNextCharacter(SourceLine, i, TabStop);
            columns += locale.columnWidth((StringRef)((SmallString)res.first).$StringRef());
        }
        out.resize(columns + 1, -1);
        out.ref$back().$set(i.$star());
    }

    public static void selectInterestingSourceRegion(std.string SourceLine, std.string CaretLine, std.string FixItInsertionLine, int Columns, SourceColumnMap map2) {
        int CaretStart;
        int CaretColumns = CaretLine.size();
        int FixItColumns = locale.columnWidth((StringRef)new StringRef(FixItInsertionLine));
        int MaxColumns = std.max((int)map2.columns(), (int)std.max((int)CaretColumns, (int)FixItColumns));
        if (MaxColumns <= Columns) {
            return;
        }
        assert (std.$eq___normal_iterator((abstract_iterator)CaretLine.end(), (abstract_iterator)std.find_if((char.iterator)CaretLine.begin(), (char.iterator)CaretLine.end(), (NativeCallback.CharBoolPredicate)new NativeCallback.CharBoolPredicate(){

            public boolean $call(byte c) {
                return c < 32 || 126 < c;
            }
        })));
        int CaretEnd = CaretLine.size();
        for (CaretStart = 0; CaretStart != CaretEnd && BasicClangGlobals.isWhitespace((byte)CaretLine.$at(CaretStart)); ++CaretStart) {
        }
        while (CaretEnd != CaretStart && BasicClangGlobals.isWhitespace((byte)CaretLine.$at(CaretEnd - 1))) {
            --CaretEnd;
        }
        if (!FixItInsertionLine.empty()) {
            int FixItStart;
            int FixItEnd = FixItInsertionLine.size();
            for (FixItStart = 0; FixItStart != FixItEnd && BasicClangGlobals.isWhitespace((byte)FixItInsertionLine.$at(FixItStart)); ++FixItStart) {
            }
            while (FixItEnd != FixItStart && BasicClangGlobals.isWhitespace((byte)FixItInsertionLine.$at(FixItEnd - 1))) {
                --FixItEnd;
            }
            int FixItStartCol = FixItStart;
            int FixItEndCol = locale.columnWidth((StringRef)new StringRef(FixItInsertionLine.substr(0, FixItEnd)));
            CaretStart = std.min((int)FixItStartCol, (int)CaretStart);
            CaretEnd = std.max((int)FixItEndCol, (int)CaretEnd);
        }
        while (CaretEnd < map2.columns() && -1 == map2.columnToByte(CaretEnd)) {
            ++CaretEnd;
        }
        assert (CaretStart > map2.columns() || -1 != map2.columnToByte(CaretStart)) : "CaretStart must not point to a column in the middle of a source line character";
        assert (CaretEnd > map2.columns() || -1 != map2.columnToByte(CaretEnd)) : "CaretEnd must not point to a column in the middle of a source line character";
        int SourceStart = map2.columnToByte(std.min((int)CaretStart, (int)map2.columns()));
        int SourceEnd = map2.columnToByte(std.min((int)CaretEnd, (int)map2.columns()));
        int CaretColumnsOutsideSource = CaretEnd - CaretStart - (map2.byteToColumn(SourceEnd) - map2.byteToColumn(SourceStart));
        String front_ellipse = "  ...";
        String front_space = "     ";
        String back_ellipse = "...";
        int TargetColumns = Columns;
        int ellipses_space = std.strlen((CharSequence)front_ellipse) + std.strlen((CharSequence)back_ellipse);
        if (TargetColumns > ellipses_space + CaretColumnsOutsideSource) {
            TargetColumns -= ellipses_space + CaretColumnsOutsideSource;
        }
        while (SourceStart > 0 || SourceEnd < SourceLine.size()) {
            int NewColumns;
            boolean ExpandedRegion = false;
            if (SourceStart > 0) {
                int Prev;
                int NewStart = map2.startOfPreviousColumn(SourceStart);
                while (NewStart != 0 && BasicClangGlobals.isWhitespace((byte)SourceLine.$at(NewStart))) {
                    NewStart = map2.startOfPreviousColumn(NewStart);
                }
                while (NewStart != 0 && !BasicClangGlobals.isWhitespace((byte)SourceLine.$at(Prev = map2.startOfPreviousColumn(NewStart)))) {
                    NewStart = Prev;
                }
                assert (map2.byteToColumn(NewStart) != -1);
                NewColumns = map2.byteToColumn(SourceEnd) - map2.byteToColumn(NewStart);
                if (NewColumns <= TargetColumns) {
                    SourceStart = NewStart;
                    ExpandedRegion = true;
                }
            }
            if (SourceEnd < SourceLine.size()) {
                int NewEnd = map2.startOfNextColumn(SourceEnd);
                while (NewEnd < SourceLine.size() && BasicClangGlobals.isWhitespace((byte)SourceLine.$at(NewEnd))) {
                    NewEnd = map2.startOfNextColumn(NewEnd);
                }
                while (NewEnd < SourceLine.size() && BasicClangGlobals.isWhitespace((byte)SourceLine.$at(NewEnd))) {
                    NewEnd = map2.startOfNextColumn(NewEnd);
                }
                assert (map2.byteToColumn(NewEnd) != -1);
                NewColumns = map2.byteToColumn(NewEnd) - map2.byteToColumn(SourceStart);
                if (NewColumns <= TargetColumns) {
                    SourceEnd = NewEnd;
                    ExpandedRegion = true;
                }
            }
            if (ExpandedRegion) continue;
            break;
        }
        CaretStart = map2.byteToColumn(SourceStart);
        CaretEnd = map2.byteToColumn(SourceEnd) + CaretColumnsOutsideSource;
        assert (CaretStart != -1 && CaretEnd != -1 && SourceStart != -1 && SourceEnd != -1);
        assert (SourceStart <= SourceEnd);
        assert (CaretStart <= CaretEnd);
        int BackColumnsRemoved = map2.byteToColumn(SourceLine.size()) - map2.byteToColumn(SourceEnd);
        int FrontColumnsRemoved = CaretStart;
        int ColumnsKept = CaretEnd - CaretStart;
        assert (FrontColumnsRemoved + ColumnsKept + BackColumnsRemoved > Columns);
        if (BackColumnsRemoved > std.strlen((CharSequence)back_ellipse)) {
            SourceLine.replace(SourceEnd, std.string.npos, (CharSequence)back_ellipse);
        }
        if (FrontColumnsRemoved + ColumnsKept <= Columns) {
            return;
        }
        if (FrontColumnsRemoved > std.strlen((CharSequence)front_ellipse)) {
            SourceLine.replace(0, SourceStart, (CharSequence)front_ellipse);
            CaretLine.replace(0, CaretStart, (CharSequence)front_space);
            if (!FixItInsertionLine.empty()) {
                FixItInsertionLine.replace(0, CaretStart, (CharSequence)front_space);
            }
        }
    }

    public static int skipWhitespace(int Idx, StringRef Str, int Length) {
        while (Idx < Length && BasicClangGlobals.isWhitespace((byte)Str.$at(Idx))) {
            ++Idx;
        }
        return Idx;
    }

    public static byte findMatchingPunctuation(byte c) {
        switch (c) {
            case 39: {
                return 39;
            }
            case 96: {
                return 39;
            }
            case 34: {
                return 34;
            }
            case 40: {
                return 41;
            }
            case 91: {
                return 93;
            }
            case 123: {
                return 125;
            }
        }
        return 0;
    }

    public static int findEndOfWord(int Start, StringRef Str, int Length, int Column, int Columns) {
        assert (Start < Str.size()) : "Invalid start position!";
        int End = Start + 1;
        if (End == Str.size()) {
            return End;
        }
        byte EndPunct = TextDiagnosticStatics.findMatchingPunctuation(Str.$at(Start));
        if (EndPunct == 0) {
            while (End < Length && !BasicClangGlobals.isWhitespace((byte)Str.$at(End))) {
                ++End;
            }
            return End;
        }
        SmallString PunctuationEndStack = new SmallString(16);
        PunctuationEndStack.push_back(EndPunct);
        while (End < Length && !PunctuationEndStack.empty()) {
            if (Str.$at(End) == PunctuationEndStack.back()) {
                PunctuationEndStack.pop_back();
            } else {
                byte SubEndPunct = TextDiagnosticStatics.findMatchingPunctuation(Str.$at(End));
                if (SubEndPunct != 0) {
                    PunctuationEndStack.push_back(SubEndPunct);
                }
            }
            ++End;
        }
        while (End < Length && !BasicClangGlobals.isWhitespace((byte)Str.$at(End))) {
            ++End;
        }
        int PunctWordLength = End - Start;
        if (Column + PunctWordLength <= Columns || PunctWordLength < Columns / 3) {
            return End;
        }
        return TextDiagnosticStatics.findEndOfWord(Start + 1, Str, Length, Column + 1, Columns);
    }

    public static boolean printWordWrapped(raw_ostream OS, StringRef Str, int Columns) {
        return TextDiagnosticStatics.printWordWrapped(OS, Str, Columns, 0, false, WordWrapIndentation);
    }

    public static boolean printWordWrapped(raw_ostream OS, StringRef Str, int Columns, int Column) {
        return TextDiagnosticStatics.printWordWrapped(OS, Str, Columns, Column, false, WordWrapIndentation);
    }

    public static boolean printWordWrapped(raw_ostream OS, StringRef Str, int Columns, int Column, boolean Bold) {
        return TextDiagnosticStatics.printWordWrapped(OS, Str, Columns, Column, Bold, WordWrapIndentation);
    }

    public static boolean printWordWrapped(raw_ostream OS, StringRef Str, int Columns, int Column, boolean Bold, int Indentation) {
        int Length = std.min((int)Str.find(NativePointer.$((char)'\n')), (int)Str.size());
        bool.ref TextNormal = NativePointer.create_bool$ref((boolean)true);
        SmallString IndentStr = new SmallString(16);
        IndentStr.assign(Indentation, ' ');
        boolean Wrapped = false;
        int WordStart = 0;
        while (WordStart < Length && (WordStart = TextDiagnosticStatics.skipWhitespace(WordStart, Str, Length)) != Length) {
            int WordEnd = TextDiagnosticStatics.findEndOfWord(WordStart, Str, Length, Column, Columns);
            int WordLength = WordEnd - WordStart;
            if (Column + WordLength < Columns) {
                if (WordStart != 0) {
                    OS.$out_char((byte)32);
                    ++Column;
                }
                TextDiagnosticStatics.applyTemplateHighlighting(OS, Str.substr(WordStart, WordLength), TextNormal, Bold);
                Column += WordLength;
            } else {
                OS.$out_char((byte)10);
                OS.write(IndentStr.data(), Indentation);
                TextDiagnosticStatics.applyTemplateHighlighting(OS, Str.substr(WordStart, WordLength), TextNormal, Bold);
                Column = Indentation + WordLength;
                Wrapped = true;
            }
            WordStart = WordEnd;
        }
        TextDiagnosticStatics.applyTemplateHighlighting(OS, Str.substr(Length), TextNormal, Bold);
        assert (TextNormal.$deref()) : "Text highlighted at end of diagnostic message.";
        return Wrapped;
    }

    public static void highlightRange(CharSourceRange R, int LineNo, FileID FID, SourceColumnMap map2, std.string CaretLine, SourceManager SM, LangOptions LangOpts) {
        if (!R.isValid()) {
            return;
        }
        SourceLocation Begin = R.getBegin();
        SourceLocation End = R.getEnd();
        int StartLineNo = SM.getExpansionLineNumber(Begin);
        if (StartLineNo > LineNo || SM.getFileID(Begin).$noteq(FID)) {
            return;
        }
        int EndLineNo = SM.getExpansionLineNumber(End);
        if (EndLineNo < LineNo || SM.getFileID(End).$noteq(FID)) {
            return;
        }
        int StartColNo = 0;
        if (StartLineNo == LineNo && (StartColNo = SM.getExpansionColumnNumber(Begin)) != 0) {
            --StartColNo;
        }
        int EndColNo = map2.getSourceLine().size();
        if (EndLineNo == LineNo) {
            EndColNo = SM.getExpansionColumnNumber(End);
            if (EndColNo != 0) {
                --EndColNo;
                if (R.isTokenRange()) {
                    EndColNo += Lexer.MeasureTokenLength((SourceLocation)End, (SourceManager)SM, (LangOptions)LangOpts);
                }
            } else {
                EndColNo = CaretLine.size();
            }
        }
        assert (StartColNo <= EndColNo) : "Invalid range!";
        if (R.isTokenRange()) {
            while (StartColNo < map2.getSourceLine().size() && (map2.getSourceLine().$at(StartColNo) == NativePointer.$((char)' ') || map2.getSourceLine().$at(StartColNo) == 9)) {
                StartColNo = map2.startOfNextColumn(StartColNo);
            }
            if (EndColNo > map2.getSourceLine().size()) {
                EndColNo = map2.getSourceLine().size();
            }
            while (EndColNo != 0 && (map2.getSourceLine().$at(EndColNo - 1) == NativePointer.$((char)' ') || map2.getSourceLine().$at(EndColNo - 1) == 9)) {
                EndColNo = map2.startOfPreviousColumn(EndColNo);
            }
            assert (StartColNo <= EndColNo) : "Trying to highlight whitespace??";
        }
        assert (StartColNo <= map2.getSourceLine().size()) : "Invalid range!";
        assert (EndColNo <= map2.getSourceLine().size()) : "Invalid range!";
        StartColNo = map2.byteToContainingColumn(StartColNo);
        EndColNo = map2.byteToContainingColumn(EndColNo);
        assert (StartColNo <= EndColNo) : "Invalid range!";
        if (CaretLine.size() < EndColNo) {
            CaretLine.resize(EndColNo, ' ');
        }
        std.fill((char.iterator)((char.iterator)CaretLine.begin().$add(StartColNo)), (char.iterator)((char.iterator)CaretLine.begin().$add(EndColNo)), (char)'~');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static std.string buildFixItInsertionLine(int LineNo, SourceColumnMap map2, ArrayRef<FixItHint> Hints, SourceManager SM, DiagnosticOptions DiagOpts) {
        std.string FixItInsertionLine = null;
        try {
            FixItInsertionLine = new std.string();
            if (Hints.empty() || !DiagOpts.ShowFixits) {
                std.string string2 = FixItInsertionLine;
                return string2;
            }
            int PrevHintEndCol = 0;
            type.ptr I = (type.ptr)Native.$tryClone((NativeCloneable)Hints.begin());
            type.ptr E = (type.ptr)Native.$tryClone((NativeCloneable)Hints.end());
            while (I.$noteq((Object)E)) {
                if (!((FixItHint)I.$star()).CodeToInsert.empty()) {
                    long HintLocInfo = SM.getDecomposedExpansionLoc(((FixItHint)I.$star()).RemoveRange.getBegin().getRawEncoding());
                    if (LineNo == SM.getLineNumber(BasicClangGlobals.$first_FileID((long)HintLocInfo), std_pair.$second_int((long)HintLocInfo)) && new StringRef(((FixItHint)I.$star()).CodeToInsert).find_first_of(new StringRef("\n\r")) == StringRef.npos) {
                        int NewFixItLineSize;
                        int HintByteOffset = SM.getColumnNumber(BasicClangGlobals.$first_FileID((long)HintLocInfo), std_pair.$second_int((long)HintLocInfo)) - 1;
                        assert (HintByteOffset < map2.bytes() + 1);
                        int HintCol = map2.byteToContainingColumn(HintByteOffset);
                        if (HintCol < PrevHintEndCol) {
                            HintCol = PrevHintEndCol + 1;
                        }
                        if ((NewFixItLineSize = FixItInsertionLine.size() + (HintCol - PrevHintEndCol) + ((FixItHint)I.$star()).CodeToInsert.size()) > FixItInsertionLine.size()) {
                            FixItInsertionLine.resize(NewFixItLineSize, ' ');
                        }
                        std.copy((char.iterator)((FixItHint)I.$star()).CodeToInsert.begin(), (char.iterator)((FixItHint)I.$star()).CodeToInsert.end(), (char.iterator)((char.iterator)FixItInsertionLine.end().$sub(((FixItHint)I.$star()).CodeToInsert.size())));
                        PrevHintEndCol = HintCol + locale.columnWidth((StringRef)new StringRef(((FixItHint)I.$star()).CodeToInsert));
                    } else {
                        FixItInsertionLine.clear();
                        break;
                    }
                }
                I.$preInc();
            }
            TextDiagnosticStatics.expandTabs(FixItInsertionLine, DiagOpts.TabStop);
            std.string string3 = FixItInsertionLine;
            return string3;
        }
        finally {
            if (FixItInsertionLine != null) {
                FixItInsertionLine.$destroy();
            }
        }
    }
}

