/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.mapper;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.remote.mapper.HostMappingProvider;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

abstract class HostMappingProviderUnixAbstract
implements HostMappingProvider {
    private static final Logger log = RemoteUtil.LOGGER;
    private static final String NET = "/net/";
    private static final Pattern pattern = Pattern.compile("\t+| +");

    HostMappingProviderUnixAbstract() {
    }

    protected abstract String getShareCommand();

    protected abstract String fetchPath(String[] var1);

    @Override
    public Map<String, String> findMappings(ExecutionEnvironment execEnv, ExecutionEnvironment otherExecEnv) {
        ProcessUtils.ExitStatus exit;
        HashMap<String, String> mappings = new HashMap<String, String>();
        String hostName = execEnv.isLocal() ? HostMappingProviderUnixAbstract.getLocalHostName() : execEnv.getHost();
        log.log(Level.FINE, "Find Mappings for {0}", execEnv);
        if (hostName != null && (exit = ProcessUtils.execute((ExecutionEnvironment)execEnv, (String)this.getShareCommand(), (String[])new String[0])).isOK()) {
            List<String> paths = this.parseOutput(execEnv, new StringReader(exit.getOutputString()));
            for (String path : paths) {
                String host;
                log.log(Level.FINE, "Path {0}", path);
                assert (path != null && path.length() > 0 && path.charAt(0) == '/');
                String netPath = NET + hostName + path;
                if (HostInfoProvider.fileExists((ExecutionEnvironment)otherExecEnv, (String)netPath)) {
                    if (execEnv.isLocal()) {
                        log.log(Level.FINE, "{0}->{1}", new Object[]{path, netPath});
                        mappings.put(path, netPath);
                    } else {
                        log.log(Level.FINE, "{0}->{1}", new Object[]{netPath, path});
                        mappings.put(netPath, path);
                    }
                }
                if (mappings.containsKey(path) || !execEnv.isLocal() || (host = this.getIP()) == null || host.length() <= 0) continue;
                log.log(Level.FINE, "IP={0}", host);
                netPath = NET + host + path;
                if (!HostInfoProvider.fileExists((ExecutionEnvironment)otherExecEnv, (String)netPath)) continue;
                mappings.put(path, netPath);
                log.log(Level.FINE, "{0}->{1}", new Object[]{path, netPath});
            }
        }
        if (execEnv.isRemote()) {
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)execEnv);
                String userDir = hostInfo.getUserDir();
                if (RemotePathMap.isTheSame(execEnv, userDir, CndFileUtils.createLocalFile((String)userDir))) {
                    mappings.put(userDir, userDir);
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            catch (ConnectionManager.CancellationException cancellationException) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return mappings;
    }

    private String getIP() {
        try {
            return InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException ex) {
            RemoteUtil.LOGGER.log(Level.FINEST, "Exception when getting local host IP", ex);
            return null;
        }
    }

    private List<String> parseOutput(ExecutionEnvironment execEnv, Reader outputReader) {
        ArrayList<String> paths = new ArrayList<String>();
        try {
            BufferedReader reader = new BufferedReader(outputReader);
            String line = reader.readLine();
            while (line != null) {
                String path = this.fetchPath(pattern.split(line));
                if (path != null) {
                    if (CndPathUtilities.isPathAbsolute((CharSequence)path)) {
                        FileObject fo = FileSystemProvider.getFileObject((ExecutionEnvironment)execEnv, (String)path);
                        if (fo != null && fo.isValid()) {
                            paths.add(path);
                        }
                    } else if (!"smb".equals(path)) {
                        log.fine("The command `" + this.getShareCommand() + "` listed non-absolute path: " + path);
                    }
                }
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return paths;
    }

    private static String getLocalHostName() {
        String hostName = null;
        try {
            hostName = HostInfoUtils.getHostInfo((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal()).getHostname();
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (ConnectionManager.CancellationException cancellationException) {
            // empty catch block
        }
        return hostName;
    }
}

