/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.actions;

import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Future;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.api.extexecution.ExecutionDescriptor;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.actions.AbstractExecutorRunAction;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.RemoteSyncSupport;
import org.netbeans.modules.cnd.api.remote.RemoteSyncWorker;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetManager;
import org.netbeans.modules.cnd.api.toolchain.CompilerSetUtils;
import org.netbeans.modules.cnd.api.utils.ImportUtils;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.execution.ShellExecSupport;
import org.netbeans.modules.cnd.utils.CndPathUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.ui.ModalMessageDlg;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionListener;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionDescriptor;
import org.netbeans.modules.nativeexecution.api.execution.NativeExecutionService;
import org.netbeans.modules.nativeexecution.api.execution.PostMessageDisplayer;
import org.netbeans.modules.nativeexecution.api.util.LinkSupport;
import org.netbeans.modules.nativeexecution.api.util.MacroMap;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.LifecycleManager;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.windows.IOProvider;
import org.openide.windows.InputOutput;
import org.openide.windows.WindowManager;

public class ShellRunAction
extends AbstractExecutorRunAction {
    public String getName() {
        return ShellRunAction.getString("BTN_Run");
    }

    @Override
    protected boolean accept(DataObject object) {
        return object != null && object.getLookup().lookup(ShellExecSupport.class) != null;
    }

    protected void performAction(Node[] activatedNodes) {
        LifecycleManager.getDefault().saveAll();
        for (int i = 0; i < activatedNodes.length; ++i) {
            ShellRunAction.performAction(activatedNodes[i]);
        }
    }

    public static void performAction(Node node) {
        ShellRunAction.performAction(node, null, null, ShellRunAction.getProject(node), null);
    }

    public static Future<Integer> performAction(final Node node, final ExecutionListener listener, final Writer outputListener, final Project project, final InputOutput inputOutput) {
        if (SwingUtilities.isEventDispatchThread()) {
            ModalMessageDlg.LongWorker runner = new ModalMessageDlg.LongWorker(){
                private NativeExecutionService es;

                public void doWork() {
                    this.es = ShellRunAction.prepare(node, listener, outputListener, project, inputOutput);
                }

                public void doPostRunInEDT() {
                    if (this.es != null) {
                        this.es.run();
                    }
                }
            };
            Frame mainWindow = WindowManager.getDefault().getMainWindow();
            String title = ShellRunAction.getString("DLG_TITLE_Prepare", node.getName());
            String msg = ShellRunAction.getString("MSG_TITLE_Prepare", node.getName());
            ModalMessageDlg.runLongTask((Window)mainWindow, (String)title, (String)msg, (ModalMessageDlg.LongWorker)runner, null);
        } else {
            NativeExecutionService es = ShellRunAction.prepare(node, listener, outputListener, project, inputOutput);
            if (es != null) {
                return es.run();
            }
        }
        return null;
    }

    private static NativeExecutionService prepare(Node node, ExecutionListener listener, Writer outputListener, Project project, InputOutput inputOutput) {
        RemoteSyncWorker syncWorker;
        int i;
        ShellExecSupport bes = (ShellExecSupport)node.getLookup().lookup(ShellExecSupport.class);
        if (bes == null) {
            ShellRunAction.trace("Node " + node + " does not have ShellExecSupport");
            return null;
        }
        ShellRunAction.saveNode(node);
        DataObject dataObject = (DataObject)node.getLookup().lookup(DataObject.class);
        FileObject fileObject = dataObject.getPrimaryFile();
        String bdir = bes.getRunDirectory();
        FileObject buildDirObject = RemoteFileUtil.getFileObject((FileObject)fileObject.getParent(), (String)bdir);
        if (buildDirObject == null) {
            ShellRunAction.trace("Run folder folder is null");
            return null;
        }
        String buildDir = buildDirObject.getPath();
        String[] shellCommandAndArgs = bes.getShellCommandAndArgs(fileObject);
        String shellCommand = shellCommandAndArgs[0];
        String shellFilePath = CndPathUtilities.toRelativePath((FileObject)buildDirObject, (FileObject)fileObject);
        if (shellFilePath.equals(fileObject.getNameExt())) {
            shellFilePath = "./" + shellFilePath;
        }
        shellFilePath = shellFilePath.replace('\\', '/');
        String[] args = bes.getArguments();
        ExecutionEnvironment execEnv = ShellRunAction.getExecutionEnvironment(fileObject, project);
        if (FileSystemProvider.getExecutionEnvironment((FileObject)buildDirObject).isLocal()) {
            buildDir = ShellRunAction.convertToRemoteIfNeeded(execEnv, buildDir, project);
        }
        if (buildDir == null) {
            ShellRunAction.trace("Run folder folder is null");
            return null;
        }
        shellFilePath = ShellRunAction.convertToRemoveSeparatorsIfNeeded(execEnv, shellFilePath);
        if (PlatformInfo.getDefault((ExecutionEnvironment)execEnv).isWindows() && shellCommand.length() > 0) {
            shellCommand = ShellRunAction.findWindowsShell(shellCommand, execEnv, node);
            shellCommand = LinkSupport.resolveWindowsLink((String)shellCommand);
        }
        StringBuilder argsFlat = new StringBuilder();
        if (shellCommandAndArgs[0].length() > 0) {
            for (i = 1; i < shellCommandAndArgs.length; ++i) {
                argsFlat.append(" ");
                argsFlat.append(shellCommandAndArgs[i]);
            }
        }
        if (shellCommand.length() == 0) {
            shellCommand = fileObject.getPath();
        } else {
            argsFlat.append(shellFilePath);
        }
        for (i = 0; i < args.length; ++i) {
            argsFlat.append(" ");
            argsFlat.append(args[i]);
        }
        Map<String, String> envMap = ShellRunAction.getEnv(execEnv, node, project, null);
        if (inputOutput == null) {
            String tabName = execEnv.isLocal() ? ShellRunAction.getString("RUN_LABEL", node.getName()) : ShellRunAction.getString("RUN_REMOTE_LABEL", node.getName(), execEnv.getDisplayName());
            InputOutput _tab = IOProvider.getDefault().getIO(tabName, false);
            _tab.closeInputOutput();
            InputOutput tab = IOProvider.getDefault().getIO(tabName, true);
            try {
                tab.getOut().reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            inputOutput = tab;
        }
        if ((syncWorker = RemoteSyncSupport.createSyncWorker((Lookup.Provider)project, (PrintWriter)inputOutput.getOut(), (PrintWriter)inputOutput.getErr())) != null && !syncWorker.startup(envMap)) {
            ShellRunAction.trace("RemoteSyncWorker is not started up");
            return null;
        }
        String wrapper = envMap.get("__CND_TOOL_WRAPPER__");
        if (wrapper != null) {
            for (Map.Entry<String, String> e : envMap.entrySet()) {
                if (!"PATH".equals(e.getKey().toUpperCase())) continue;
                if (execEnv.isLocal() && Utilities.isWindows()) {
                    envMap.put(e.getKey(), wrapper + ";" + e.getValue());
                    break;
                }
                envMap.put(e.getKey(), wrapper + ":" + e.getValue());
                break;
            }
        }
        MacroMap mm = MacroMap.forExecEnv((ExecutionEnvironment)execEnv);
        mm.putAll(envMap);
        ShellRunAction.traceExecutable(shellCommand, buildDir, argsFlat, execEnv.toString(), (Map<String, String>)mm.toMap());
        AbstractExecutorRunAction.ProcessChangeListener processChangeListener = new AbstractExecutorRunAction.ProcessChangeListener(listener, outputListener, null, syncWorker);
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)execEnv).setWorkingDirectory(buildDir).unbufferOutput(false).addNativeProcessListener((ChangeListener)processChangeListener);
        npb.getEnvironment().putAll(mm);
        npb.redirectError();
        List list = ImportUtils.parseArgs((String)argsFlat.toString());
        list = ImportUtils.normalizeParameters((List)list);
        npb.setExecutable(shellCommand);
        npb.setArguments(list.toArray(new String[list.size()]));
        NativeExecutionDescriptor descr = new NativeExecutionDescriptor().controllable(true).frontWindow(true).inputVisible(true).inputOutput(inputOutput).outLineBased(true).showProgress(!CndUtils.isStandalone()).postExecution((Runnable)processChangeListener).postMessageDisplayer((PostMessageDisplayer)new PostMessageDisplayer.Default("Run")).errConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener).outConvertorFactory((ExecutionDescriptor.LineConvertorFactory)processChangeListener);
        descr.noReset(true);
        inputOutput.getOut().println("cd '" + buildDir + "'");
        inputOutput.getOut().println(shellCommand + " " + argsFlat);
        return NativeExecutionService.newService((NativeProcessBuilder)npb, (NativeExecutionDescriptor)descr, (String)"Run");
    }

    private static String findWindowsShell(String shellCommand, ExecutionEnvironment execEnv, Node node) {
        String folder;
        CompilerSetManager csm;
        File sc;
        int i = shellCommand.lastIndexOf(47);
        if (i >= 0) {
            shellCommand = shellCommand.substring(i + 1);
        }
        if ((sc = new File(shellCommand)).exists()) {
            return shellCommand;
        }
        PlatformInfo pi = PlatformInfo.getDefault((ExecutionEnvironment)execEnv);
        String newShellCommand = pi.findCommand(shellCommand);
        if (newShellCommand != null) {
            return newShellCommand;
        }
        ArrayList<CompilerSet> list = new ArrayList<CompilerSet>();
        CompilerSet set = ShellRunAction.getCompilerSet(node, null);
        if (set != null) {
            list.add(set);
        }
        if ((csm = CompilerSetManager.get((ExecutionEnvironment)execEnv)) != null) {
            set = csm.getDefaultCompilerSet();
            if (set != null && !list.contains(set)) {
                list.add(set);
            }
            for (CompilerSet aSet : csm.getCompilerSets()) {
                if (aSet == null || list.contains(aSet)) continue;
                list.add(aSet);
            }
        }
        for (CompilerSet aSet : list) {
            folder = CompilerSetUtils.getCommandFolder((CompilerSet)aSet);
            if (!(folder != null ? (newShellCommand = pi.findCommand(folder, shellCommand)) != null : (folder = aSet.getDirectory()) != null && (newShellCommand = pi.findCommand(folder, shellCommand)) != null)) continue;
            return newShellCommand;
        }
        folder = CompilerSetUtils.getCygwinBase();
        if (folder != null && (newShellCommand = pi.findCommand(folder + "/bin", shellCommand)) != null) {
            return newShellCommand;
        }
        folder = CompilerSetUtils.getCommandFolder(null);
        if (folder != null && (newShellCommand = pi.findCommand(folder, shellCommand)) != null) {
            return newShellCommand;
        }
        return shellCommand;
    }
}

