/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.html.boot.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.netbeans.html.boot.impl.FindResources;
import org.netbeans.html.boot.impl.JsCallback;
import org.netbeans.html.boot.impl.JsClassLoader;
import org.netbeans.html.boot.impl.JsPkgCache;
import org.netbeans.html.boot.spi.Fn;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.signature.SignatureReader;
import org.objectweb.asm.signature.SignatureVisitor;
import org.objectweb.asm.signature.SignatureWriter;

public final class FnUtils {
    private FnUtils() {
    }

    public static byte[] transform(byte[] bytecode, ClassLoader loader) {
        ClassReader cr = new ClassReader(bytecode){

            public short readShort(int index) {
                short s = super.readShort(index);
                if (index == 6 && s > 51) {
                    return 51;
                }
                return s;
            }
        };
        FindInClass tst = new FindInClass(loader, null);
        cr.accept((ClassVisitor)tst, 0);
        if (tst.found > 0) {
            ClassWriterEx w = new ClassWriterEx(loader, cr, 3);
            FindInClass fic = new FindInClass(loader, (ClassVisitor)w);
            cr.accept((ClassVisitor)fic, 0);
            bytecode = w.toByteArray();
        }
        return bytecode;
    }

    public static ClassLoader newLoader(FindResources f, Fn.Presenter d, ClassLoader parent) {
        return new JsClassLoaderImpl(parent, f, d);
    }

    static String callback(String body) {
        return new JsCallback(){

            @Override
            protected CharSequence callMethod(String ident, String fqn, String method, String params) {
                StringBuilder sb = new StringBuilder();
                if (ident != null) {
                    sb.append("vm.raw$");
                } else {
                    sb.append("vm.");
                }
                sb.append(2.mangle(fqn, method, params));
                sb.append("(");
                if (ident != null) {
                    sb.append(ident);
                }
                return sb;
            }
        }.parse(body);
    }

    static class JsClassLoaderImpl
    extends JsClassLoader {
        private final FindResources f;
        private final Fn.Presenter d;

        public JsClassLoaderImpl(ClassLoader parent, FindResources f, Fn.Presenter d) {
            super(parent);
            this.setDefaultAssertionStatus(JsClassLoader.class.desiredAssertionStatus());
            this.f = f;
            this.d = d;
        }

        @Override
        protected URL findResource(String name) {
            List<URL> l = this.res(name, true);
            return l.isEmpty() ? null : l.get(0);
        }

        @Override
        protected Enumeration<URL> findResources(String name) {
            return Collections.enumeration(this.res(name, false));
        }

        private List<URL> res(String name, boolean oneIsEnough) {
            ArrayList<URL> l = new ArrayList<URL>();
            this.f.findResources(name, l, oneIsEnough);
            return l;
        }

        @Override
        protected Class<?> findClass(String name) throws ClassNotFoundException {
            if (name.startsWith("javafx")) {
                return Class.forName(name);
            }
            if (name.startsWith("netscape")) {
                return Class.forName(name);
            }
            if (name.startsWith("com.sun")) {
                return Class.forName(name);
            }
            if (name.startsWith("org.netbeans.html.context.spi")) {
                return Class.forName(name);
            }
            if (name.startsWith("net.java.html.BrwsrCtx")) {
                return Class.forName(name);
            }
            if (name.equals(JsClassLoader.class.getName())) {
                return JsClassLoader.class;
            }
            if (name.equals(Fn.class.getName())) {
                return Fn.class;
            }
            if (name.equals(Fn.Presenter.class.getName())) {
                return Fn.Presenter.class;
            }
            if (name.equals(Fn.ToJavaScript.class.getName())) {
                return Fn.ToJavaScript.class;
            }
            if (name.equals(Fn.FromJavaScript.class.getName())) {
                return Fn.FromJavaScript.class;
            }
            if (name.equals(FnUtils.class.getName())) {
                return FnUtils.class;
            }
            if (name.equals("org.netbeans.html.boot.spi.Fn") || name.equals("org.netbeans.html.boot.impl.FnUtils") || name.equals("org.netbeans.html.boot.impl.FnContext")) {
                return Class.forName(name);
            }
            URL u = this.findResource(name.replace('.', '/') + ".class");
            if (u != null) {
                InputStream is = null;
                try {
                    int read;
                    is = u.openStream();
                    byte[] arr = new byte[is.available()];
                    for (int len = 0; len < arr.length; len += read) {
                        read = is.read(arr, len, arr.length - len);
                        if (read != -1) continue;
                        throw new IOException("Can't read " + u);
                    }
                    is.close();
                    is = null;
                    if (JsPkgCache.process(this, name)) {
                        arr = FnUtils.transform(arr, this);
                    }
                    Class<?> clazz = this.defineClass(name, arr, 0, arr.length);
                    return clazz;
                }
                catch (IOException ex) {
                    throw new ClassNotFoundException("Can't load " + name, ex);
                }
                finally {
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException ex) {
                        throw new ClassNotFoundException(null, ex);
                    }
                }
            }
            return super.findClass(name);
        }

        protected Fn defineFn(String code, String ... names) {
            return this.d.defineFn(code, names);
        }

        protected void loadScript(Reader code) throws Exception {
            this.d.loadScript(code);
        }
    }

    private static class ClassWriterEx
    extends ClassWriter {
        private final ClassLoader loader;

        public ClassWriterEx(ClassLoader l, ClassReader classReader, int flags) {
            super(classReader, flags);
            this.loader = l;
        }

        protected String getCommonSuperClass(String type1, String type2) {
            Class<?> d;
            Class<?> c;
            try {
                c = Class.forName(type1.replace('/', '.'), false, this.loader);
                d = Class.forName(type2.replace('/', '.'), false, this.loader);
            }
            catch (Exception e) {
                throw new RuntimeException(e.toString());
            }
            if (c.isAssignableFrom(d)) {
                return type1;
            }
            if (d.isAssignableFrom(c)) {
                return type2;
            }
            if (c.isInterface() || d.isInterface()) {
                return "java/lang/Object";
            }
            while (!(c = c.getSuperclass()).isAssignableFrom(d)) {
            }
            return c.getName().replace('.', '/');
        }
    }

    private static final class FindInClass
    extends ClassVisitor {
        private String name;
        private int found;
        private String resource;

        public FindInClass(ClassLoader l, ClassVisitor cv) {
            super(262144, cv);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.name = name;
            super.visit(version, access, name, signature, superName, interfaces);
        }

        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            AnnotationVisitor del = super.visitAnnotation(desc, visible);
            if ("Lnet/java/html/js/JavaScriptResource;".equals(desc)) {
                return new LoadResource(del);
            }
            return del;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            return new FindInMethod(access, name, desc, super.visitMethod(access & 0xFFFFFEFF, name, desc, signature, exceptions));
        }

        public FieldVisitor visitField(int access, String name, String desc, String signature, Object value) {
            if (name.startsWith("$$fn$$")) {
                return null;
            }
            return this.superField(access, name, desc, signature, value);
        }

        final FieldVisitor superField(int access, String name, String desc, String signature, Object value) {
            return super.visitField(access, name, desc, signature, value);
        }

        private final class LoadResource
        extends AnnotationVisitor {
            public LoadResource(AnnotationVisitor av) {
                super(262144, av);
            }

            public void visit(String attrName, Object value) {
                super.visit(attrName, value);
                String relPath = (String)value;
                if (relPath.startsWith("/")) {
                    FindInClass.this.resource = relPath;
                } else {
                    int last = FindInClass.this.name.lastIndexOf(47);
                    String fullPath = FindInClass.this.name.substring(0, last + 1) + relPath;
                    FindInClass.this.resource = fullPath;
                }
            }
        }

        private final class FindInMethod
        extends MethodVisitor {
            private final String name;
            private final String desc;
            private final int access;
            private FindInAnno fia;
            private boolean bodyGenerated;

            public FindInMethod(int access, String name, String desc, MethodVisitor mv) {
                super(262144, mv);
                this.access = access;
                this.name = name;
                this.desc = desc;
            }

            public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                if ("Lnet/java/html/js/JavaScriptBody;".equals(desc)) {
                    FindInClass.this.found++;
                    return new FindInAnno();
                }
                return super.visitAnnotation(desc, visible);
            }

            private void generateJSBody(FindInAnno fia) {
                this.fia = fia;
            }

            public void visitCode() {
                if (this.fia == null) {
                    return;
                }
                this.generateBody(true);
            }

            private boolean generateBody(boolean hasCode) {
                int offset;
                List<String> args;
                String body;
                if (this.bodyGenerated) {
                    return false;
                }
                this.bodyGenerated = true;
                if (this.mv != null) {
                    AnnotationVisitor va = super.visitAnnotation("Lnet/java/html/js/JavaScriptBody;", false);
                    AnnotationVisitor varr = va.visitArray("args");
                    for (String argName : this.fia.args) {
                        varr.visit(null, (Object)argName);
                    }
                    varr.visitEnd();
                    va.visit("javacall", (Object)this.fia.javacall);
                    va.visit("body", (Object)this.fia.body);
                    va.visitEnd();
                }
                if (this.fia.javacall) {
                    body = FnUtils.callback(this.fia.body);
                    args = new ArrayList<String>(this.fia.args);
                    args.add("vm");
                } else {
                    body = this.fia.body;
                    args = this.fia.args;
                }
                super.visitFieldInsn(178, FindInClass.this.name, "$$fn$$" + this.name + "_" + FindInClass.this.found, "Lorg/netbeans/html/boot/spi/Fn;");
                super.visitInsn(89);
                super.visitMethodInsn(184, "org/netbeans/html/boot/spi/Fn", "isValid", "(Lorg/netbeans/html/boot/spi/Fn;)Z");
                Label ifNotNull = new Label();
                super.visitJumpInsn(154, ifNotNull);
                super.visitInsn(87);
                super.visitLdcInsn((Object)Type.getObjectType((String)FindInClass.this.name));
                super.visitInsn(this.fia.keepAlive ? 4 : 3);
                super.visitLdcInsn((Object)body);
                super.visitIntInsn(17, args.size());
                super.visitTypeInsn(189, "java/lang/String");
                boolean needsVM = false;
                for (int i = 0; i < args.size(); ++i) {
                    assert (!needsVM);
                    String argName = args.get(i);
                    needsVM = "vm".equals(argName);
                    super.visitInsn(89);
                    super.visitIntInsn(16, i);
                    super.visitLdcInsn((Object)argName);
                    super.visitInsn(83);
                }
                super.visitMethodInsn(184, "org/netbeans/html/boot/spi/Fn", "define", "(Ljava/lang/Class;ZLjava/lang/String;[Ljava/lang/String;)Lorg/netbeans/html/boot/spi/Fn;");
                Label noPresenter = new Label();
                super.visitInsn(89);
                super.visitJumpInsn(198, noPresenter);
                if (FindInClass.this.resource != null) {
                    super.visitLdcInsn((Object)Type.getObjectType((String)FindInClass.this.name));
                    super.visitLdcInsn((Object)FindInClass.this.resource);
                    super.visitMethodInsn(184, "org/netbeans/html/boot/spi/Fn", "preload", "(Lorg/netbeans/html/boot/spi/Fn;Ljava/lang/Class;Ljava/lang/String;)Lorg/netbeans/html/boot/spi/Fn;");
                }
                super.visitInsn(89);
                super.visitFieldInsn(179, FindInClass.this.name, "$$fn$$" + this.name + "_" + FindInClass.this.found, "Lorg/netbeans/html/boot/spi/Fn;");
                super.visitLabel(ifNotNull);
                if ((this.access & 8) == 0) {
                    offset = 1;
                    super.visitIntInsn(25, 0);
                } else {
                    offset = 0;
                    super.visitInsn(1);
                }
                super.visitIntInsn(17, args.size());
                super.visitTypeInsn(189, "java/lang/Object");
                class SV
                extends SignatureVisitor {
                    private boolean nowReturn;
                    private Type returnType;
                    private int index;
                    private int loadIndex;

                    public SV() {
                        super(262144);
                        this.loadIndex = offset;
                    }

                    public void visitBaseType(char descriptor) {
                        String factory;
                        Type t = Type.getType((String)("" + descriptor));
                        if (this.nowReturn) {
                            this.returnType = t;
                            return;
                        }
                        FindInMethod.super.visitInsn(89);
                        FindInMethod.super.visitIntInsn(17, this.index++);
                        FindInMethod.super.visitVarInsn(t.getOpcode(21), this.loadIndex++);
                        switch (descriptor) {
                            case 'I': {
                                factory = "java/lang/Integer";
                                break;
                            }
                            case 'J': {
                                factory = "java/lang/Long";
                                ++this.loadIndex;
                                break;
                            }
                            case 'S': {
                                factory = "java/lang/Short";
                                break;
                            }
                            case 'F': {
                                factory = "java/lang/Float";
                                break;
                            }
                            case 'D': {
                                factory = "java/lang/Double";
                                ++this.loadIndex;
                                break;
                            }
                            case 'Z': {
                                factory = "java/lang/Boolean";
                                break;
                            }
                            case 'C': {
                                factory = "java/lang/Character";
                                break;
                            }
                            case 'B': {
                                factory = "java/lang/Byte";
                                break;
                            }
                            default: {
                                throw new IllegalStateException(t.toString());
                            }
                        }
                        FindInMethod.super.visitMethodInsn(184, factory, "valueOf", "(" + descriptor + ")L" + factory + ";");
                        FindInMethod.super.visitInsn(83);
                    }

                    public SignatureVisitor visitArrayType() {
                        if (this.nowReturn) {
                            return new SignatureVisitor(262144){

                                public void visitClassType(String name) {
                                    returnType = Type.getType((String)("[" + Type.getObjectType((String)name).getDescriptor()));
                                }

                                public void visitBaseType(char descriptor) {
                                    returnType = Type.getType((String)("[" + descriptor));
                                }
                            };
                        }
                        this.loadObject();
                        return new SignatureWriter();
                    }

                    public void visitClassType(String name) {
                        if (this.nowReturn) {
                            this.returnType = Type.getObjectType((String)name);
                            return;
                        }
                        this.loadObject();
                    }

                    public SignatureVisitor visitReturnType() {
                        this.nowReturn = true;
                        return this;
                    }

                    private void loadObject() {
                        FindInMethod.super.visitInsn(89);
                        FindInMethod.super.visitIntInsn(17, this.index++);
                        FindInMethod.super.visitVarInsn(25, this.loadIndex++);
                        FindInMethod.super.visitInsn(83);
                    }
                }
                SV sv = new SV();
                SignatureReader sr = new SignatureReader(this.desc);
                sr.accept((SignatureVisitor)sv);
                if (needsVM) {
                    FindInMethod.super.visitInsn(89);
                    FindInMethod.super.visitIntInsn(17, sv.index);
                    int lastSlash = FindInClass.this.name.lastIndexOf(47);
                    String jsCallbacks = FindInClass.this.name.substring(0, lastSlash + 1) + "$JsCallbacks$";
                    FindInMethod.super.visitFieldInsn(178, jsCallbacks, "VM", "L" + jsCallbacks + ";");
                    FindInMethod.super.visitMethodInsn(182, jsCallbacks, "current", "()L" + jsCallbacks + ";");
                    FindInMethod.super.visitInsn(83);
                }
                if (this.fia.wait4js) {
                    super.visitMethodInsn(182, "org/netbeans/html/boot/spi/Fn", "invoke", "(Ljava/lang/Object;[Ljava/lang/Object;)Ljava/lang/Object;");
                    switch (sv.returnType.getSort()) {
                        case 0: {
                            super.visitInsn(177);
                            break;
                        }
                        case 9: 
                        case 10: {
                            super.visitTypeInsn(192, sv.returnType.getInternalName());
                            super.visitInsn(176);
                            break;
                        }
                        case 1: {
                            super.visitTypeInsn(192, "java/lang/Boolean");
                            super.visitMethodInsn(182, "java/lang/Boolean", "booleanValue", "()Z");
                            super.visitInsn(172);
                            break;
                        }
                        default: {
                            super.visitTypeInsn(192, "java/lang/Number");
                            super.visitMethodInsn(182, "java/lang/Number", sv.returnType.getClassName() + "Value", "()" + sv.returnType.getDescriptor());
                            super.visitInsn(sv.returnType.getOpcode(172));
                            break;
                        }
                    }
                } else {
                    super.visitMethodInsn(182, "org/netbeans/html/boot/spi/Fn", "invokeLater", "(Ljava/lang/Object;[Ljava/lang/Object;)V");
                    super.visitInsn(177);
                }
                super.visitLabel(noPresenter);
                if (hasCode) {
                    super.visitCode();
                } else {
                    super.visitTypeInsn(187, "java/lang/IllegalStateException");
                    super.visitInsn(89);
                    super.visitLdcInsn((Object)"No presenter active. Use BrwsrCtx.execute!");
                    super.visitMethodInsn(183, "java/lang/IllegalStateException", "<init>", "(Ljava/lang/String;)V");
                    this.visitInsn(191);
                }
                return true;
            }

            public void visitEnd() {
                super.visitEnd();
                if (this.fia != null) {
                    if (this.generateBody(false)) {
                        super.visitMaxs(1, 0);
                    }
                    FindInClass.this.superField(10, "$$fn$$" + this.name + "_" + FindInClass.this.found, "Lorg/netbeans/html/boot/spi/Fn;", null, null);
                }
            }

            private final class FindInAnno
            extends AnnotationVisitor {
                List<String> args;
                String body;
                boolean javacall;
                boolean wait4js;
                boolean keepAlive;

                public FindInAnno() {
                    super(262144);
                    this.args = new ArrayList<String>();
                    this.javacall = false;
                    this.wait4js = true;
                    this.keepAlive = true;
                }

                public void visit(String name, Object value) {
                    if (name == null) {
                        this.args.add((String)value);
                        return;
                    }
                    if (name.equals("javacall")) {
                        this.javacall = (Boolean)value;
                        return;
                    }
                    if (name.equals("wait4js")) {
                        this.wait4js = (Boolean)value;
                        return;
                    }
                    if (name.equals("keepAlive")) {
                        this.keepAlive = (Boolean)value;
                        return;
                    }
                    assert (name.equals("body"));
                    this.body = (String)value;
                }

                public AnnotationVisitor visitArray(String name) {
                    return this;
                }

                public void visitEnd() {
                    if (this.body != null) {
                        FindInMethod.this.generateJSBody(this);
                    }
                }
            }
        }
    }
}

