/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.reformat;

import java.util.Iterator;
import java.util.LinkedList;
import org.netbeans.modules.cnd.editor.reformat.ExtendedTokenSequence;
import org.netbeans.modules.cnd.editor.reformat.Reformatter;

class DiffLinkedList {
    private final LinkedList<Reformatter.Diff> storage = new LinkedList();

    DiffLinkedList() {
    }

    Reformatter.Diff addFirst(int start, int end, int newLines, int spaces, boolean isIndent) {
        Reformatter.Diff diff = new Reformatter.Diff(start, end, newLines, spaces, isIndent);
        this.storage.add(this.getIndex(start, end), diff);
        return diff;
    }

    private int getIndex(int start, int end) {
        int res = 0;
        Iterator it = this.storage.iterator();
        while (it.hasNext()) {
            Reformatter.Diff diff = (Reformatter.Diff)it.next();
            if (diff.getStartOffset() <= start) {
                if (diff.getStartOffset() != start || diff.getEndOffset() != end) break;
                it.remove();
                break;
            }
            ++res;
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DiffResult getDiffs(ExtendedTokenSequence ts, int shift) {
        int end;
        int start;
        if (shift != 0) {
            int index = ts.index();
            try {
                if (shift > 0) {
                    while (ts.moveNext() && --shift != 0) {
                    }
                } else {
                    while (ts.movePrevious() && ++shift != 0) {
                    }
                }
                start = ts.offset();
                end = ts.offset() + ts.token().length();
            }
            finally {
                ts.moveIndex(index);
                ts.moveNext();
            }
        } else {
            start = ts.offset();
            end = ts.offset() + ts.token().length();
        }
        return this.getDiffs(start, end);
    }

    DiffResult getDiffs(int start, int end) {
        DiffResult result = null;
        for (Reformatter.Diff diff : this.storage) {
            if (diff.getStartOffset() == start) {
                if (diff.getEndOffset() == end) {
                    if (result == null) {
                        result = new DiffResult();
                    }
                    result.replace = diff;
                } else {
                    if (result == null) {
                        result = new DiffResult();
                    }
                    result.before = diff;
                }
            } else if (diff.getEndOffset() == end) {
                if (result == null) {
                    result = new DiffResult();
                }
                result.after = diff;
            }
            if (diff.getEndOffset() >= start) continue;
            return result;
        }
        return result;
    }

    Reformatter.Diff getFirst() {
        if (this.storage.isEmpty()) {
            return null;
        }
        return this.storage.getFirst();
    }

    LinkedList<Reformatter.Diff> getStorage() {
        return this.storage;
    }

    static class DiffResult {
        Reformatter.Diff before;
        Reformatter.Diff replace;
        Reformatter.Diff after;

        DiffResult() {
        }
    }
}

