/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran.reformat;

import org.netbeans.api.lexer.Token;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.modules.cnd.editor.fortran.reformat.FortranExtendedTokenSequence;

class FortranStackEntry {
    private final FortranTokenId kind;
    private int indent;
    private int selfIndent;
    private int label = -1;

    FortranStackEntry(Token<FortranTokenId> token, FortranExtendedTokenSequence ts) {
        this.kind = (FortranTokenId)token.id();
        this.init(ts);
    }

    FortranStackEntry(FortranTokenId id) {
        this.kind = id;
        this.init(null);
    }

    private void init(FortranExtendedTokenSequence ts) {
        switch (this.kind) {
            case KW_DO: {
                Token<FortranTokenId> next;
                if (ts == null || (next = ts.lookNextLineImportantAfter(this.kind)) == null || next.id() != FortranTokenId.NUM_LITERAL_INT) break;
                this.label = Integer.parseInt(next.text().toString());
                break;
            }
            case KW_INTERFACE: 
            case KW_STRUCTURE: 
            case KW_UNION: 
            case KW_ENUM: 
            case KW_TYPE: 
            case KW_BLOCKDATA: 
            case KW_MODULE: 
            case KW_PROGRAM: 
            case KW_PROCEDURE: 
            case KW_SUBROUTINE: 
            case KW_FUNCTION: 
            case KW_MAP: 
            case KW_BLOCK: 
            case KW_IF: 
            case KW_ELSE: 
            case KW_ELSEIF: 
            case KW_ELSEWHERE: 
            case KW_WHERE: 
            case KW_WHILE: 
            case KW_FORALL: 
            case KW_SELECT: 
            case KW_SELECTCASE: 
            case KW_SELECTTYPE: {
                break;
            }
            default: {
                assert (false);
                break;
            }
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        this.indent = indent;
    }

    public int getSelfIndent() {
        return this.selfIndent;
    }

    public void setSelfIndent(int selfIndent) {
        this.selfIndent = selfIndent;
    }

    public FortranTokenId getKind() {
        return this.kind;
    }

    public int getLabel() {
        return this.label;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(this.kind.name());
        return buf.toString();
    }
}

