/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.editor.fortran;

import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.cnd.editor.fortran.FortranBracketCompletion;
import org.netbeans.modules.cnd.editor.fortran.indent.FortranHotCharIndent;
import org.netbeans.modules.editor.indent.api.Indent;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;
import org.openide.util.Exceptions;

public class FortranTTIFactory
implements TypedTextInterceptor.Factory {
    public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
        assert (mimePath.getPath().equals("text/x-fortran"));
        return new TypedTextInterceptorImpl();
    }

    private static class TypedTextInterceptorImpl
    implements TypedTextInterceptor {
        public boolean beforeInsert(TypedTextInterceptor.Context context) throws BadLocationException {
            return false;
        }

        public void insert(TypedTextInterceptor.MutableContext context) throws BadLocationException {
            FortranBracketCompletion.INSTANCE.charInserted((BaseDocument)context.getDocument(), context.getOffset(), context.getComponent().getCaret(), context.getText().charAt(0));
        }

        public void afterInsert(final TypedTextInterceptor.Context context) throws BadLocationException {
            final BaseDocument doc = (BaseDocument)context.getDocument();
            doc.runAtomicAsUser(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    int offset = context.getOffset();
                    if (FortranHotCharIndent.INSTANCE.getKeywordBasedReformatBlock(doc, offset, context.getText())) {
                        Indent indent = Indent.get((Document)doc);
                        indent.lock();
                        try {
                            doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.TRUE);
                            indent.reindent(offset);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        finally {
                            doc.putProperty((Object)"abbrev-ignore-modification", (Object)Boolean.FALSE);
                            indent.unlock();
                        }
                    }
                }
            });
        }

        public void cancelled(TypedTextInterceptor.Context context) {
        }
    }
}

