/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectUtils;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.CompilerSetNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.DevelopmentHostNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PlatformSpecificProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.PrependToolCollectionPathNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.configurations.RemoteSyncFactoryNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class BuildCustomizerNode
extends CustomizerNode {
    public BuildCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public Sheet[] getSheets(Configuration configuration) {
        Sheet buildSheet = BuildCustomizerNode.getBuildSheet(this.getContext().getProject(), (MakeConfiguration)configuration);
        return new Sheet[]{buildSheet};
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectPropsBuild");
    }

    private static String getString(String s) {
        return NbBundle.getMessage(BuildCustomizerNode.class, (String)s);
    }

    private static Sheet getBuildSheet(Project project, MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("ProjectDefaults");
        set.setDisplayName(BuildCustomizerNode.getString("ProjectDefaultsTxt"));
        set.setShortDescription(BuildCustomizerNode.getString("ProjectDefaultsHint"));
        boolean canEditHost = MakeProjectUtils.canChangeHost((Project)project, (MakeConfiguration)conf);
        set.put((Node.Property)new DevelopmentHostNodeProp(conf.getDevelopmentHost(), canEditHost, "DevelopmentHost", BuildCustomizerNode.getString("DevelopmentHostTxt"), BuildCustomizerNode.getString("DevelopmentHostHint")));
        RemoteSyncFactoryNodeProp rsfNodeProp = new RemoteSyncFactoryNodeProp(conf);
        set.put((Node.Property)rsfNodeProp);
        set.put((Node.Property)new CompilerSetNodeProp(conf.getCompilerSet(), conf.getDevelopmentHost(), true, "CompilerSetCollection", BuildCustomizerNode.getString("CompilerCollectionTxt"), BuildCustomizerNode.getString("CompilerCollectionHint")));
        set.put((Node.Property)new IntNodeProp(conf.getConfigurationType(), true, "ConfigurationType", BuildCustomizerNode.getString("ConfigurationTypeTxt"), BuildCustomizerNode.getString("ConfigurationTypeHint")));
        sheet.put(set);
        set = Sheet.createExpertSet();
        if (conf.isCompileConfiguration()) {
            set.put((Node.Property)new BooleanNodeProp(conf.getDependencyChecking(), true, "DependencyChecking", BuildCustomizerNode.getString("DependencyCheckingTxt"), BuildCustomizerNode.getString("DependencyCheckingHint")));
            set.put((Node.Property)new BooleanNodeProp(conf.getRebuildPropChanged(), true, "RebuildPropChanged", BuildCustomizerNode.getString("RebuildPropChangedTxt"), BuildCustomizerNode.getString("RebuildPropChangedHint")));
        }
        set.put((Node.Property)new PlatformSpecificProp(conf, conf.getPlatformSpecific(), true, "PlatformSpecific", BuildCustomizerNode.getString("PlatformSpecificTxt"), BuildCustomizerNode.getString("PlatformSpecificHint")));
        set.put((Node.Property)new PrependToolCollectionPathNodeProp(conf.getPrependToolCollectionPath(), conf.getCompilerSet(), conf.getDevelopmentHost(), true, "PrependToolCollectionPath", BuildCustomizerNode.getString("PrependToolCollectionPathTxt"), BuildCustomizerNode.getString("PrependToolCollectionPathHint")));
        sheet.put(set);
        return sheet;
    }
}

