/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.configurations;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.ToolchainManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class LibraryOptionPanel
extends JPanel {
    private ButtonGroup buttonGroup;
    private JRadioButton dynamicRadioButton;
    private JRadioButton otherRadioButton;
    private JTextField otherTextField;
    private JRadioButton staticRadioButton;

    public LibraryOptionPanel() {
        this.initComponents();
        this.buttonGroup.add(this.staticRadioButton);
        this.buttonGroup.add(this.dynamicRadioButton);
        this.buttonGroup.add(this.otherRadioButton);
        this.staticRadioButton.setSelected(true);
        this.otherTextField.setEnabled(false);
        this.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_PANEL_SD"));
        this.dynamicRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_DYNAMIC_RB_SD"));
        this.otherRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_OTHER_RB_SD"));
        this.otherTextField.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_OTHER_TF_SD"));
        this.staticRadioButton.getAccessibleContext().setAccessibleDescription(LibraryOptionPanel.getString("LINKER_OPTIONS_STATIC_RB_SD"));
    }

    private void initComponents() {
        this.buttonGroup = new ButtonGroup();
        this.staticRadioButton = new JRadioButton();
        this.dynamicRadioButton = new JRadioButton();
        this.otherRadioButton = new JRadioButton();
        this.otherTextField = new JTextField();
        this.setLayout(new GridBagLayout());
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/configurations/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.staticRadioButton, (String)bundle.getString("STATIC_BINDINGS_TXT"));
        this.staticRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryOptionPanel.this.staticRadioButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 12, 0, 12);
        this.add((Component)this.staticRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.dynamicRadioButton, (String)bundle.getString("DYNAMIC_BINDINGS_TXT"));
        this.dynamicRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryOptionPanel.this.dynamicRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 12);
        this.add((Component)this.dynamicRadioButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.otherRadioButton, (String)bundle.getString("OTHER_OPTION_TXT"));
        this.otherRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                LibraryOptionPanel.this.otherRadioButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 12);
        this.add((Component)this.otherRadioButton, gridBagConstraints);
        this.otherTextField.setColumns(32);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 34, 12, 12);
        this.add((Component)this.otherTextField, gridBagConstraints);
    }

    private void otherRadioButtonActionPerformed(ActionEvent evt) {
        this.otherTextField.setEnabled(true);
    }

    private void dynamicRadioButtonActionPerformed(ActionEvent evt) {
        this.otherTextField.setEnabled(false);
    }

    private void staticRadioButtonActionPerformed(ActionEvent evt) {
        this.otherTextField.setEnabled(false);
    }

    public String getOption(MakeConfiguration conf) {
        CompilerSet cs = conf.getCompilerSet().getCompilerSet();
        if (cs == null) {
            return this.otherTextField.getText();
        }
        if (this.dynamicRadioButton.isSelected()) {
            String res;
            ToolchainManager.LinkerDescriptor linker = cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (linker != null && (res = linker.getDynamicLibraryFlag()) != null) {
                return res;
            }
            return "";
        }
        if (this.staticRadioButton.isSelected()) {
            String res;
            ToolchainManager.LinkerDescriptor linker = cs.getCompilerFlavor().getToolchainDescriptor().getLinker();
            if (linker != null && (res = linker.getStaticLibraryFlag()) != null) {
                return res;
            }
            return "";
        }
        return this.otherTextField.getText();
    }

    private static String getString(String s) {
        return NbBundle.getBundle(LibraryOptionPanel.class).getString(s);
    }
}

