/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.cplusplus;

import java.util.prefs.Preferences;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.JTextComponent;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;

public class CsmCompletionUtils {
    public static final String CPP_AUTO_COMPLETION_TRIGGERS = "cppAutoCompletionTriggers";
    public static final String CPP_AUTO_COMPLETION_TRIGGERS_DEFAULT = ".;->;.*;->*;::;new ;";
    public static final String PREPRPOC_AUTO_COMPLETION_TRIGGERS = "autoCompletionTriggersPreproc";
    public static final String PREPRPOC_AUTO_COMPLETION_TRIGGERS_DEFAULT = "\";<; ;/;";
    public static final String CPP_AUTO_INSERT_INCLUDE_DIRECTIVES = "autoInsertIncludeDirectives";

    private CsmCompletionUtils() {
    }

    public static String getMimeType(Document doc) {
        return DocumentUtilities.getMimeType((Document)doc);
    }

    public static String getMimeType(JTextComponent component) {
        EditorKit kit;
        if (component == null) {
            return "";
        }
        Document doc = component.getDocument();
        String mimeType = CsmCompletionUtils.getMimeType(doc);
        if (mimeType == null && (kit = component.getUI().getEditorKit(component)) != null) {
            mimeType = kit.getContentType();
        }
        return mimeType;
    }

    public static boolean isCaseSensitive(String mimeType) {
        if (mimeType == null || mimeType.length() == 0) {
            return false;
        }
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        return prefs.getBoolean("completion-case-sensitive", false);
    }

    public static boolean isNaturalSort(String mimeType) {
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        return prefs.getBoolean("completion-natural-sort", false);
    }

    public static boolean isAutoInsertIncludeDirectives() {
        String mimeType = "text/x-cnd+sourcefile";
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        return prefs.getBoolean(CPP_AUTO_INSERT_INCLUDE_DIRECTIVES, true);
    }

    public static String[] getCppAutoCompletionTrigers() {
        String mimeType = "text/x-cnd+sourcefile";
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        return prefs.get(CPP_AUTO_COMPLETION_TRIGGERS, CPP_AUTO_COMPLETION_TRIGGERS_DEFAULT).split(";");
    }

    public static String[] getPreprocAutoCompletionTrigers() {
        String mimeType = "text/x-cnd+sourcefile";
        Preferences prefs = (Preferences)MimeLookup.getLookup((String)mimeType).lookup(Preferences.class);
        return prefs.get(PREPRPOC_AUTO_COMPLETION_TRIGGERS, PREPRPOC_AUTO_COMPLETION_TRIGGERS_DEFAULT).split(";");
    }
}

