/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.ui.jdbc;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.client.ClientUtils;
import org.netbeans.lib.profiler.results.CCTProvider;
import org.netbeans.lib.profiler.results.RuntimeCCTNode;
import org.netbeans.lib.profiler.results.jdbc.JdbcCCTProvider;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsDiff;
import org.netbeans.lib.profiler.results.jdbc.JdbcResultsSnapshot;
import org.netbeans.lib.profiler.results.memory.PresoObjAllocCCTNode;
import org.netbeans.lib.profiler.ui.UIUtils;
import org.netbeans.lib.profiler.ui.jdbc.JDBCTreeTableView;
import org.netbeans.lib.profiler.ui.jdbc.JDBCView;
import org.netbeans.lib.profiler.ui.memory.LiveMemoryView;
import org.netbeans.lib.profiler.ui.results.DataView;
import org.netbeans.lib.profiler.ui.swing.FilterUtils;
import org.netbeans.lib.profiler.ui.swing.ProfilerTable;
import org.netbeans.lib.profiler.ui.swing.SearchUtils;
import org.openide.util.Lookup;

public abstract class LiveJDBCView
extends JPanel {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private ResultsMonitor rm;
    private JdbcResultsSnapshot snapshot;
    private JdbcResultsSnapshot refSnapshot;
    private DataView lastFocused;
    private JDBCTreeTableView jdbcCallsView;
    private long lastupdate;
    private volatile boolean paused;
    private volatile boolean forceRefresh;
    private volatile boolean refreshIsRunning;
    private ExecutorService executor;

    public LiveJDBCView(Set<ClientUtils.SourceCodeSelection> selection) {
        this.initUI(selection);
        this.registerActions();
    }

    public void setView(boolean forwardCalls, boolean hotSpots, boolean reverseCalls) {
        this.jdbcCallsView.setVisible(forwardCalls);
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    private void refreshData(RuntimeCCTNode appRootNode) throws ClientUtils.TargetAppOrVMTerminated {
        if ((this.lastupdate + 900L > System.currentTimeMillis() || this.paused) && !this.forceRefresh) {
            return;
        }
        if (this.refreshIsRunning) {
            return;
        }
        this.refreshIsRunning = true;
        try {
            ProfilerClient client = this.getProfilerClient();
            final JdbcResultsSnapshot snapshotData = client.getStatus().getInstrMethodClasses() == null ? null : client.getJdbcProfilingResultsSnapshot(false);
            UIUtils.runInEventDispatchThread(new Runnable(){

                @Override
                public void run() {
                    LiveJDBCView.this.snapshot = snapshotData;
                    LiveJDBCView.this.setData();
                    LiveJDBCView.this.lastupdate = System.currentTimeMillis();
                    LiveJDBCView.this.forceRefresh = false;
                }
            });
        }
        catch (Throwable t) {
            this.refreshIsRunning = false;
            if (t instanceof ClientUtils.TargetAppOrVMTerminated) {
                throw (ClientUtils.TargetAppOrVMTerminated)t;
            }
            Logger.getLogger(LiveJDBCView.class.getName()).log(Level.SEVERE, null, t);
        }
    }

    private void setData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                if (LiveJDBCView.this.snapshot == null) {
                    LiveJDBCView.this.resetData();
                    LiveJDBCView.this.refreshIsRunning = false;
                } else {
                    LiveJDBCView.this.getExecutor().submit(new Runnable(){

                        @Override
                        public void run() {
                            final JdbcResultsSnapshot _snapshot = LiveJDBCView.this.refSnapshot == null ? LiveJDBCView.this.snapshot : LiveJDBCView.this.refSnapshot.createDiff(LiveJDBCView.this.snapshot);
                            SwingUtilities.invokeLater(new Runnable(){

                                @Override
                                public void run() {
                                    try {
                                        boolean diff = _snapshot instanceof JdbcResultsDiff;
                                        LiveJDBCView.this.jdbcCallsView.setData(_snapshot, null, -1, null, false, false, diff);
                                    }
                                    finally {
                                        LiveJDBCView.this.refreshIsRunning = false;
                                    }
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    public boolean setDiffView(final boolean diff) {
        if (this.snapshot == null) {
            return false;
        }
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.refSnapshot = diff ? LiveJDBCView.this.snapshot : null;
                LiveJDBCView.this.setData();
            }
        });
        return true;
    }

    public void refreshData() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.lastupdate + 1400L < System.currentTimeMillis() && !this.paused || this.forceRefresh) {
            this.getProfilerClient().forceObtainedResultsDump(true);
        }
    }

    public void resetData() {
        UIUtils.runInEventDispatchThread(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.jdbcCallsView.resetData();
                LiveJDBCView.this.snapshot = null;
                LiveJDBCView.this.refSnapshot = null;
            }
        });
    }

    public void showSelectionColumn() {
        this.jdbcCallsView.showSelectionColumn();
    }

    public void refreshSelection() {
        this.jdbcCallsView.refreshSelection();
    }

    public void cleanup() {
    }

    public void profilingSessionStarted() {
        if (this.rm == null) {
            this.rm = new ResultsMonitor();
            Collection jdbcCCTProviders = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
            assert (!jdbcCCTProviders.isEmpty());
            for (JdbcCCTProvider provider : jdbcCCTProviders) {
                provider.addListener((CCTProvider.Listener)this.rm);
            }
        }
    }

    public void profilingSessionFinished() {
        if (this.rm != null) {
            Collection jdbcCCTProviders = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
            assert (!jdbcCCTProviders.isEmpty());
            for (JdbcCCTProvider provider : jdbcCCTProviders) {
                provider.removeListener((CCTProvider.Listener)this.rm);
            }
            this.rm = null;
        }
    }

    protected abstract ProfilerClient getProfilerClient();

    protected boolean profileMethodSupported() {
        return true;
    }

    protected abstract boolean showSourceSupported();

    protected abstract void showSource(ClientUtils.SourceCodeSelection var1);

    protected abstract void showSQLQuery(String var1, String var2);

    protected abstract void selectForProfiling(ClientUtils.SourceCodeSelection var1);

    protected void popupShowing() {
    }

    protected void popupHidden() {
    }

    private void profileMethod(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(value);
    }

    private void profileClass(ClientUtils.SourceCodeSelection value) {
        this.selectForProfiling(new ClientUtils.SourceCodeSelection(value.getClassName(), "*", null));
    }

    private void initUI(Set<ClientUtils.SourceCodeSelection> selection) {
        this.setLayout(new BorderLayout(0, 0));
        this.jdbcCallsView = new JDBCTreeTableView(selection, false){

            @Override
            protected void installDefaultAction() {
                this.getResultsComponent().setDefaultAction(new AbstractAction(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        int row;
                        ProfilerTable t = this.getResultsComponent();
                        PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)t.getValueForRow(row = t.getSelectedRow());
                        if (JDBCTreeTableView.isSQL(node)) {
                            LiveJDBCView.this.showQueryImpl(node);
                        } else {
                            ClientUtils.SourceCodeSelection userValue = this.getUserValueForRow(row);
                            if (userValue != null) {
                                this.performDefaultAction(userValue);
                            }
                        }
                    }
                });
            }

            @Override
            protected void performDefaultAction(ClientUtils.SourceCodeSelection userValue) {
                if (LiveJDBCView.this.showSourceSupported()) {
                    LiveJDBCView.this.showSource(userValue);
                }
            }

            @Override
            protected void populatePopup(JPopupMenu popup, Object value, ClientUtils.SourceCodeSelection userValue) {
                LiveJDBCView.this.populatePopup(LiveJDBCView.this.jdbcCallsView, popup, value, userValue);
            }

            @Override
            protected void popupShowing() {
                LiveJDBCView.this.popupShowing();
            }

            @Override
            protected void popupHidden() {
                LiveJDBCView.this.popupHidden();
            }

            @Override
            protected boolean hasBottomFilterFindMargin() {
                return true;
            }
        };
        this.jdbcCallsView.notifyOnFocus(new Runnable(){

            @Override
            public void run() {
                LiveJDBCView.this.lastFocused = LiveJDBCView.this.jdbcCallsView;
            }
        });
        this.add((Component)this.jdbcCallsView, "Center");
    }

    private void registerActions() {
        ActionMap map = this.getActionMap();
        map.put("filter-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateFilter();
                }
            }
        });
        map.put("find-action-key", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DataView active = LiveJDBCView.this.getLastFocused();
                if (active != null) {
                    active.activateSearch();
                }
            }
        });
    }

    private DataView getLastFocused() {
        if (this.lastFocused != null && !this.lastFocused.isShowing()) {
            this.lastFocused = null;
        }
        if (this.lastFocused == null && this.jdbcCallsView.isShowing()) {
            this.lastFocused = this.jdbcCallsView;
        }
        return this.lastFocused;
    }

    private void showQueryImpl(PresoObjAllocCCTNode node) {
        this.showSQLQuery(node.getNodeName(), ((JDBCTreeTableView.SQLQueryNode)node).htmlName);
    }

    private void populatePopup(final DataView invoker, JPopupMenu popup, final Object value, final ClientUtils.SourceCodeSelection userValue) {
        final PresoObjAllocCCTNode node = (PresoObjAllocCCTNode)value;
        if (JDBCTreeTableView.isSQL(node)) {
            popup.add(new JMenuItem(JDBCView.ACTION_VIEWSQLQUERY){
                {
                    super(x0);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.showQueryImpl((JDBCTreeTableView.SQLQueryNode)((Object)value));
                }
            });
            popup.addSeparator();
        } else if (this.showSourceSupported()) {
            popup.add(new JMenuItem(JDBCView.ACTION_GOTOSOURCE){
                {
                    super(x0);
                    this.setEnabled(userValue != null);
                    this.setFont(this.getFont().deriveFont(1));
                }

                @Override
                protected void fireActionPerformed(ActionEvent e) {
                    LiveJDBCView.this.showSource(userValue);
                }
            });
            popup.addSeparator();
        }
        popup.add(new JMenuItem(JDBCView.ACTION_PROFILE_METHOD){
            {
                super(x0);
                this.setEnabled(userValue != null && JDBCTreeTableView.isSelectable(node));
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LiveJDBCView.this.profileMethod(userValue);
            }
        });
        popup.add(new JMenuItem(JDBCView.ACTION_PROFILE_CLASS){
            {
                super(x0);
                this.setEnabled(userValue != null);
            }

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                LiveJDBCView.this.profileClass(userValue);
            }
        });
        popup.addSeparator();
        popup.add(invoker.createCopyMenuItem());
        popup.addSeparator();
        popup.add(new JMenuItem(FilterUtils.ACTION_FILTER){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateFilter();
            }
        });
        popup.add(new JMenuItem(SearchUtils.ACTION_FIND){

            @Override
            protected void fireActionPerformed(ActionEvent e) {
                invoker.activateSearch();
            }
        });
    }

    private synchronized ExecutorService getExecutor() {
        if (this.executor == null) {
            this.executor = Executors.newSingleThreadExecutor();
        }
        return this.executor;
    }

    private final class ResultsMonitor
    implements JdbcCCTProvider.Listener {
        private ResultsMonitor() {
        }

        public void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty) {
                try {
                    LiveJDBCView.this.refreshData(appRootNode);
                }
                catch (ClientUtils.TargetAppOrVMTerminated ex) {
                    Logger.getLogger(LiveMemoryView.class.getName()).log(Level.FINE, null, ex);
                }
            }
        }

        public void cctReset() {
            LiveJDBCView.this.resetData();
        }
    }
}

