/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.git.remote.cli.GitCherryPickResult;
import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitRevisionInfo;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.CommitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class CherryPickCommand
extends GitCommand {
    private final String[] revisions;
    private GitCherryPickResult result;
    private final ProgressMonitor monitor;
    private final GitClient.CherryPickOperation operation;
    private final FileListener listener;
    private static final String SEQUENCER = "sequencer";
    private static final String SEQUENCER_HEAD = "head";
    private static final String SEQUENCER_TODO = "todo";
    private final GitCommand.Revision revisionPlaseHolder;

    public CherryPickCommand(JGitRepository repository, GitClassFactory gitFactory, String[] revisions, GitClient.CherryPickOperation operation, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.revisions = revisions;
        this.operation = operation;
        this.monitor = monitor;
        this.listener = listener;
        this.revisionPlaseHolder = new GitCommand.Revision();
    }

    public GitCherryPickResult getResult() {
        return this.result;
    }

    @Override
    protected void prepare() throws GitException {
        this.setCommandsNumber(2);
        super.prepare();
        this.addArgument(0, "cherry-pick");
        if (this.operation == GitClient.CherryPickOperation.BEGIN) {
            for (String rev : this.revisions) {
                this.addArgument(0, rev);
            }
        } else {
            this.addArgument(0, this.operation.toString());
        }
        this.addArgument(1, "log");
        this.addArgument(1, "--raw");
        this.addArgument(1, "--pretty=raw");
        this.addArgument(1, "-1");
        this.addArgument(1, this.revisionPlaseHolder);
    }

    @Override
    protected void run() throws GitException {
        block5: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                final CherryPickedResultContainer cherry = new CherryPickedResultContainer();
                cherry.mergeStatus = GitCherryPickResult.CherryPickStatus.OK;
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                        CherryPickCommand.this.parseCherryPickedOutput(output, cherry);
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        CherryPickCommand.this.parseCherryPickedError(error, cherry);
                    }
                }.runCLI();
                GitRevisionInfo revision = null;
                if (cherry.currentHead != null) {
                    this.revisionPlaseHolder.setContent(cherry.currentHead);
                    final GitRevisionInfo.GitRevCommit status = new GitRevisionInfo.GitRevCommit();
                    new GitCommand.Runner(canceled, 1){

                        @Override
                        public void outputParser(String output) throws GitException {
                            CommitCommand.parseLog(output, status);
                        }
                    }.runCLI();
                    revision = this.getClassFactory().createRevisionInfo(status, this.getRepository());
                }
                this.result = this.getClassFactory().createCherryPickResult(cherry.mergeStatus, cherry.conflicts, cherry.failures, revision, cherry.cherryPickedCommits);
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block5;
                throw new GitException(t);
            }
        }
    }

    private void parseCherryPickedOutput(String output, CherryPickedResultContainer merge) {
        merge.mergeStatus = GitCherryPickResult.CherryPickStatus.OK;
        for (String line : output.split("\n")) {
            if (!line.startsWith("[") || line.indexOf(93) <= 0) continue;
            String[] s = line.substring(1, line.indexOf(93)).trim().split(" ");
            merge.currentHead = s[s.length - 1];
        }
    }

    private void parseCherryPickedError(String output, CherryPickedResultContainer merge) {
        merge.mergeStatus = GitCherryPickResult.CherryPickStatus.FAILED;
        for (String line : output.split("\n")) {
            if (line.startsWith("error: could not apply")) {
                merge.mergeStatus = GitCherryPickResult.CherryPickStatus.FAILED;
                String[] s = line.substring(22).trim().split(" ");
                String rev = s[0];
                if (rev.indexOf(46) > 0) {
                    rev = rev.substring(0, rev.indexOf(46));
                }
                merge.currentHead = rev;
                continue;
            }
            if (!line.startsWith("Aborting")) continue;
            merge.mergeStatus = GitCherryPickResult.CherryPickStatus.FAILED;
        }
    }

    private static final class CherryPickedResultContainer {
        public GitCherryPickResult.CherryPickStatus mergeStatus;
        public List<VCSFileProxy> conflicts = new ArrayList<VCSFileProxy>();
        public List<VCSFileProxy> failures = new ArrayList<VCSFileProxy>();
        public String currentHead;
        public List<GitRevisionInfo> cherryPickedCommits = new ArrayList<GitRevisionInfo>();

        private CherryPickedResultContainer() {
        }
    }
}

