/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import org.netbeans.modules.git.remote.cli.jgit.Utils;

public enum GitRepositoryState {
    BARE{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Bare");
        }
    }
    ,
    SAFE{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Safe");
        }
    }
    ,
    MERGING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Merging");
        }
    }
    ,
    MERGING_RESOLVED{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Merged");
        }
    }
    ,
    CHERRY_PICKING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return false;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_CherryPicking");
        }
    }
    ,
    CHERRY_PICKING_RESOLVED{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return true;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_CherryPickingResolved");
        }
    }
    ,
    REBASING{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Rebasing");
        }
    }
    ,
    APPLY{

        @Override
        public boolean canCheckout() {
            return false;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Apply");
        }
    }
    ,
    BISECTING{

        @Override
        public boolean canCheckout() {
            return true;
        }

        @Override
        public boolean canResetHead() {
            return false;
        }

        @Override
        public boolean canCommit() {
            return true;
        }

        public String toString() {
            return Utils.getBundle(GitRepositoryState.class).getString("LBL_RepositoryInfo_Bisecting");
        }
    };


    public abstract boolean canCheckout();

    public abstract boolean canCommit();

    public abstract boolean canResetHead();
}

