/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.gotodeclaration.type;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmMember;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmNamespace;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.services.CsmCacheManager;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.services.CsmVisibilityQuery;
import org.netbeans.modules.cnd.api.model.support.CsmClassifierResolver;
import org.netbeans.modules.cnd.gotodeclaration.type.CppTypeDescriptor;
import org.netbeans.modules.cnd.gotodeclaration.type.TracingTypeDescriptor;
import org.netbeans.spi.jumpto.support.NameMatcher;
import org.netbeans.spi.jumpto.support.NameMatcherFactory;
import org.netbeans.spi.jumpto.type.SearchType;
import org.netbeans.spi.jumpto.type.TypeDescriptor;
import org.netbeans.spi.jumpto.type.TypeProvider;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class CppTypeProvider
implements TypeProvider {
    private static final boolean PROCESS_LIBRARIES = true;
    private static final boolean TRACE = Boolean.getBoolean("cnd.type.provider.trace");
    private static final Logger LOG = TRACE ? Logger.getLogger("cnd.type.provider.trace") : null;
    private static final RequestProcessor RP = new RequestProcessor(CppTypeProvider.class.getName(), 1);
    private static final Object resultLock = new Object();
    private final Object activeTaskLock = new Object();
    private WorkerTask activeTask;

    public CppTypeProvider() {
        if (TRACE) {
            LOG.info("CppTypeProvider created");
        }
    }

    public String name() {
        return "C/C++";
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CppTypeProvider.class, (String)"TYPE_PROVIDER_DISPLAY_NAME");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTypeNames(TypeProvider.Context context, TypeProvider.Result res) {
        WorkerTask task;
        if (TRACE) {
            LOG.log(Level.INFO, "computeTypeNames request at {0} ms.", System.currentTimeMillis());
        }
        Object object = this.activeTaskLock;
        synchronized (object) {
            task = this.activeTask;
            if (task != null && !CppTypeProvider.sameContext(task.context, context)) {
                task.cancel();
                task = null;
                this.activeTask = null;
            }
            if (task == null) {
                this.activeTask = task = new WorkerTask(context);
                RP.submit((Runnable)task);
            }
        }
        while (!task.isDone()) {
            try {
                task.get(200L, TimeUnit.MILLISECONDS);
            }
            catch (TimeoutException ex) {
                break;
            }
            catch (InterruptedException ex) {
                task.cancel();
                Thread.interrupted();
                if (!TRACE) break;
                LOG.log(Level.INFO, "InterruptedException");
                break;
            }
            catch (CancellationException ex) {
                if (!TRACE) break;
                LOG.log(Level.INFO, "CancellationException");
                break;
            }
            catch (ExecutionException ex) {
                if (ex.getCause() instanceof CancellationException) break;
                Exceptions.printStackTrace((Throwable)ex);
                break;
            }
        }
        if (!task.isDone()) {
            res.pendingResult();
            if (TRACE) {
                LOG.log(Level.INFO, "Results are not fully available yet at {0} ms.", System.currentTimeMillis());
            }
        }
        res.addResult(task.getResult());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        WorkerTask task;
        if (TRACE) {
            LOG.info("cancel request");
        }
        Object object = this.activeTaskLock;
        synchronized (object) {
            task = this.activeTask;
            this.activeTask = null;
        }
        if (task != null) {
            task.cancel();
        }
    }

    public void cleanup() {
        if (TRACE) {
            LOG.info("cleanup request");
        }
        this.cancel();
    }

    private static TypeDescriptor createTypeDescriptor(CsmClassifier classifier) {
        CppTypeDescriptor descriptor = new CppTypeDescriptor(classifier);
        return TRACE ? new TracingTypeDescriptor(descriptor) : descriptor;
    }

    private static boolean sameContext(TypeProvider.Context context1, TypeProvider.Context context2) {
        if (context1 == null) {
            return context2 == null;
        }
        if (context2 == null) {
            return false;
        }
        if (!context1.getSearchType().equals((Object)context2.getSearchType())) {
            return false;
        }
        return context1.getText().equals(context2.getText());
    }

    private static class Worker
    implements Runnable {
        private final TypeProvider.Context context;
        private final Set<TypeDescriptor> result;
        private long startTime;
        private final AtomicBoolean cancelled;

        private Worker(TypeProvider.Context context, Set<TypeDescriptor> result, AtomicBoolean cancelled) {
            if (TRACE) {
                LOG.log(Level.INFO, "New Worker for searching \"{0}\", {1} in {2} created.", new Object[]{context.getText(), context.getSearchType().name(), context.getProject()});
            }
            this.context = context;
            this.result = result;
            this.cancelled = cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (TRACE) {
                this.startTime = System.currentTimeMillis();
            }
            try {
                Project project = this.context.getProject();
                String text = this.context.getText();
                SearchType type = this.context.getSearchType();
                CsmCacheManager.enter();
                try {
                    CsmSelect.CsmFilter filter = CsmSelect.CLASSIFIER_KIND_FILTER;
                    NameMatcher matcher = NameMatcherFactory.createNameMatcher((String)text, (SearchType)type);
                    if (project == null) {
                        Collection csmProjects = CsmModelAccessor.getModel().projects();
                        if (!csmProjects.isEmpty()) {
                            for (CsmProject csmProject : csmProjects) {
                                this.checkCancelled();
                                this.processProject(csmProject, filter, matcher);
                            }
                            for (CsmProject csmProject : csmProjects) {
                                this.checkCancelled();
                                HashSet<CsmProject> processedLibs = new HashSet<CsmProject>();
                                this.processProjectLibs(csmProject, filter, processedLibs, matcher);
                            }
                        }
                    } else {
                        CsmProject csmProject = CsmModelAccessor.getModel().getProject((Object)project);
                        this.processProject(csmProject, filter, matcher);
                        this.processProjectLibs(csmProject, filter, new HashSet<CsmProject>(), matcher);
                    }
                }
                finally {
                    CsmCacheManager.leave();
                }
            }
            catch (CancellationException ex) {
                block17: {
                    try {
                        if (!TRACE) break block17;
                        LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} cancelled [after {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                    }
                    catch (Throwable throwable) {
                        if (TRACE) {
                            LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                        }
                        throw throwable;
                    }
                }
                if (TRACE) {
                    LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
                }
            }
            if (TRACE) {
                LOG.log(Level.INFO, "Worker for searching \"{0}\", {1} in {2} done [in {3} ms.].", new Object[]{this.context.getText(), this.context.getSearchType().name(), this.context.getProject(), System.currentTimeMillis() - this.startTime});
            }
        }

        private void processProjectLibs(CsmProject project, CsmSelect.CsmFilter filter, Set<CsmProject> processedLibs, NameMatcher matcher) {
            for (CsmProject lib : project.getLibraries()) {
                this.checkCancelled();
                if (!lib.isArtificial() || processedLibs.contains(lib)) continue;
                processedLibs.add(lib);
                this.processProject(lib, filter, matcher);
            }
        }

        private void processProject(CsmProject project, CsmSelect.CsmFilter filter, NameMatcher matcher) {
            this.checkCancelled();
            this.processNamespace(project.getGlobalNamespace(), filter, matcher);
        }

        private void processNamespace(CsmNamespace nsp, CsmSelect.CsmFilter filter, NameMatcher matcher) {
            this.checkCancelled();
            Iterator iter = CsmSelect.getDeclarations((CsmNamespace)nsp, (CsmSelect.CsmFilter)filter);
            while (iter.hasNext()) {
                this.checkCancelled();
                CsmDeclaration declaration = (CsmDeclaration)iter.next();
                this.processDeclaration(declaration, matcher);
            }
            for (CsmNamespace child : nsp.getNestedNamespaces()) {
                this.checkCancelled();
                this.processNamespace(child, filter, matcher);
            }
        }

        private void processDeclaration(CsmDeclaration decl, NameMatcher matcher) {
            this.checkCancelled();
            switch (decl.getKind()) {
                case CLASS: 
                case UNION: 
                case STRUCT: {
                    CsmClass cls = (CsmClass)decl;
                    if (CsmClassifierResolver.getDefault().isForwardClass((CsmObject)cls)) break;
                    if (matcher.accept(decl.getName().toString()) && CsmVisibilityQuery.isVisible((CsmObject)cls)) {
                        this.addResult((CsmClassifier)cls);
                    }
                    this.checkCancelled();
                    for (CsmMember member : cls.getMembers()) {
                        this.checkCancelled();
                        if (!matcher.accept(member.getName().toString())) continue;
                        this.processDeclaration((CsmDeclaration)member, matcher);
                    }
                    break;
                }
                case ENUM: 
                case TYPEDEF: {
                    if (!matcher.accept(decl.getName().toString()) || !CsmVisibilityQuery.isVisible((CsmObject)decl)) break;
                    this.addResult((CsmClassifier)decl);
                }
            }
        }

        private void checkCancelled() throws CancellationException {
            if (this.cancelled.get()) {
                throw new CancellationException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResult(CsmClassifier classifier) {
            TypeDescriptor typeDescriptor = CppTypeProvider.createTypeDescriptor(classifier);
            Object object = resultLock;
            synchronized (object) {
                this.result.add(typeDescriptor);
            }
        }
    }

    private static class WorkerTask
    extends FutureTask<Void> {
        private final Set<TypeDescriptor> result;
        private final TypeProvider.Context context;
        private final AtomicBoolean cancelled;

        public WorkerTask(TypeProvider.Context context) {
            this(context, new HashSet<TypeDescriptor>(), new AtomicBoolean(false));
        }

        private WorkerTask(TypeProvider.Context context, Set<TypeDescriptor> result, AtomicBoolean cancelled) {
            super(new Worker(context, result, cancelled), null);
            this.context = context;
            this.result = result;
            this.cancelled = cancelled;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<TypeDescriptor> getResult() {
            Object object = resultLock;
            synchronized (object) {
                return new ArrayList<TypeDescriptor>(this.result);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasResult() {
            Object object = resultLock;
            synchronized (object) {
                return !this.result.isEmpty();
            }
        }

        public void cancel() {
            this.cancelled.set(true);
        }
    }
}

