/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.oql.engine.api.impl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.modules.profiler.oql.engine.api.OQLEngine;
import org.netbeans.modules.profiler.oql.engine.api.OQLException;
import org.netbeans.modules.profiler.oql.engine.api.impl.Bundle;
import org.netbeans.modules.profiler.oql.engine.api.impl.OQLQueryImpl;
import org.netbeans.modules.profiler.oql.engine.api.impl.Snapshot;

public class OQLEngineImpl {
    private static final Logger LOGGER = Logger.getLogger(OQLEngineImpl.class.getName());
    private static boolean oqlSupported;
    private static final String HAT_JS_RHINO = "/org/netbeans/modules/profiler/oql/engine/api/impl/hat.js";
    private static final String NASHORN_ID = "Oracle Nashorn";
    private static final String HAT_JS_NASHORN = "/org/netbeans/modules/profiler/oql/engine/api/impl/hat_nashorn.js";
    private ScriptEngine engine;
    private Snapshot snapshot;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);

    public static boolean isOQLSupported() {
        return oqlSupported;
    }

    public OQLEngineImpl(Snapshot snapshot) {
        if (!OQLEngineImpl.isOQLSupported()) {
            throw new UnsupportedOperationException("OQL not supported");
        }
        this.init(snapshot);
    }

    public Snapshot getHeapHelper() {
        return this.snapshot;
    }

    public synchronized void executeQuery(String query, OQLEngine.ObjectVisitor visitor) throws OQLException {
        LOGGER.log(Level.FINE, query);
        OQLEngine.OQLQuery parsedQuery = this.parseQuery(query);
        if (parsedQuery == null) {
            try {
                Object res = this.evalScript(query);
                this.dispatchValue(res, visitor);
            }
            catch (Exception e) {
                throw new OQLException(e);
            }
            return;
        }
        this.executeQuery((OQLQueryImpl)parsedQuery, visitor);
    }

    public OQLEngine.OQLQuery parseQuery(String query) throws OQLException {
        StringTokenizer st = new StringTokenizer(query);
        if (st.hasMoreTokens()) {
            String first = st.nextToken();
            if (!first.equals("select")) {
                return null;
            }
        } else {
            throw new OQLException(Bundle.ERROR_NO_SELECT_CLAUSE());
        }
        String selectExpr = "";
        boolean seenFrom = false;
        while (st.hasMoreTokens()) {
            String tok = st.nextToken();
            if (tok.equals("from")) {
                seenFrom = true;
                break;
            }
            selectExpr = selectExpr + " " + tok;
        }
        if (selectExpr.isEmpty()) {
            throw new OQLException(Bundle.ERROR_EMPTY_SELECT());
        }
        String className = null;
        boolean isInstanceOf = false;
        String whereExpr = null;
        String identifier = null;
        if (seenFrom) {
            String tmp;
            if (st.hasMoreTokens()) {
                tmp = st.nextToken();
                if (tmp.equals("instanceof")) {
                    isInstanceOf = true;
                    if (!st.hasMoreTokens()) {
                        throw new OQLException(Bundle.ERROR_INSTANCEOF_NO_CLASSNAME());
                    }
                    className = st.nextToken();
                } else {
                    className = tmp;
                }
            } else {
                throw new OQLException(Bundle.ERROR_FROM_NO_CLASSNAME());
            }
            if (st.hasMoreTokens()) {
                identifier = st.nextToken();
                if (identifier.equals("where")) {
                    throw new OQLException(Bundle.ERROR_NO_IDENTIFIER());
                }
                if (st.hasMoreTokens()) {
                    tmp = st.nextToken();
                    if (!tmp.equals("where")) {
                        throw new OQLException(Bundle.ERROR_EXPECTING_WHERE());
                    }
                    whereExpr = "";
                    while (st.hasMoreTokens()) {
                        whereExpr = whereExpr + " " + st.nextToken();
                    }
                    if (whereExpr.isEmpty()) {
                        throw new OQLException(Bundle.ERROR_EMPTY_WHERE());
                    }
                }
            } else {
                throw new OQLException(Bundle.ERROR_NO_IDENTIFIER());
            }
        }
        return new OQLQueryImpl(selectExpr, isInstanceOf, className, identifier, whereExpr);
    }

    public void cancelQuery() throws OQLException {
        this.cancelled.set(true);
    }

    public boolean isCancelled() {
        return this.cancelled.get();
    }

    private void executeQuery(OQLQueryImpl q, OQLEngine.ObjectVisitor visitor) throws OQLException {
        String className;
        this.cancelled.set(false);
        visitor = visitor != null ? visitor : OQLEngine.ObjectVisitor.DEFAULT;
        JavaClass clazz = null;
        if (q.className != null && (clazz = this.snapshot.findClass(className = q.className)) == null) {
            throw new OQLException(className + " is not found!");
        }
        StringBuilder buf = new StringBuilder();
        buf.append("function __select__(");
        if (q.identifier != null) {
            buf.append(q.identifier);
        }
        buf.append(") { return ");
        buf.append(q.selectExpr.replace('\n', ' '));
        buf.append("; }\n");
        buf.append("__select__(").append(q.identifier).append(")");
        String selectCode = buf.toString();
        try {
            Bindings bindings = this.engine.getBindings(100);
            CompiledScript whereCs = null;
            CompiledScript selectCs = null;
            selectCs = ((Compilable)((Object)this.engine)).compile(selectCode);
            if (q.whereExpr != null) {
                whereCs = ((Compilable)((Object)this.engine)).compile(q.whereExpr.replace('\n', ' '));
            }
            if (q.className != null) {
                Stack<Object> toInspect = new Stack<Object>();
                HashSet inspected = new HashSet();
                toInspect.push(clazz);
                Object inspecting = null;
                while (!toInspect.isEmpty()) {
                    inspecting = toInspect.pop();
                    inspected.add(inspecting);
                    JavaClass clz = (JavaClass)inspecting;
                    if (q.isInstanceOf) {
                        for (Object subclass : clz.getSubClasses()) {
                            if (inspected.contains(subclass) || toInspect.contains(subclass)) continue;
                            toInspect.push(subclass);
                        }
                    }
                    List objects = clz.getInstances();
                    for (Object obj : objects) {
                        boolean b;
                        Object wrapped = this.wrapJavaObject((Instance)obj);
                        boolean bl = b = whereCs == null;
                        if (!b) {
                            bindings.put(q.identifier, wrapped);
                            Object res = whereCs.eval(bindings);
                            if (res instanceof Boolean) {
                                b = (Boolean)res;
                            } else if (res instanceof Number) {
                                b = ((Number)res).intValue() != 0;
                            } else {
                                boolean bl2 = b = res != null;
                            }
                        }
                        if (!b) continue;
                        bindings.put(q.identifier, wrapped);
                        Object select = selectCs.eval(bindings);
                        if (!this.dispatchValue(select, visitor)) continue;
                        return;
                    }
                }
            } else {
                Object select = selectCs.eval();
                if (this.dispatchValue(select, visitor)) {
                    return;
                }
            }
        }
        catch (Exception e) {
            throw new OQLException(e);
        }
    }

    private boolean dispatchValue(Object jsObject, OQLEngine.ObjectVisitor visitor) {
        if (jsObject == null) {
            return false;
        }
        if (jsObject instanceof Iterator) {
            Iterator iter = (Iterator)jsObject;
            while (iter.hasNext()) {
                if (!this.dispatchValue(iter.next(), visitor)) continue;
                return true;
            }
            return false;
        }
        if (jsObject instanceof Enumeration) {
            Enumeration enm = (Enumeration)jsObject;
            while (enm.hasMoreElements()) {
                Object elem = enm.nextElement();
                if (!this.dispatchValue(elem, visitor)) continue;
                return true;
            }
            return false;
        }
        Object object = this.unwrapJavaObject(jsObject, true);
        if (object instanceof Object[]) {
            for (Object obj1 : (Object[])object) {
                if (!this.dispatchValue(obj1, visitor)) continue;
                return true;
            }
            return false;
        }
        return visitor.visit(object);
    }

    public Object evalScript(String script) throws Exception {
        this.cancelled.set(false);
        CompiledScript cs = ((Compilable)((Object)this.engine)).compile(script);
        return cs.eval();
    }

    public Object wrapJavaObject(Instance obj) throws Exception {
        return this.call("wrapJavaObject", new Object[]{obj});
    }

    public Object toHtml(Object obj) throws Exception {
        return this.call("toHtml", new Object[]{obj});
    }

    public Object call(String func, Object[] args) throws Exception {
        return ((Invocable)((Object)this.engine)).invokeFunction(func, args);
    }

    public Object unwrapJavaObject(Object object) {
        return this.unwrapJavaObject(object, false);
    }

    public Object unwrapJavaObject(Object object, boolean tryAssociativeArray) {
        if (object == null) {
            return null;
        }
        String className = object.getClass().getName();
        boolean isNativeJS = className.contains(".javascript.") || className.equals("jdk.nashorn.api.scripting.ScriptObjectMirror");
        try {
            Object ret = ((Invocable)((Object)this.engine)).invokeFunction("unwrapJavaObject", object);
            if (isNativeJS && (ret == null || ret.equals(object)) && tryAssociativeArray) {
                ret = ((Invocable)((Object)this.engine)).invokeFunction("unwrapMap", object);
            }
            return ret;
        }
        catch (Exception ex) {
            LOGGER.log(Level.WARNING, "Error unwrapping JS object", ex);
            return null;
        }
    }

    private void init(Snapshot snapshot) throws RuntimeException {
        this.snapshot = snapshot;
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            this.engine = manager.getEngineByName("JavaScript");
            InputStream strm = this.getInitStream(this.engine.getFactory().getParameter("javax.script.engine"));
            CompiledScript cs = ((Compilable)((Object)this.engine)).compile(new InputStreamReader(strm));
            cs.eval();
            Object heap = ((Invocable)((Object)this.engine)).invokeFunction("wrapHeapSnapshot", snapshot);
            this.engine.put("heap", heap);
            this.engine.put("cancelled", this.cancelled);
        }
        catch (Exception ex) {
            LOGGER.log(Level.SEVERE, "Error initializing snapshot", ex);
            throw new RuntimeException(ex);
        }
    }

    private InputStream getInitStream(Object engineId) {
        String hatjs = engineId != null && NASHORN_ID.equals(engineId.toString()) ? HAT_JS_NASHORN : HAT_JS_RHINO;
        return this.getClass().getResourceAsStream(hatjs);
    }

    static {
        try {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            oqlSupported = engine != null;
        }
        catch (Throwable ex) {
            LOGGER.log(Level.INFO, "OQLEngine init", ex);
            oqlSupported = false;
        }
    }
}

