/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.build2;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.netbeans.modules.docker.ui.UiUtils;
import org.netbeans.modules.docker.ui.build2.Bundle;
import org.openide.awt.Mnemonics;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;

public final class BuildContextVisual
extends JPanel {
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
    private JButton buildContextButton;
    private JTextField buildContextTextField;
    private JLabel buldContextLabel;
    private JComboBox<String> repositoryComboBox;
    private JLabel repositoryLabel;
    private JLabel tagLabel;
    private JTextField tagTextField;

    public BuildContextVisual() {
        this.initComponents();
        DefaultDocumentListener listener = new DefaultDocumentListener();
        this.buildContextTextField.getDocument().addDocumentListener(listener);
        ((JTextComponent)this.repositoryComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(listener);
        this.tagTextField.getDocument().addDocumentListener(listener);
        this.repositoryComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BuildContextVisual.this.changeSupport.fireChange();
            }
        });
    }

    public void addChangeListener(ChangeListener l) {
        this.changeSupport.addChangeListener(l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.changeSupport.removeChangeListener(l);
    }

    public String getBuildContext() {
        return UiUtils.getValue(this.buildContextTextField);
    }

    public void setBuildContext(String buildContext) {
        this.buildContextTextField.setText(buildContext);
    }

    public String getRepository() {
        return UiUtils.getValue(this.repositoryComboBox);
    }

    public void setRepository(String repository) {
        this.repositoryComboBox.getEditor().setItem(repository);
    }

    public String getTag() {
        return UiUtils.getValue(this.tagTextField);
    }

    public void setTag(String tag) {
        this.tagTextField.setText(tag);
    }

    @Override
    public String getName() {
        return Bundle.LBL_BuildContext();
    }

    private void initComponents() {
        this.buldContextLabel = new JLabel();
        this.buildContextTextField = new JTextField();
        this.buildContextButton = new JButton();
        this.repositoryLabel = new JLabel();
        this.repositoryComboBox = new JComboBox();
        this.tagLabel = new JLabel();
        this.tagTextField = new JTextField();
        this.buldContextLabel.setLabelFor(this.buildContextTextField);
        Mnemonics.setLocalizedText((JLabel)this.buldContextLabel, (String)NbBundle.getMessage(BuildContextVisual.class, (String)"BuildContextVisual.buldContextLabel.text"));
        this.buildContextTextField.setColumns(10);
        Mnemonics.setLocalizedText((AbstractButton)this.buildContextButton, (String)NbBundle.getMessage(BuildContextVisual.class, (String)"BuildContextVisual.buildContextButton.text"));
        this.buildContextButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildContextVisual.this.buildContextButtonActionPerformed(evt);
            }
        });
        this.repositoryLabel.setLabelFor(this.repositoryComboBox);
        Mnemonics.setLocalizedText((JLabel)this.repositoryLabel, (String)NbBundle.getMessage(BuildContextVisual.class, (String)"BuildContextVisual.repositoryLabel.text"));
        this.repositoryComboBox.setEditable(true);
        this.tagLabel.setLabelFor(this.tagTextField);
        Mnemonics.setLocalizedText((JLabel)this.tagLabel, (String)NbBundle.getMessage(BuildContextVisual.class, (String)"BuildContextVisual.tagLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.buldContextLabel).addComponent(this.repositoryLabel).addComponent(this.tagLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.buildContextTextField, -1, 221, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.buildContextButton)).addComponent(this.repositoryComboBox, 0, -1, Short.MAX_VALUE).addComponent(this.tagTextField))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.buldContextLabel).addComponent(this.buildContextTextField, -2, -1, -2).addComponent(this.buildContextButton)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.repositoryLabel).addComponent(this.repositoryComboBox, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.tagLabel).addComponent(this.tagTextField, -2, -1, -2))));
    }

    private void buildContextButtonActionPerformed(ActionEvent evt) {
        JFileChooser chooser = new JFileChooser();
        chooser.setFileSelectionMode(1);
        String buildText = UiUtils.getValue(this.buildContextTextField);
        if (buildText != null) {
            chooser.setSelectedFile(new File(buildText));
        }
        if (chooser.showOpenDialog(SwingUtilities.getWindowAncestor(this)) == 0) {
            this.buildContextTextField.setText(chooser.getSelectedFile().getAbsolutePath());
        }
    }

    private class DefaultDocumentListener
    implements DocumentListener {
        private DefaultDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            BuildContextVisual.this.changeSupport.fireChange();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            BuildContextVisual.this.changeSupport.fireChange();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            BuildContextVisual.this.changeSupport.fireChange();
        }
    }
}

