/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.utils;

import org.netbeans.modules.cnd.spi.utils.ComponentVersionProvider;
import org.openide.util.Lookup;

public enum ComponentType {
    CND("cnd"),
    OSS_IDE("sside"),
    DBXTOOL("dbxtool"),
    DLIGHTTOOL("dlighttool"),
    CODE_ANALYZER("analytics"),
    PROJECT_CREATOR("ide_project");

    private static ComponentType component;
    private String version = "";
    private final String tag;

    private ComponentType(String tag) {
        this.tag = tag;
    }

    public String getTag() {
        return this.tag;
    }

    public static ComponentType getComponent() {
        if (component == null) {
            component = CND;
            String ide = System.getProperty("spro.ide.name");
            for (ComponentType c : ComponentType.values()) {
                if (!c.getTag().equals(ide)) continue;
                component = c;
                break;
            }
        }
        return component;
    }

    public static String getVersion() {
        ComponentType current = ComponentType.getComponent();
        if (current.version == null) {
            for (ComponentVersionProvider provider : Lookup.getDefault().lookupAll(ComponentVersionProvider.class)) {
                String version = provider.getVersion(current.getTag());
                if (version == null) continue;
                current.version = version;
                break;
            }
        }
        return current.version;
    }

    public static String getFullName() {
        return ComponentType.getComponent().toString() + " " + ComponentType.getVersion();
    }
}

