/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import org.netbeans.modules.javadoc.search.DocIndexItem;
import org.netbeans.modules.javadoc.search.IndexSearch;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.JavadocRegistry;
import org.netbeans.modules.javadoc.search.JavadocSearchEngine;
import org.netbeans.modules.javadoc.search.JavadocSearchType;
import org.netbeans.modules.javadoc.search.NoJavadocException;
import org.openide.ErrorManager;

final class JavadocSearchEngineImpl
extends JavadocSearchEngine {
    private final List<IndexSearchThread> tasks = new ArrayList<IndexSearchThread>();
    private IndexSearchThread.DocIndexItemConsumer diiConsumer;
    private boolean isStopped = false;

    JavadocSearchEngineImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void search(String[] items, final JavadocSearchEngine.SearchEngineCallback callback) throws NoJavadocException {
        this.diiConsumer = new IndexSearchThread.DocIndexItemConsumer(){

            @Override
            public void addDocIndexItem(DocIndexItem dii) {
                callback.addItem(dii);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void indexSearchThreadFinished(IndexSearchThread t) {
                boolean isEmpty;
                JavadocSearchEngineImpl javadocSearchEngineImpl = JavadocSearchEngineImpl.this;
                synchronized (javadocSearchEngineImpl) {
                    IndexSearch.LOG.log(Level.FINE, "JavadocSearchEngineImpl.indexSearchThreadFinished: tasks: {0}", JavadocSearchEngineImpl.this.tasks.size());
                    JavadocSearchEngineImpl.this.tasks.remove(t);
                    isEmpty = JavadocSearchEngineImpl.this.tasks.isEmpty();
                }
                if (isEmpty) {
                    callback.finished();
                }
            }
        };
        URL[] docRoots = JavadocRegistry.getDefault().getDocRoots();
        IndexSearchThread[] indexSearchThreadArray = this;
        // MONITORENTER : this
        if (this.isStopped) {
            // MONITOREXIT : indexSearchThreadArray
            return;
        }
        // MONITOREXIT : indexSearchThreadArray
        if (docRoots.length <= 0) {
            callback.finished();
            throw new NoJavadocException();
        }
        String toFind = items[0];
        for (int i = 0; i < docRoots.length; ++i) {
            JavadocSearchType st = JavadocRegistry.getDefault().findSearchType(docRoots[i]);
            if (st == null) {
                ErrorManager.getDefault().log("NO Search type for " + docRoots[i]);
                continue;
            }
            URL indexFo = st.getDocFileObject(docRoots[i]);
            if (indexFo == null) {
                ErrorManager.getDefault().log("NO Index files fot " + docRoots[i]);
                continue;
            }
            IndexSearchThread searchThread = st.getSearchThread(toFind, indexFo, this.diiConsumer);
            IndexSearchThread[] indexSearchThreadArray2 = this;
            // MONITORENTER : this
            if (this.isStopped) {
                // MONITOREXIT : indexSearchThreadArray2
                return;
            }
            this.tasks.add(searchThread);
            // MONITOREXIT : indexSearchThreadArray2
        }
        IndexSearchThread[] indexSearchThreadArray3 = this;
        // MONITORENTER : this
        IndexSearchThread[] tasksArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
        // MONITOREXIT : indexSearchThreadArray3
        indexSearchThreadArray3 = tasksArray;
        int n = indexSearchThreadArray3.length;
        int n2 = 0;
        while (n2 < n) {
            IndexSearchThread searchThread = indexSearchThreadArray3[n2];
            if (this.isStopped) {
                return;
            }
            searchThread.go();
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        IndexSearchThread[] tasksArray = null;
        IndexSearchThread[] indexSearchThreadArray = this;
        synchronized (this) {
            if (this.isStopped) {
                // ** MonitorExit[var3_2] (shouldn't be in output)
                return;
            }
            this.isStopped = true;
            boolean noTask = this.tasks.isEmpty();
            if (!noTask) {
                tasksArray = this.tasks.toArray(new IndexSearchThread[this.tasks.size()]);
            }
            // ** MonitorExit[var3_2] (shouldn't be in output)
            IndexSearch.LOG.fine("JavadocSearchEngineImpl.stop");
            if (noTask) {
                this.diiConsumer.indexSearchThreadFinished(null);
                return;
            }
            for (IndexSearchThread searchThread : tasksArray) {
                searchThread.finish();
            }
            return;
        }
    }
}

